/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.internal.core;

import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.api.utils.exceptions.ObElementNotFoundException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.internal.core.model.MetamodelExtensions;
import com.modeliosoft.modelio.core.jni.INativeModelChangeEvent;
import com.modeliosoft.modelio.core.jni.INativeModelChangeListener;
import com.modeliosoft.modelio.core.jni.INativeStatusChangeEvent;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.model.IMetamodelExtensions;
import com.modeliosoft.modelio.core.model.IModel;
import com.modeliosoft.modelio.core.model.PredefinedTypes;
import com.modeliosoft.modelio.core.model.change.IModelChangeEvent;
import com.modeliosoft.modelio.core.model.change.IModelChangeHandler;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import com.modeliosoft.modelio.core.model.change.IStatusChangeEvent;
import com.modeliosoft.modelio.core.model.change.IStatusChangeHandler;
import com.modeliosoft.modelio.core.model.change.IStatusChangeListener;
import com.modeliosoft.modelio.core.model.change.ModelChangeEvent;
import com.modeliosoft.modelio.core.model.change.StatusChangeEvent;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class ModelImpl
implements IModel,
INativeModelChangeListener {
    private List<IModelChangeHandler> modelChangeHandlers = null;
    private List<IModelChangeListener> modelChangeListeners = null;
    private List<IStatusChangeHandler> statusChangeHandlers = null;
    private MetamodelExtensions metamodelExtension = null;
    private List<IStatusChangeListener> statusChangeListeners = null;
    private PredefinedTypes predefinedTypes = null;
    private IModelingSession session = null;

    public ModelImpl(IModelingSession session) {
        this.session = session;
        this.modelChangeListeners = new CopyOnWriteArrayList();
        this.statusChangeListeners = new CopyOnWriteArrayList();
        this.modelChangeHandlers = new CopyOnWriteArrayList();
        this.statusChangeHandlers = new CopyOnWriteArrayList();
        this.metamodelExtension = new MetamodelExtensions((IModel)this);
        this.predefinedTypes = new PredefinedTypes((IModel)this);
    }

    public void addModelHandler(IModelChangeHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        this.modelChangeHandlers.add(handler);
    }

    public void addModelListener(IModelChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        this.modelChangeListeners.add(listener);
    }

    public void addStatusHandler(IStatusChangeHandler handler) {
        if (handler == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        this.statusChangeHandlers.add(handler);
    }

    public void addStatusListener(IStatusChangeListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument must not be null.");
        }
        this.statusChangeListeners.add(listener);
    }

    public void dispose() {
        this.modelChangeListeners = null;
        this.statusChangeListeners = null;
        this.modelChangeHandlers = null;
        this.statusChangeHandlers = null;
    }

    public List<IElement> findByAtt(Class<? extends IElement> metaclass, String att, String value) {
        return this.session.getNativeSession().findByAtt(metaclass, att, value);
    }

    public List<IElement> findByClass(Class<? extends IElement> metaclass) {
        return this.session.getNativeSession().findByClass(metaclass);
    }

    public IElement findByRef(ObRef ref) {
        try {
            return this.session.getNativeSession().findByRef(ref);
        }
        catch (ObElementNotFoundException e) {
            return null;
        }
    }

    public void fireModelChangeHandlers(INativeModelChangeEvent event) {
        ModelChangeEvent ev = new ModelChangeEvent(event);
        for (IModelChangeHandler l : this.modelChangeHandlers) {
            try {
                l.handleModelChange(this.session, (IModelChangeEvent)ev);
            }
            catch (RuntimeException e) {
                LOG.error((String)"org.modelio.core", (Throwable)e);
            }
            catch (LinkageError e) {
                LOG.error((String)"org.modelio.core", (Throwable)e);
            }
        }
    }

    public void fireModelChanged(INativeModelChangeEvent event) {
        ModelChangeEvent ev = new ModelChangeEvent(event);
        for (IModelChangeListener l : this.modelChangeListeners) {
            try {
                l.modelChanged(this.session, (IModelChangeEvent)ev);
            }
            catch (RuntimeException e) {
                LOG.error((String)"org.modelio.core", (Throwable)e);
            }
            catch (LinkageError e) {
                LOG.error((String)"org.modelio.core", (Throwable)e);
            }
        }
    }

    public void fireStatusChangeHandlers(INativeStatusChangeEvent event) {
        StatusChangeEvent ev = new StatusChangeEvent(event);
        for (IStatusChangeHandler l : this.statusChangeHandlers) {
            try {
                l.handleStatusChange(this.session, (IStatusChangeEvent)ev);
            }
            catch (RuntimeException e) {
                LOG.error((String)"org.modelio.core", (Throwable)e);
            }
            catch (LinkageError e) {
                LOG.error((String)"org.modelio.core", (Throwable)e);
            }
        }
    }

    public void fireStatusChanged(INativeStatusChangeEvent event) {
        StatusChangeEvent ev = new StatusChangeEvent(event);
        for (IStatusChangeListener l : this.statusChangeListeners) {
            try {
                l.statusChanged(this.session, (IStatusChangeEvent)ev);
            }
            catch (RuntimeException e) {
                LOG.error((String)"org.modelio.core", (Throwable)e);
            }
            catch (LinkageError e) {
                LOG.error((String)"org.modelio.core", (Throwable)e);
            }
        }
    }

    public IMetamodelExtensions getMetamodelExtensions() {
        return this.metamodelExtension;
    }

    public PredefinedTypes getPredefinedTypes() {
        return this.predefinedTypes;
    }

    public IProject getPredefinedTypesProject() {
        return null;
    }

    public IProject getProject() {
        return this.session.getNativeSession().getProject();
    }

    public void postInit() {
        this.metamodelExtension.postInit(this.session.getMdacRegistry());
    }

    public void removeModelHandler(IModelChangeHandler handler) {
        this.modelChangeHandlers.remove(handler);
    }

    public void removeModelListener(IModelChangeListener listener) {
        this.modelChangeListeners.remove(listener);
    }

    public void removeStatusHandler(IStatusChangeHandler handler) {
        this.statusChangeHandlers.remove(handler);
    }

    public void removeStatusListener(IStatusChangeListener listener) {
        this.statusChangeListeners.remove(listener);
    }
}

