/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.internal.core.app;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.app.events.ISessionListener;
import com.modeliosoft.modelio.core.app.events.ISessionService;
import com.modeliosoft.modelio.core.internal.core.app.SessionService;
import com.modeliosoft.modelio.core.plugin.Core;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;

public class SessionService
implements ISessionService {
    private List<ISessionListener> listeners = new ArrayList();
    private List<IModelingSession> openedSessions = new ArrayList();
    private static final String SESSIONLISTENER_EXTENSION_ID = "org.modelio.session";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSessionListener(ISessionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener must not be null.");
        }
        SessionService sessionService = this;
        synchronized (sessionService) {
            this.listeners.add(listener);
            for (IModelingSession session : this.openedSessions) {
                listener.sessionOpened(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSessionClosed(IModelingSession session) {
        SessionService sessionService = this;
        synchronized (sessionService) {
            IConfigurationElement[] config;
            SafeCloseSessionRunner r = new SafeCloseSessionRunner(session);
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(SESSIONLISTENER_EXTENSION_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                try {
                    Object o = e.createExecutableExtension("class");
                    if (o instanceof ISessionListener) {
                        r.listener = (ISessionListener)o;
                        SafeRunner.run((ISafeRunnable)r);
                    }
                }
                catch (CoreException e1) {
                    Core.LOG.warning((Throwable)e1);
                }
                ++n2;
            }
            Iterator iterator = new ArrayList(this.listeners).iterator();
            while (iterator.hasNext()) {
                ISessionListener l;
                r.listener = l = (ISessionListener)iterator.next();
                SafeRunner.run((ISafeRunnable)r);
            }
            this.openedSessions.remove(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireSessionOpened(IModelingSession session) {
        SessionService sessionService = this;
        synchronized (sessionService) {
            IConfigurationElement[] config;
            this.openedSessions.add(session);
            SafeOpenSessionRunner r = new SafeOpenSessionRunner(session);
            IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(SESSIONLISTENER_EXTENSION_ID);
            int n = config.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                try {
                    Object o = e.createExecutableExtension("class");
                    if (o instanceof ISessionListener) {
                        r.listener = (ISessionListener)o;
                        SafeRunner.run((ISafeRunnable)r);
                    }
                }
                catch (CoreException e1) {
                    Core.LOG.warning((Throwable)e1);
                }
                ++n2;
            }
            Iterator iterator = new ArrayList(this.listeners).iterator();
            while (iterator.hasNext()) {
                ISessionListener l;
                r.listener = l = (ISessionListener)iterator.next();
                SafeRunner.run((ISafeRunnable)r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSessionListener(ISessionListener listener) {
        SessionService sessionService = this;
        synchronized (sessionService) {
            this.listeners.remove(listener);
        }
    }
}

