/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.internal.core.app;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.app.ISharedImages;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

/*
 * Exception performing whole class analysis ignored.
 */
public class SharedImages
implements ISharedImages {
    private ImageRegistry _imageRegistry;
    private Bundle bundle;
    private PropertyResourceBundle propertiesBundle;
    private InputStream propertiesStream;

    public Image getImage(String key) {
        ImageDescriptor imageDescriptor;
        Image image = this._imageRegistry.get(key);
        if (image == null && (imageDescriptor = this.getImageDescriptor(key)) != null) {
            this.declareImage(key, imageDescriptor);
            image = this._imageRegistry.get(key);
        }
        return image;
    }

    public ImageDescriptor getImageDescriptor(String key) {
        ImageDescriptor imageDescriptor = this._imageRegistry.getDescriptor(key);
        if (imageDescriptor == null && (imageDescriptor = this.resolveImageKey(key)) != null) {
            this._imageRegistry.put(key, imageDescriptor);
        }
        return imageDescriptor;
    }

    public Image getMetaclassImage(Class<? extends IElement> metaclass) {
        ImageDescriptor imageDescriptor;
        String key = this.getMetaclassImageKey(null, metaclass);
        Image image = this.getImage(key);
        if (image == null && (imageDescriptor = this.resolveImageKey(key)) != null) {
            this.declareImage(key, imageDescriptor);
            image = this.getImage(key);
        }
        return image;
    }

    public Image getMetaclassImage(String dependencyName, Class<? extends IElement> metaclass) {
        ImageDescriptor imageDescriptor;
        String key = this.getMetaclassImageKey(dependencyName, metaclass);
        Image image = this.getImage(key);
        if (image == null && (imageDescriptor = this.resolveImageKey(key)) != null) {
            this.declareImage(key, imageDescriptor);
            image = this.getImage(key);
        }
        return image;
    }

    public SharedImages(Bundle bundle) {
        if (this._imageRegistry == null) {
            this.initializeImageRegistry();
        }
        this.bundle = bundle;
        String lang = SharedImages.getLanguage();
        Path langBitmapProperties = new Path("res/" + lang + "/base/metamodel/bitmaps.properties");
        Path commonBitmapProperties = new Path("res/common/base/metamodel/bitmaps.properties");
        URL url = FileLocator.find((Bundle)bundle, (IPath)langBitmapProperties, null);
        if (url == null) {
            url = FileLocator.find((Bundle)bundle, (IPath)commonBitmapProperties, null);
        }
        try {
            this.propertiesStream = url.openStream();
            this.propertiesBundle = new PropertyResourceBundle(this.propertiesStream);
        }
        catch (IOException e) {
            this.propertiesBundle = null;
            e.printStackTrace();
        }
    }

    public void declareImage(String key, ImageDescriptor descriptor) {
        this._imageRegistry.put(key, descriptor);
    }

    private void initializeImageRegistry() {
        this._imageRegistry = new ImageRegistry();
        this._imageRegistry.put("MissingImage", ImageDescriptor.getMissingImageDescriptor());
        this.declareImage("core.check.model", "base/command/check.png");
        this.declareImage("core.element.copy", "base/command/copy_16.png");
        this.declareImage("core.element.cut", "base/command/cut_16.png");
        this.declareImage("core.element.delete", "base/command/delete_16.png");
        this.declareImage("core.element.paste", "base/command/paste_16.png");
        this.declareImage("core.element.rename", "base/command/rename_16.png");
    }

    public void declareImage(String symbolicName, String relativePath) {
        Bundle imageBundle = Platform.getBundle((String)"org.modelio.core");
        Path langBitmapPath = new Path("res/" + SharedImages.getLanguage() + "/" + relativePath);
        Path commonBitmapPath = new Path("res/common/" + relativePath);
        URL bitmapUrl = FileLocator.find((Bundle)imageBundle, (IPath)langBitmapPath, null);
        if (bitmapUrl == null) {
            bitmapUrl = FileLocator.find((Bundle)imageBundle, (IPath)commonBitmapPath, null);
        }
        ImageDescriptor desc = ImageDescriptor.createFromURL((URL)bitmapUrl);
        this.declareImage(symbolicName, desc);
    }

    private static String getLanguage() {
        String lang = Platform.getNL();
        int index = lang.indexOf(95);
        if (index != -1) {
            lang = lang.substring(0, index);
        }
        return lang;
    }

    protected void finalize() throws Throwable {
        this.propertiesStream.close();
        super.finalize();
    }

    private ImageDescriptor resolveImageKey(String key) {
        ImageDescriptor desc = null;
        try {
            String relativePath = this.propertiesBundle.getString(key);
            StringBuilder langImagePath = new StringBuilder("res/");
            langImagePath.append(SharedImages.getLanguage());
            langImagePath.append("/");
            langImagePath.append(relativePath);
            Path langIPath = new Path(langImagePath.toString());
            URL url = FileLocator.find((Bundle)this.bundle, (IPath)langIPath, null);
            if (url == null) {
                StringBuilder commonImagePath = new StringBuilder("res/common/");
                commonImagePath.append(relativePath);
                Path commonIPath = new Path(commonImagePath.toString());
                url = FileLocator.find((Bundle)this.bundle, (IPath)commonIPath, null);
            }
            desc = ImageDescriptor.createFromURL((URL)url);
        }
        catch (MissingResourceException e) {
            return null;
        }
        return desc;
    }

    public ImageDescriptor getMetaclassImageDescriptor(Class<? extends IElement> metaclass) {
        String key = this.getMetaclassImageKey(null, metaclass);
        ImageDescriptor desc = this.getImageDescriptor(key);
        if (desc == null && (desc = this.resolveImageKey(key)) != null) {
            this._imageRegistry.put(key, desc);
        }
        return desc;
    }

    public ImageDescriptor getMetaclassImageDescriptor(String dependencyName, Class<? extends IElement> metaclass) {
        String key = this.getMetaclassImageKey(dependencyName, metaclass);
        ImageDescriptor desc = this.getImageDescriptor(key);
        if (desc == null && (desc = this.resolveImageKey(key)) != null) {
            this._imageRegistry.put(key, desc);
        }
        return desc;
    }

    public String getMetaclassImageKey(String dependencyName, Class<? extends IElement> metaclass) {
        String className = MetaModelExpert.getMetaclassName(metaclass);
        if (dependencyName == null || dependencyName.isEmpty()) {
            StringBuilder keyBuffer = new StringBuilder(className.length() + 3);
            keyBuffer.append("mm.");
            keyBuffer.append(className);
            return keyBuffer.toString();
        }
        StringBuilder keyBuffer = new StringBuilder(className.length() + dependencyName.length() + 3);
        keyBuffer.append("mm.");
        keyBuffer.append(dependencyName);
        keyBuffer.append(".");
        keyBuffer.append(className);
        return keyBuffer.toString();
    }
}

