/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.internal.core.audit;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.audit.ICoreAuditDiagnostic;
import com.modeliosoft.modelio.core.audit.ICoreAuditListener;
import com.modeliosoft.modelio.core.internal.core.audit.CoreAuditDiagnostic;
import com.modeliosoft.modelio.core.internal.core.audit.ICoreAudit;
import com.modeliosoft.modelio.core.jni.INativeCoreAudit;
import com.modeliosoft.modelio.core.jni.INativeCoreAuditDiagnostic;
import com.modeliosoft.modelio.core.jni.INativeCoreAuditListener;
import com.modeliosoft.modelio.core.jni.ITransaction;
import java.util.ArrayList;

public class CoreAudit
implements ICoreAudit,
INativeCoreAuditListener {
    private INativeCoreAudit audit;
    private ArrayList<ICoreAuditListener> diagnosticListeners;

    public CoreAudit(INativeCoreAudit audit) {
        this.audit = audit;
        this.audit.setDiagnosticListener((INativeCoreAuditListener)this);
        this.diagnosticListeners = new ArrayList();
    }

    public void addAuditDiagnosticListener(ICoreAuditListener listener) {
        this.diagnosticListeners.add(listener);
    }

    public boolean auditElement(IElement element) {
        return this.audit.auditElement(element);
    }

    public boolean auditTransaction(ITransaction transaction) {
        return this.audit.auditTransaction(transaction);
    }

    public void dispose() {
        if (this.audit != null) {
            this.audit.setDiagnosticListener(null);
            this.audit = null;
        }
    }

    public void onCommitDiagnostic(INativeCoreAuditDiagnostic nativeDiagnostic) {
        CoreAuditDiagnostic diagnostic = new CoreAuditDiagnostic(nativeDiagnostic);
        for (ICoreAuditListener diagnosticListener : this.diagnosticListeners) {
            diagnosticListener.onCommitDiagnostic((ICoreAuditDiagnostic)diagnostic);
        }
    }

    public void removeAuditDiagnosticListener(ICoreAuditListener listener) {
        this.diagnosticListeners.remove(listener);
    }

    protected void finalize() throws Throwable {
        this.dispose();
    }
}

