/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.internal.core.audit;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.audit.AuditSeverity;
import com.modeliosoft.modelio.core.audit.ICoreAuditDiagnostic;
import com.modeliosoft.modelio.core.audit.IErrorEntry;
import com.modeliosoft.modelio.core.internal.core.audit.ErrorEntry;
import com.modeliosoft.modelio.core.jni.INativeCoreAuditDiagnostic;
import java.util.ArrayList;
import java.util.List;

public class CoreAuditDiagnostic
implements ICoreAuditDiagnostic {
    private List<IErrorEntry> entries = null;
    private INativeCoreAuditDiagnostic nativeDiagnostic;
    private AuditSeverity auditSeverity = AuditSeverity.AuditSuccess;

    public boolean isApplied(String entryId) {
        return this.nativeDiagnostic.isApplied(entryId);
    }

    public List<IErrorEntry> getEntries() {
        if (this.entries == null) {
            this.entries = this.readEntries();
        }
        return this.entries;
    }

    public AuditSeverity getSeverity() {
        if (this.entries == null) {
            this.entries = this.readEntries();
        }
        return this.auditSeverity;
    }

    public CoreAuditDiagnostic(INativeCoreAuditDiagnostic nativeDiagnostic) {
        this.nativeDiagnostic = nativeDiagnostic;
    }

    private List<IErrorEntry> readEntries() {
        ArrayList<IErrorEntry> newEntries = new ArrayList<IErrorEntry>();
        long entryPtr = this.nativeDiagnostic.getNextEntry();
        String message = "";
        AuditSeverity severity = null;
        String ruleId = "";
        String entryId = "";
        String planId = "";
        IElement element = null;
        List linkedElements = null;
        ErrorEntry entry = null;
        while (entryPtr != 0L) {
            ruleId = this.nativeDiagnostic.getRuleId(entryPtr);
            severity = AuditSeverity.values()[this.nativeDiagnostic.getSeverity(entryPtr)];
            element = this.nativeDiagnostic.getElement(entryPtr);
            linkedElements = this.nativeDiagnostic.getLinkedElements(entryPtr);
            message = this.nativeDiagnostic.getMessage(entryPtr);
            entryId = this.nativeDiagnostic.getEntryId(entryPtr);
            planId = this.nativeDiagnostic.getPlanId(entryPtr);
            entry = new ErrorEntry(entryId, severity, element, linkedElements, message, ruleId, planId);
            newEntries.add((IErrorEntry)entry);
            if (severity.compareTo((Enum)this.auditSeverity) > 0) {
                this.auditSeverity = severity;
            }
            entryPtr = this.nativeDiagnostic.getNextEntry();
        }
        return newEntries;
    }
}

