/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.internal.core.mdacs;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.internal.core.mdacs.MdacRegistry;
import com.modeliosoft.modelio.core.mdacs.IMdacRegistry;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class MdacRegistry
implements IMdacRegistry {
    private Map<IModule, IMdac> startedModules = new HashMap();
    private Map<IModule, IMdac> loadedModules = new HashMap();
    private Set<IModule> devModules = new HashSet();
    private IModelingSession modelingSession;

    public MdacRegistry(IModelingSession modelingSession) {
        this.modelingSession = modelingSession;
        this.modelingSession.getModel().addModelListener((IModelChangeListener)new ModuleDeletionListener(this, null));
    }

    public Collection<IMdac> getStartedMdacs() {
        return this.startedModules.values();
    }

    public IMdac getStartedMdac(IModule model) {
        return (IMdac)this.startedModules.get(model);
    }

    public void addStartedMdac(IMdac mdac) {
        this.startedModules.put(mdac.getModel(), mdac);
    }

    public void removeStartedMdac(IMdac mdac) {
        this.startedModules.remove(mdac.getModel());
    }

    public void addLoadedMdac(IMdac mdac) {
        IModule obModule = mdac.getModel();
        this.loadedModules.put(obModule, mdac);
        if (!this.modelingSession.getElementStatus((IElement)obModule).isRamcObject()) {
            this.devModules.add(obModule);
        }
    }

    public IMdac getLoadedMdac(IModule model) {
        return (IMdac)this.loadedModules.get(model);
    }

    public void removeLoadedMdac(IMdac mdac) {
        this.loadedModules.remove(mdac.getModel());
    }

    public Collection<IMdac> getLoadedModules() {
        return this.loadedModules.values();
    }

    static /* synthetic */ Set access$0(MdacRegistry mdacRegistry) {
        return mdacRegistry.devModules;
    }
}

