/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.internal.core.model;

import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocumentType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IMetaclassReference;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IProfile;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IStereotype;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.api.utils.DocumentTypeNotFoundException;
import com.modeliosoft.modelio.api.utils.NoteTypeNotFoundException;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.StereotypeNotFoundException;
import com.modeliosoft.modelio.api.utils.TagTypeNotFoundException;
import com.modeliosoft.modelio.core.mdacs.IMdacRegistry;
import com.modeliosoft.modelio.core.model.IMetamodelExtensions;
import com.modeliosoft.modelio.core.model.IModel;
import com.modeliosoft.modelio.core.model.MetaModelExpert;
import java.util.ArrayList;
import java.util.Collection;

public class MetamodelExtensions
implements IMetamodelExtensions {
    private IModel model;
    private IMdacRegistry moduleRegistry;

    public MetamodelExtensions(IModel model) {
        this.model = model;
    }

    public IExternDocumentType getExternDocumentType(Class<? extends IElement> metaclass, String name) throws DocumentTypeNotFoundException {
        for (IExternDocumentType docType : this.getAllDocTypes(this.getUmlProject())) {
            if (!docType.getName().equals(name) || !this.getBaseClass(docType).isAssignableFrom(metaclass)) continue;
            return docType;
        }
        throw new DocumentTypeNotFoundException("No \"" + name + "\" document type found on \"" + MetaModelExpert.getMetaclassName(metaclass) + "\"");
    }

    public ObList<IExternDocumentType> getExternDocumentTypes(Class<? extends IElement> metaclass) {
        Collection allDocTypes = this.getAllDocTypes(this.getUmlProject());
        ArrayList<IExternDocumentType> ret = new ArrayList<IExternDocumentType>(allDocTypes.size());
        for (IExternDocumentType docType : allDocTypes) {
            if (!this.getBaseClass(docType).isAssignableFrom(metaclass)) continue;
            ret.add(docType);
        }
        return new ObList(ret);
    }

    public IModule getModule(IExternDocumentType docType) {
        if (docType == null) {
            return null;
        }
        IMetaclassReference reference = docType.getOwnerReference();
        IStereotype stereotype = docType.getOwnerStereotype();
        if (reference != null) {
            return this.getModule(reference);
        }
        if (stereotype != null) {
            return this.getModule(stereotype);
        }
        return null;
    }

    public IModule getModule(INoteType noteType) {
        if (noteType == null) {
            return null;
        }
        IMetaclassReference reference = noteType.getOwnerReference();
        IStereotype stereotype = noteType.getOwnerStereotype();
        if (reference != null) {
            return this.getModule(reference);
        }
        if (stereotype != null) {
            return this.getModule(stereotype);
        }
        return null;
    }

    public IModule getModule(ITagType tagType) {
        if (tagType == null) {
            return null;
        }
        IMetaclassReference reference = tagType.getOwnerReference();
        IStereotype stereotype = tagType.getOwnerStereotype();
        if (reference != null) {
            return this.getModule(reference);
        }
        if (stereotype != null) {
            return this.getModule(stereotype);
        }
        return null;
    }

    public IModule getModule(IStereotype stereotype) {
        if (stereotype == null) {
            return null;
        }
        return this.getModule(stereotype.getOwner());
    }

    public IModule getModule(IProfile profile) {
        if (profile == null) {
            return null;
        }
        IModule module = profile.getOwnerModule();
        if (module != null) {
            return module;
        }
        IModelTree parentModelTree = profile.getOwner();
        if (parentModelTree instanceof IProfile) {
            IProfile parentProfile = (IProfile)parentModelTree;
            return this.getModule(parentProfile);
        }
        return null;
    }

    public INoteType getNoteType(Class<? extends IElement> metaclass, String name) throws NoteTypeNotFoundException {
        return this.getUmlProject().getNoteType(metaclass, name);
    }

    public ObList<INoteType> getNoteTypes(Class<? extends IElement> metaclass) {
        return this.getUmlProject().getNoteTypes(metaclass);
    }

    public IStereotype getStereotype(Class<? extends IElement> metaclass, String name) throws StereotypeNotFoundException {
        return this.getUmlProject().getStereotype(metaclass, name);
    }

    public ObList<IStereotype> getStereotypes(Class<? extends IElement> metaclass) {
        return this.getUmlProject().getStereotypes(metaclass);
    }

    public ITagType getTagType(Class<? extends IElement> metaclass, String name) throws TagTypeNotFoundException {
        return this.getUmlProject().getTagType(metaclass, name);
    }

    public ObList<ITagType> getTagTypes(Class<? extends IElement> metaclass) {
        return this.getUmlProject().getTagTypes(metaclass);
    }

    public void postInit(IMdacRegistry theModuleRegistry) {
        if (theModuleRegistry == null) {
            throw new IllegalArgumentException("Module registry is null.");
        }
        this.moduleRegistry = theModuleRegistry;
    }

    private Collection<IExternDocumentType> getAllDocTypes(IProject project) {
        Collection profiles = this.getSelectedModulesProfiles(project);
        ArrayList<IExternDocumentType> ret = new ArrayList<IExternDocumentType>(profiles.size() * 10);
        for (IProfile ptView : profiles) {
            for (IMetaclassReference metaclass : ptView.getOwnedReference()) {
                ret.addAll((Collection<IExternDocumentType>)metaclass.getDefinedExternDocumentType());
            }
            for (IMetaclassReference metaclass : ptView.getDefinedStereotype()) {
                ret.addAll((Collection<IExternDocumentType>)metaclass.getDefinedExternDocumentType());
            }
        }
        return ret;
    }

    private Class<?> getBaseClass(IExternDocumentType docType) {
        IStereotype ste;
        IMetaclassReference ref = docType.getOwnerReference();
        String className = "";
        className = ref != null ? (ref.getReferenced() != null ? ref.getReferenced().getName() : ref.getReferencedClassName()) : ((ste = docType.getOwnerStereotype()).getBaseClass() != null ? ste.getBaseClass().getName() : ste.getBaseClassName());
        return MetaModelExpert.getMetaclass((String)className);
    }

    private IModule getModule(IMetaclassReference reference) {
        if (reference == null) {
            return null;
        }
        IProfile profile = reference.getOwnerProfile();
        if (profile != null) {
            return this.getModule(profile);
        }
        return null;
    }

    private Collection<IProfile> getSelectedModulesProfiles(IProject project) {
        ArrayList<IProfile> ret = new ArrayList<IProfile>();
        for (IModule m : project.getInstalled()) {
            if (!this.isSelected(m)) continue;
            ret.addAll((Collection<IProfile>)m.getOwnedProfile());
            ret.addAll((Collection<IProfile>)m.getOwnedElement(IProfile.class));
        }
        return ret;
    }

    private IProject getUmlProject() {
        return this.model.getProject();
    }

    private boolean isSelected(IModule m) {
        return this.moduleRegistry.getLoadedMdac(m) != null;
    }
}

