/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.log;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;

public class ConsoleLogListener
implements ILogListener {
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("- HH:mm:ss,SSS ");
    private static String EOL = "\n";

    public void logging(IStatus status, String plugin) {
        StringBuilder str = new StringBuilder(128);
        str.append(dateFormatter.format(new Date()));
        str.append(this.severityToString(status.getSeverity()));
        str.append(" ");
        str.append(status.getPlugin());
        str.append(":");
        str.append(status.getMessage());
        if (status.getException() != null) {
            str.append(EOL);
            String stackTrace = this.getStackTraceAsString(status.getException());
            str.append(stackTrace);
        }
        System.out.println(str);
    }

    private String severityToString(int severity) {
        switch (severity) {
            case 4: {
                return "ERROR";
            }
            case 2: {
                return "WARNING";
            }
            case 1: {
                return "INFO";
            }
            case 0: {
                return "OK";
            }
            case 8: {
                return "CANCEL";
            }
        }
        return "????(" + severity + ")";
    }

    private String getStackTraceAsString(Throwable e) {
        StringWriter stackTrace = new StringWriter();
        e.printStackTrace(new PrintWriter(stackTrace));
        return ((Object)stackTrace).toString();
    }
}

