/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.log;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IStatus;

public class LogListener
implements ILogListener {
    private File logFile;
    private BufferedWriter writer;
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss,SSS ");
    private static String EOL = "\n";

    public void logging(IStatus status, String plugin) {
        try {
            StringBuffer str = new StringBuffer(128);
            str.append(dateFormatter.format(new Date()));
            str.append(this.severityToString(status.getSeverity()));
            str.append(" ");
            str.append(status.getPlugin());
            str.append(": ");
            str.append(status.getMessage());
            str.append(EOL);
            if (status.getException() != null) {
                String stackTrace = this.getStackTraceAsString(status.getException());
                str.append(stackTrace);
            }
            if (this.writer != null) {
                this.writer.write(str.toString());
                this.writer.flush();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String severityToString(int severity) {
        switch (severity) {
            case 4: {
                return "ERROR";
            }
            case 2: {
                return "WARNING";
            }
            case 1: {
                return "INFO";
            }
        }
        return "????";
    }

    public LogListener() {
        String path = System.getProperty("user.home");
        this.logFile = new File(String.valueOf(path) + "/.modelio/2.2/modelioj.log");
        try {
            this.logFile.createNewFile();
            this.writer = new BufferedWriter(new FileWriter(this.logFile, false));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String getStackTraceAsString(Throwable e) {
        StringWriter stackTrace = new StringWriter();
        e.printStackTrace(new PrintWriter(stackTrace));
        return ((Object)stackTrace).toString();
    }
}

