/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.model;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.IElementFilter;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;

public class ElementFinder {
    private IModelingSession session;

    public ElementFinder(IModelingSession session) {
        this.session = session;
    }

    public List<IElement> findByName(List<Class<? extends IElement>> metaclasses, String nameValue, IElementFilter filter) {
        ArrayList<IElement> ret = new ArrayList<IElement>();
        for (Class<? extends IElement> c : metaclasses) {
            ret.addAll(this.session.getModel().findByAtt(c, "Name", nameValue));
        }
        if (filter != null) {
            ArrayList<IElement> filteredResults = new ArrayList<IElement>();
            for (IElement e : ret) {
                if (!filter.accept(e)) continue;
                filteredResults.add(e);
            }
            ret = filteredResults;
        }
        return ret;
    }

    public List<IElement> search(List<Class<? extends IElement>> metaclasses, String regexp, IElementFilter filter) {
        ArrayList rawResults = new ArrayList();
        for (Class<? extends IElement> c : metaclasses) {
            rawResults.addAll(this.session.getModel().findByClass(c));
        }
        ArrayList<IElement> filteredResults = new ArrayList<IElement>();
        Pattern p = Pattern.compile(regexp);
        for (IElement e : rawResults) {
            if (!(e instanceof IModelElement)) continue;
            IModelElement me = (IModelElement)e;
            if (p.matcher(me.getName()).matches() && filter == null) {
                filteredResults.add(e);
                continue;
            }
            if (!p.matcher(me.getName()).matches() || !filter.accept(e)) continue;
            filteredResults.add(e);
        }
        return filteredResults;
    }
}

