/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.model.expert.impl;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.statik.IAssociationEnd;
import com.modeliosoft.modelio.api.model.uml.statik.IAttribute;
import com.modeliosoft.modelio.api.model.uml.statik.IBindableInstance;
import com.modeliosoft.modelio.api.model.uml.statik.IBinding;
import com.modeliosoft.modelio.api.model.uml.statik.IClassifier;
import com.modeliosoft.modelio.api.model.uml.statik.ICollaboration;
import com.modeliosoft.modelio.api.model.uml.statik.ICollaborationUse;
import com.modeliosoft.modelio.api.model.uml.statik.IConnector;
import com.modeliosoft.modelio.api.model.uml.statik.IConnectorEnd;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.IOperation;
import com.modeliosoft.modelio.api.model.uml.statik.IParameter;
import com.modeliosoft.modelio.core.model.expert.DefaultCreationExpert;
import java.util.Collection;

public class BindingCreationExpert
extends DefaultCreationExpert {
    public BindingCreationExpert() {
        super(IBinding.class);
    }

    public boolean canLink(IElement fromElement, IElement toElement, IElement linkOwner) {
        ICollaborationUse collabUse;
        if (!super.canLink(fromElement, toElement, linkOwner)) {
            return false;
        }
        if (fromElement instanceof ICollaborationUse) {
            if (linkOwner != null && !linkOwner.equals((Object)fromElement)) {
                return false;
            }
            IElement fromOwner = this.getClassifierOwner(fromElement);
            IElement toOwner = this.getClassifierOwner(toElement);
            if (fromOwner != null && toOwner != null && fromOwner.equals((Object)toOwner)) {
                return true;
            }
            ICollaboration fromCollabOwner = this.getCollaborationOwner(fromElement);
            ICollaboration toCollabOwner = this.getCollaborationOwner(toElement);
            return fromCollabOwner != null && toCollabOwner != null && fromCollabOwner.equals((Object)toCollabOwner);
        }
        if (linkOwner == null) {
            collabUse = this.findCollabUse(fromElement, toElement);
            if (collabUse == null) {
                return false;
            }
        } else if (linkOwner instanceof ICollaborationUse) {
            collabUse = (ICollaborationUse)linkOwner;
        } else {
            return false;
        }
        ICollaboration usedCollab = collabUse.getType();
        ICollaboration collaboration = this.getCollaborationOwner(toElement);
        if (collaboration == null || !collaboration.equals((Object)usedCollab)) {
            return false;
        }
        IElement fromOwner = this.getClassifierOwner(fromElement);
        IElement collabUseOwner = this.getClassifierOwner((IElement)collabUse);
        return fromOwner != null && collabUseOwner != null && fromOwner.equals((Object)collabUseOwner);
    }

    public boolean canLinkFrom(Class<? extends IElement> fromMetaclass) {
        if (ICollaborationUse.class.isAssignableFrom(fromMetaclass)) {
            return true;
        }
        return IAttribute.class.isAssignableFrom(fromMetaclass) || IAssociationEnd.class.isAssignableFrom(fromMetaclass) || IBindableInstance.class.isAssignableFrom(fromMetaclass) || IConnector.class.isAssignableFrom(fromMetaclass) || IConnectorEnd.class.isAssignableFrom(fromMetaclass) || IParameter.class.isAssignableFrom(fromMetaclass);
    }

    public boolean canLinkFrom(IElement fromElement, IElement linkOwner) {
        if (fromElement instanceof ICollaborationUse) {
            return linkOwner == null || linkOwner.equals((Object)fromElement);
        }
        if (fromElement instanceof IAttribute || fromElement instanceof IAssociationEnd || fromElement instanceof IBindableInstance || fromElement instanceof IConnector || fromElement instanceof IConnectorEnd) {
            IClassifier fromOwner = (IClassifier)this.getClassifierOwner(fromElement);
            if (fromOwner == null) {
                return false;
            }
            if (linkOwner == null) {
                return fromOwner.cardOwnedCollaborationUse() > 0;
            }
            if (linkOwner instanceof ICollaborationUse) {
                return fromOwner.getOwnedCollaborationUse().contains((Object)linkOwner);
            }
            return false;
        }
        if (fromElement instanceof IParameter) {
            IOperation op = (IOperation)fromElement.getCompositionOwner();
            if (op == null) {
                return false;
            }
            if (linkOwner == null) {
                return op.cardOwnedCollaborationUse() > 0;
            }
            if (linkOwner instanceof ICollaborationUse) {
                return op.getOwnedCollaborationUse().contains((Object)linkOwner);
            }
            return false;
        }
        return false;
    }

    public boolean canOwn(Class<? extends IElement> childMetaclass) {
        return INote.class.equals(childMetaclass) || IExternDocument.class.equals(childMetaclass);
    }

    public boolean canOwn(IElement owner, Class<? extends IElement> childMetaclass, String dependency) {
        return INote.class.equals(childMetaclass) || IExternDocument.class.equals(childMetaclass);
    }

    public boolean canOwn(IElement owner, IElement child, String dependency) {
        return child instanceof INote || child instanceof IExternDocument;
    }

    private IElement getClassifierOwner(IElement e) {
        IElement ret = e.getCompositionOwner();
        while (ret != null && !(ret instanceof IClassifier)) {
            ret = ret.getCompositionOwner();
        }
        return ret;
    }

    private ICollaboration getCollaborationOwner(IElement role) {
        Object container = role.getCompositionOwner();
        while (container != null) {
            if (container instanceof ICollaboration) {
                return (ICollaboration)container;
            }
            container = container instanceof INameSpace ? null : container.getCompositionOwner();
        }
        return null;
    }

    private ICollaborationUse findCollabUse(IElement feature, IElement role) {
        ICollaboration collab = this.getCollaborationOwner(role);
        if (collab == null) {
            return null;
        }
        Collection uses = this.getCollabUsesOf(feature);
        if (uses == null) {
            return null;
        }
        for (ICollaborationUse u : uses) {
            if (!collab.equals((Object)u.getType())) continue;
            return u;
        }
        return null;
    }

    private Collection<ICollaborationUse> getCollabUsesOf(IElement feature) throws IllegalArgumentException {
        IElement container = feature.getCompositionOwner();
        while (container != null) {
            if (container instanceof INameSpace) {
                return ((INameSpace)container).getOwnedCollaborationUse();
            }
            if (container instanceof IOperation) {
                return ((IOperation)container).getOwnedCollaborationUse();
            }
            container = container.getCompositionOwner();
        }
        return null;
    }
}

