/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.model.expert.impl;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnActivity;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnCatchEvent;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnDataAssociation;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnDataInput;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnDataOutput;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnEvent;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnFlowElement;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnItemAwareElement;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnLane;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnLaneSet;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnProcess;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnSequenceFlow;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnThrowEvent;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.model.expert.DefaultCreationExpert;
import java.util.Iterator;

public class BpmnDataAssociationCreationExpert
extends DefaultCreationExpert {
    public BpmnDataAssociationCreationExpert() {
        super(IBpmnDataAssociation.class);
    }

    public boolean canLinkFrom(IElement fromElement, IElement linkOwner) {
        if (fromElement instanceof IBpmnThrowEvent) {
            return false;
        }
        if (fromElement instanceof IBpmnDataOutput) {
            return false;
        }
        if (fromElement instanceof IBpmnActivity) {
            return true;
        }
        if (fromElement instanceof IBpmnItemAwareElement) {
            return true;
        }
        if (fromElement instanceof IBpmnEvent) {
            return true;
        }
        return fromElement instanceof IBpmnSequenceFlow;
    }

    public boolean canLink(IElement fromElement, IElement toElement, IElement linkOwner) {
        if (!this.canLinkFrom(fromElement, linkOwner)) {
            return false;
        }
        boolean validMetaclass = false;
        if (toElement instanceof IBpmnDataInput) {
            validMetaclass = false;
        } else if (fromElement instanceof IBpmnActivity && toElement instanceof IBpmnItemAwareElement) {
            validMetaclass = true;
        } else if (fromElement instanceof IBpmnItemAwareElement && toElement instanceof IBpmnActivity) {
            validMetaclass = true;
        } else if (fromElement instanceof IBpmnCatchEvent && toElement instanceof IBpmnItemAwareElement) {
            validMetaclass = true;
        } else if (fromElement instanceof IBpmnItemAwareElement && toElement instanceof IBpmnThrowEvent) {
            validMetaclass = true;
        } else {
            if (fromElement instanceof IBpmnItemAwareElement && toElement instanceof IBpmnSequenceFlow) {
                return true;
            }
            if (fromElement instanceof IBpmnSequenceFlow && toElement instanceof IBpmnItemAwareElement) {
                return true;
            }
        }
        if (validMetaclass) {
            return this.isSameContext(fromElement, toElement);
        }
        return false;
    }

    private boolean isSameContext(IElement fromElement, IElement toElement) {
        IElement formContext = this.getContext(fromElement, true);
        IElement toContext = this.getContext(toElement, true);
        return formContext.equals((Object)toContext);
    }

    private IElement getContext(IElement element, boolean rec) {
        IBpmnFlowElement flow;
        Iterator iterator;
        if (element instanceof IBpmnProcess) {
            return element;
        }
        if (element.getCompositionOwner() instanceof IBpmnProcess && (iterator = (flow = (IBpmnFlowElement)element).getLane().iterator()).hasNext()) {
            IBpmnLane lane = (IBpmnLane)iterator.next();
            return this.getFirstLane(lane);
        }
        return this.getContext(element.getCompositionOwner(), false);
    }

    private IBpmnLane getFirstLane(IBpmnLane lane) {
        IBpmnLaneSet owner = (IBpmnLaneSet)lane.getCompositionOwner();
        if (owner.getParentLane() != null) {
            return this.getFirstLane(owner.getParentLane());
        }
        return lane;
    }
}

