/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.model.expert.impl;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnActivity;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnCatchEvent;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnFlowElement;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnLane;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnLaneSet;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnMessageFlow;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnProcess;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnSubProcess;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnThrowEvent;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.model.expert.DefaultCreationExpert;
import java.util.Iterator;

public class BpmnMessageFlowCreationExpert
extends DefaultCreationExpert {
    public BpmnMessageFlowCreationExpert() {
        super(IBpmnMessageFlow.class);
    }

    public boolean canLinkFrom(IElement fromElement, IElement linkOwner) {
        if (fromElement instanceof IBpmnLane) {
            return true;
        }
        if (fromElement instanceof IBpmnActivity) {
            return true;
        }
        return fromElement instanceof IBpmnThrowEvent;
    }

    public boolean canLink(IElement fromElement, IElement toElement, IElement linkOwner) {
        if (!this.canLinkFrom(fromElement, linkOwner)) {
            return false;
        }
        if (fromElement.equals((Object)toElement)) {
            return false;
        }
        if (fromElement instanceof IBpmnFlowElement && toElement instanceof IBpmnFlowElement && this.isSameContext(fromElement, toElement)) {
            return false;
        }
        if (toElement instanceof IBpmnLane) {
            return true;
        }
        if (toElement instanceof IBpmnCatchEvent) {
            return true;
        }
        return toElement instanceof IBpmnActivity;
    }

    private boolean isSameContext(IElement fromElement, IElement toElement) {
        IElement formContext = this.getContext(fromElement, true);
        IElement toContext = this.getContext(toElement, true);
        return formContext.equals((Object)toContext);
    }

    private IElement getContext(IElement element, boolean rec) {
        IBpmnFlowElement flow;
        Iterator iterator;
        if (element instanceof IBpmnProcess) {
            return element;
        }
        if (element instanceof IBpmnSubProcess && !rec) {
            return element;
        }
        if (element.getCompositionOwner() instanceof IBpmnProcess && (iterator = (flow = (IBpmnFlowElement)element).getLane().iterator()).hasNext()) {
            IBpmnLane lane = (IBpmnLane)iterator.next();
            return this.getFirstLane(lane);
        }
        return this.getContext(element.getCompositionOwner(), false);
    }

    private IBpmnLane getFirstLane(IBpmnLane lane) {
        IBpmnLaneSet owner = (IBpmnLaneSet)lane.getCompositionOwner();
        if (owner.getParentLane() != null) {
            return this.getFirstLane(owner.getParentLane());
        }
        return lane;
    }
}

