/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.model.expert.impl;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnBoundaryEvent;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnEndEvent;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnFlowElement;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnItemAwareElement;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnLane;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnLaneSet;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnProcess;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnSequenceFlow;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnStartEvent;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnSubProcess;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.core.model.expert.DefaultCreationExpert;
import java.util.Iterator;

public class BpmnSequenceFlowCreationExpert
extends DefaultCreationExpert {
    public BpmnSequenceFlowCreationExpert() {
        super(IBpmnSequenceFlow.class);
    }

    public boolean canLink(IElement fromElement, IElement toElement, IElement linkOwner) {
        if (!this.canLinkFrom(fromElement, linkOwner)) {
            return false;
        }
        if (fromElement.equals((Object)toElement)) {
            return false;
        }
        if (toElement instanceof IBpmnStartEvent) {
            return false;
        }
        if (toElement instanceof IBpmnBoundaryEvent) {
            return false;
        }
        if (toElement instanceof IBpmnItemAwareElement) {
            return false;
        }
        if (!(toElement instanceof IBpmnFlowElement)) {
            return false;
        }
        return this.isSameContext(fromElement, toElement);
    }

    public boolean canLinkFrom(IElement fromElement, IElement linkOwner) {
        if (fromElement instanceof IBpmnEndEvent) {
            return false;
        }
        if (fromElement instanceof IBpmnItemAwareElement) {
            return false;
        }
        return fromElement instanceof IBpmnFlowElement;
    }

    private boolean isSameContext(IElement fromElement, IElement toElement) {
        IElement formContext = this.getContext(fromElement, true);
        IElement toContext = this.getContext(toElement, true);
        return formContext.equals((Object)toContext);
    }

    private IElement getContext(IElement element, boolean rec) {
        IBpmnFlowElement flow;
        Iterator iterator;
        if (element instanceof IBpmnProcess) {
            return element;
        }
        if (element instanceof IBpmnSubProcess) {
            if (!rec) {
                return element;
            }
        } else if (element instanceof IBpmnBoundaryEvent) {
            return this.getContext((IElement)((IBpmnBoundaryEvent)element).getAttachedToRef(), rec);
        }
        if (element.getCompositionOwner() instanceof IBpmnProcess && (iterator = (flow = (IBpmnFlowElement)element).getLane().iterator()).hasNext()) {
            IBpmnLane lane = (IBpmnLane)iterator.next();
            return this.getFirstLane(lane);
        }
        return this.getContext(element.getCompositionOwner(), false);
    }

    private IBpmnLane getFirstLane(IBpmnLane lane) {
        IBpmnLaneSet owner = (IBpmnLaneSet)lane.getCompositionOwner();
        if (owner.getParentLane() != null) {
            return this.getFirstLane(owner.getParentLane());
        }
        return lane;
    }
}

