/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.model.transmuter.impl;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnActivity;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnBoundaryEvent;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnDataAssociation;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnDataInput;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnDataOutput;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnFlowElement;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnLane;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnMessageFlow;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnSequenceFlow;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnSubProcess;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IDependency;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.core.model.transmuter.ITransmuter;

public class BpmnActivityTransmuter
implements ITransmuter {
    private IElement element;
    private String mataclass;

    public BpmnActivityTransmuter(IElement element, String mataclass) {
        this.element = element;
        this.mataclass = mataclass;
    }

    public IElement Transmute() {
        IElement owner = this.element.getCompositionOwner();
        IModelFactory modelFactory = O.getDefault().getModelingSession().getModelFactory();
        IElement newElement = modelFactory.createElement(this.mataclass);
        String effectiveDependency = CompositionExpert.getDefaultCompositionDep((IElement)owner, (IElement)newElement);
        Meta meta = new Meta(owner);
        try {
            meta.appendToDependency(effectiveDependency, newElement);
        }
        catch (InvalidModelManipulationException e) {
            String compositionDep = CompositionExpert.getDefaultCompositionDep((IElement)owner, (IElement)newElement);
            if (compositionDep != null && !compositionDep.equals("")) {
                meta.appendToDependency(compositionDep, newElement);
            }
            modelFactory.deleteElement(newElement);
            return null;
        }
        if (newElement instanceof IBpmnFlowElement && owner instanceof IBpmnLane) {
            IBpmnLane lane = (IBpmnLane)owner;
            IBpmnFlowElement flowElement = (IBpmnFlowElement)newElement;
            flowElement.addBpmnLaneRefs(lane);
            lane.addFlowElementRef(flowElement);
        }
        DefaultNameFactory.setDefaultName((IModelElement)((IModelElement)newElement));
        if (this.element instanceof IBpmnActivity && newElement instanceof IBpmnActivity) {
            IBpmnActivity newActivity = (IBpmnActivity)newElement;
            IBpmnActivity oldActivity = (IBpmnActivity)this.element;
            newActivity.setName(oldActivity.getName());
            for (IBpmnLane lane : oldActivity.getBpmnLaneRefs()) {
                newActivity.addBpmnLaneRefs(lane);
            }
            for (IBpmnBoundaryEvent event : oldActivity.getBoundaryEventRef()) {
                newActivity.addBoundaryEventRef(event);
            }
            for (IBpmnDataInput subelement : oldActivity.getInputSpecification()) {
                newActivity.addInputSpecification(subelement);
            }
            for (IBpmnDataInput subelement : oldActivity.getOutputSpecification()) {
                newActivity.addOutputSpecification((IBpmnDataOutput)subelement);
            }
            for (IBpmnDataInput subelement : oldActivity.getDataInputAssociation()) {
                newActivity.addDataInputAssociation((IBpmnDataAssociation)subelement);
            }
            for (IBpmnDataInput subelement : oldActivity.getDataOutputAssociation()) {
                newActivity.addDataOutputAssociation((IBpmnDataAssociation)subelement);
            }
            for (IBpmnDataInput subelement : oldActivity.getOutgoing()) {
                newActivity.addOutgoing((IBpmnSequenceFlow)subelement);
            }
            for (IBpmnDataInput subelement : oldActivity.getIncoming()) {
                newActivity.addIncoming((IBpmnSequenceFlow)subelement);
            }
            for (IBpmnDataInput subelement : oldActivity.getLane()) {
                newActivity.addLane((IBpmnLane)subelement);
            }
            for (IBpmnDataInput subelement : oldActivity.getImpactedDependency()) {
                newActivity.addImpactedDependency((IDependency)subelement);
            }
            for (IBpmnDataInput subelement : oldActivity.getDependsOnDependency()) {
                newActivity.addDependsOnDependency((IDependency)subelement);
            }
            if (oldActivity.getDefaultFlow() != null) {
                newActivity.setDefaultFlow(oldActivity.getDefaultFlow());
            }
            if (oldActivity.getLoopCharacteristics() != null) {
                newActivity.setLoopCharacteristics(oldActivity.getLoopCharacteristics());
            }
            if (oldActivity.getLoopCharacteristics() != null) {
                newActivity.setLoopCharacteristics(oldActivity.getLoopCharacteristics());
            }
            if (oldActivity.getOutgoingFlow().size() > 0) {
                for (IBpmnMessageFlow flow : oldActivity.getOutgoingFlow()) {
                    newActivity.addOutgoingFlow(flow);
                }
            }
            if (oldActivity.getIncomingFlow().size() > 0) {
                for (IBpmnMessageFlow flow : oldActivity.getIncomingFlow()) {
                    newActivity.addIncomingFlow(flow);
                }
            }
            if (this.element instanceof IBpmnSubProcess && newElement instanceof IBpmnSubProcess) {
                IBpmnSubProcess newSubProcess = (IBpmnSubProcess)newElement;
                IBpmnSubProcess oldSubProcss = (IBpmnSubProcess)this.element;
                for (IBpmnFlowElement subelement : oldSubProcss.getFlowElement()) {
                    newSubProcess.addFlowElement(subelement);
                }
            }
        }
        return newElement;
    }

    public boolean canTransmute() {
        return true;
    }
}

