/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.model.transmuter.impl;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnEndEvent;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnEvent;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnEventDefinition;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnFlowElement;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnLane;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnMessageFlow;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnSequenceFlow;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnStartEvent;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IDependency;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.core.model.transmuter.ITransmuter;

public class BpmnEventTransmuter
implements ITransmuter {
    private IElement element;
    private String mataclass;

    public BpmnEventTransmuter(IElement element, String mataclass) {
        this.element = element;
        this.mataclass = mataclass;
    }

    public IElement Transmute() {
        IElement owner = this.element.getCompositionOwner();
        IModelFactory modelFactory = O.getDefault().getModelingSession().getModelFactory();
        IElement newElement = modelFactory.createElement(this.mataclass);
        String effectiveDependency = CompositionExpert.getDefaultCompositionDep((IElement)owner, (IElement)newElement);
        Meta meta = new Meta(owner);
        try {
            meta.appendToDependency(effectiveDependency, newElement);
        }
        catch (InvalidModelManipulationException e) {
            String compositionDep = CompositionExpert.getDefaultCompositionDep((IElement)owner, (IElement)newElement);
            if (compositionDep != null && !compositionDep.equals("")) {
                meta.appendToDependency(compositionDep, newElement);
            }
            modelFactory.deleteElement(newElement);
            return null;
        }
        if (newElement instanceof IBpmnFlowElement && owner instanceof IBpmnLane) {
            IBpmnLane lane = (IBpmnLane)owner;
            IBpmnFlowElement flowElement = (IBpmnFlowElement)newElement;
            flowElement.addBpmnLaneRefs(lane);
            lane.addFlowElementRef(flowElement);
        }
        DefaultNameFactory.setDefaultName((IModelElement)((IModelElement)newElement));
        if (this.element instanceof IBpmnEvent && newElement instanceof IBpmnEvent) {
            IBpmnEvent newEvent = (IBpmnEvent)newElement;
            IBpmnEvent oldEvent = (IBpmnEvent)this.element;
            newEvent.setName(oldEvent.getName());
            for (IBpmnLane lane : oldEvent.getBpmnLaneRefs()) {
                newEvent.addBpmnLaneRefs(lane);
            }
            if (!(newEvent instanceof IBpmnEndEvent)) {
                for (IBpmnSequenceFlow subelement : oldEvent.getOutgoing()) {
                    newEvent.addOutgoing(subelement);
                }
            }
            if (!(newEvent instanceof IBpmnStartEvent)) {
                for (IBpmnSequenceFlow subelement : oldEvent.getIncoming()) {
                    newEvent.addIncoming(subelement);
                }
            }
            for (IBpmnSequenceFlow subelement : oldEvent.getLane()) {
                newEvent.addLane((IBpmnLane)subelement);
            }
            for (IBpmnSequenceFlow subelement : oldEvent.getImpactedDependency()) {
                newEvent.addImpactedDependency((IDependency)subelement);
            }
            for (IBpmnSequenceFlow subelement : oldEvent.getDependsOnDependency()) {
                newEvent.addDependsOnDependency((IDependency)subelement);
            }
            for (IBpmnEventDefinition definition : oldEvent.getEventDefinitions()) {
                newEvent.addEventDefinitions(definition);
            }
            if (oldEvent.getOutgoingFlow().size() > 0) {
                for (IBpmnMessageFlow flow : oldEvent.getOutgoingFlow()) {
                    newEvent.addOutgoingFlow(flow);
                }
            }
            if (oldEvent.getIncomingFlow().size() > 0) {
                for (IBpmnMessageFlow flow : oldEvent.getIncomingFlow()) {
                    newEvent.addIncomingFlow(flow);
                }
            }
        }
        return newElement;
    }

    public boolean canTransmute() {
        return true;
    }
}

