/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.model.transmuter.impl;

import com.modeliosoft.modelio.api.model.bpmn.IBpmnComplexGateway;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnExclusiveGateway;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnFlowElement;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnGateway;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnInclusiveGateway;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnLane;
import com.modeliosoft.modelio.api.model.bpmn.IBpmnSequenceFlow;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IDependency;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.factory.DefaultNameFactory;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.model.CompositionExpert;
import com.modeliosoft.modelio.core.model.Meta;
import com.modeliosoft.modelio.core.model.transmuter.ITransmuter;

public class BpmnGatewayTransmuter
implements ITransmuter {
    private IElement element;
    private String mataclass;

    public BpmnGatewayTransmuter(IElement element, String mataclass) {
        this.element = element;
        this.mataclass = mataclass;
    }

    public IElement Transmute() {
        IElement owner = this.element.getCompositionOwner();
        IModelFactory modelFactory = O.getDefault().getModelingSession().getModelFactory();
        IElement newElement = modelFactory.createElement(this.mataclass);
        String effectiveDependency = CompositionExpert.getDefaultCompositionDep((IElement)owner, (IElement)newElement);
        Meta meta = new Meta(owner);
        try {
            meta.appendToDependency(effectiveDependency, newElement);
        }
        catch (InvalidModelManipulationException e) {
            String compositionDep = CompositionExpert.getDefaultCompositionDep((IElement)owner, (IElement)newElement);
            if (compositionDep != null && !compositionDep.equals("")) {
                meta.appendToDependency(compositionDep, newElement);
            }
            modelFactory.deleteElement(newElement);
            return null;
        }
        if (newElement instanceof IBpmnFlowElement && owner instanceof IBpmnLane) {
            IBpmnLane lane = (IBpmnLane)owner;
            IBpmnFlowElement flowElement = (IBpmnFlowElement)newElement;
            flowElement.addBpmnLaneRefs(lane);
            lane.addFlowElementRef(flowElement);
        }
        DefaultNameFactory.setDefaultName((IModelElement)((IModelElement)newElement));
        if (this.element instanceof IBpmnGateway && newElement instanceof IBpmnGateway) {
            IBpmnGateway newGateway = (IBpmnGateway)newElement;
            IBpmnGateway oldGateway = (IBpmnGateway)this.element;
            newGateway.setName(oldGateway.getName());
            for (IBpmnLane lane : oldGateway.getBpmnLaneRefs()) {
                newGateway.addBpmnLaneRefs(lane);
            }
            for (IBpmnSequenceFlow subelement : oldGateway.getOutgoing()) {
                newGateway.addOutgoing(subelement);
            }
            for (IBpmnSequenceFlow subelement : oldGateway.getIncoming()) {
                newGateway.addIncoming(subelement);
            }
            for (IBpmnSequenceFlow subelement : oldGateway.getLane()) {
                newGateway.addLane((IBpmnLane)subelement);
            }
            for (IBpmnSequenceFlow subelement : oldGateway.getImpactedDependency()) {
                newGateway.addImpactedDependency((IDependency)subelement);
            }
            for (IBpmnSequenceFlow subelement : oldGateway.getDependsOnDependency()) {
                newGateway.addDependsOnDependency((IDependency)subelement);
            }
            IBpmnSequenceFlow defaultflow = null;
            if (oldGateway instanceof IBpmnExclusiveGateway) {
                defaultflow = ((IBpmnExclusiveGateway)oldGateway).getDefaultFlow();
            } else if (oldGateway instanceof IBpmnInclusiveGateway) {
                defaultflow = ((IBpmnInclusiveGateway)oldGateway).getDefaultFlow();
            } else if (oldGateway instanceof IBpmnComplexGateway) {
                defaultflow = ((IBpmnComplexGateway)oldGateway).getDefaultFlow();
            }
            if (newGateway instanceof IBpmnExclusiveGateway && defaultflow != null) {
                ((IBpmnExclusiveGateway)newGateway).setDefaultFlow(defaultflow);
            } else if (newGateway instanceof IBpmnInclusiveGateway && defaultflow != null) {
                ((IBpmnInclusiveGateway)newGateway).setDefaultFlow(defaultflow);
            } else if (newGateway instanceof IBpmnComplexGateway && defaultflow != null) {
                ((IBpmnComplexGateway)newGateway).setDefaultFlow(defaultflow);
            }
        }
        return newElement;
    }

    public boolean canTransmute() {
        return true;
    }
}

