/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.plugin;

import com.modeliosoft.modelio.bridges.Cpp2JavaUtils.PluginClassFinder;
import com.modeliosoft.modelio.core.LibModelio;
import com.modeliosoft.modelio.core.app.DLL;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.log.ConsoleLogListener;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.log.LogListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILogListener;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    public static final String PLUGIN_ID = "org.modelio.core";
    private static Activator plugin;
    private ConsoleLogListener logListener;

    public static Activator getDefault() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        plugin = this;
        super.start(context);
        this.getLog().addLogListener((ILogListener)new LogListener());
        LOG.info((String)PLUGIN_ID, (String)"Loading LibModelio.");
        try {
            LibModelio.start();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        LOG.info((String)PLUGIN_ID, (String)"LibModelio loaded successfully.");
        PluginClassFinder.registerClassLoader((String)PLUGIN_ID, (ClassLoader)this.getClass().getClassLoader());
        try {
            this.init(context.getBundle());
        }
        catch (Exception e) {
            String[] tab = new String[]{IDialogConstants.OK_LABEL};
            MessageDialog dialog = new MessageDialog(null, "Modelio initialization error", null, e.getMessage(), 1, tab, 0);
            LOG.error((String)PLUGIN_ID, (String)"Modelio initialization error");
            LOG.error((String)PLUGIN_ID, (Throwable)e);
            dialog.open();
            System.exit(1);
            throw e;
        }
        catch (Error e) {
            String[] tab = new String[]{IDialogConstants.OK_LABEL};
            MessageDialog dialog = new MessageDialog(null, "Modelio initialization error", null, e.getMessage(), 1, tab, 0);
            LOG.error((String)PLUGIN_ID, (String)"Modelio initialization error");
            LOG.error((String)PLUGIN_ID, (Throwable)e);
            dialog.open();
            System.exit(1);
            throw e;
        }
        if (!this.checkEdition(context)) {
            String[] tab = new String[]{IDialogConstants.OK_LABEL};
            MessageDialog dialog = new MessageDialog(null, "Modelio initialization error", null, "Corrupted Modelio core plugin", 1, tab, 0);
            LOG.error((String)PLUGIN_ID, (String)"Corrupted Modelio core plugin.");
            dialog.open();
            System.exit(1);
        }
        this.initJythonLibraryPath();
        LOG.info((String)PLUGIN_ID, (String)"Modelio core successfully started.");
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        PluginClassFinder.unregisterClassLoader((String)PLUGIN_ID);
        super.stop(context);
    }

    private boolean checkEdition(BundleContext context) {
        return true;
    }

    private File getPluginPath(Bundle bundle) {
        File ret;
        Path ipath = new Path("");
        URL url = FileLocator.find((Bundle)bundle, (IPath)ipath, null);
        try {
            URL localUrl = FileLocator.toFileURL((URL)url);
            ret = new File(localUrl.getPath());
        }
        catch (IOException e) {
            LOG.error((String)PLUGIN_ID, (String)" error: root plugin path 3 = '%s'", (Object[])new Object[]{url.toString()});
            LOG.error((String)PLUGIN_ID, (Throwable)e);
            ret = new File(url.getPath());
        }
        return ret;
    }

    private void init(Bundle bundle) {
        this.setupConsoleLog();
        File pluginPath = this.getPluginPath(bundle);
        String lang = Locale.getDefault().getLanguage();
        if (!lang.equals("fr")) {
            lang = "en";
        }
        DLL.init((File)pluginPath, (File)pluginPath, (String)lang);
        O.Create((File)pluginPath, (String)lang);
    }

    private void setupConsoleLog() {
        Boolean consoleLog = new Boolean(System.getProperty("eclipse.consoleLog"));
        if (consoleLog.booleanValue()) {
            this.logListener = new ConsoleLogListener();
            LOG.addListener((ILogListener)this.logListener);
        }
    }

    private void initJythonLibraryPath() {
        try {
            String jythonLibPath = "lib/jython2.5/jython-standalone-2.5.3.jar";
            URL url = this.getClass().getClassLoader().getResource("lib/jython2.5/jython-standalone-2.5.3.jar");
            if (url == null) {
                throw new IOException("lib/jython2.5/jython-standalone-2.5.3.jar file is missing in the core plugin.");
            }
            URL loc = FileLocator.toFileURL((URL)url);
            System.setProperty("python.home", loc.getFile());
        }
        catch (IOException ex) {
            String[] tab = new String[]{IDialogConstants.OK_LABEL};
            MessageDialog dialog = new MessageDialog(null, "Jython initialization error", null, ex.getMessage(), 1, tab, 0);
            LOG.error((String)PLUGIN_ID, (Throwable)ex);
            dialog.open();
        }
    }
}

