/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.transaction;

import com.modeliosoft.modelio.core.jni.ITransaction;
import java.util.concurrent.TimeoutException;

public class ConcurrentTransactionException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private ITransaction blocking;
    private String blockedName;
    private Thread blockedThread;

    public ConcurrentTransactionException(ITransaction blocking, InterruptedException cause, String blockedName) {
        this.init(blocking, (Throwable)cause, blockedName);
    }

    public ConcurrentTransactionException(ITransaction blocking, TimeoutException cause, String blockedName) {
        this.init(blocking, (Throwable)cause, blockedName);
    }

    private void init(ITransaction aBlocking, Throwable cause, String aBlockedName) throws IllegalArgumentException {
        this.blocking = aBlocking;
        this.blockedName = aBlockedName;
        this.blockedThread = Thread.currentThread();
        this.initCause(cause);
        this.addSuppressed(aBlocking.getCaller());
    }

    public ITransaction getBlocking() {
        return this.blocking;
    }

    public String getBlockedName() {
        return this.blockedName;
    }

    public boolean isInterrupt() {
        return this.getCause() instanceof InterruptedException;
    }

    public boolean isTimeout() {
        return this.getCause() instanceof TimeoutException;
    }

    @Override
    public String getMessage() {
        return "Creation of a '" + this.blockedName + "' transaction in the '" + this.blockedThread + "' thread was blocked by the '" + this.blocking + "' transaction created in the '" + this.blocking.getCallerThread() + "' thread.";
    }
}

