/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.zip;

import com.modeliosoft.modelio.core.internal.core.RC;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class Unzipper {
    protected void extractFile(InputStream zis, File file) throws IOException {
        BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(file));
        try {
            try {
                int bytesRead;
                byte[] buf = new byte[8192];
                while ((bytesRead = zis.read(buf)) != -1) {
                    ((OutputStream)fos).write(buf, 0, bytesRead);
                }
            }
            finally {
                ((OutputStream)fos).close();
            }
        }
        catch (IOException e) {
            file.delete();
            throw e;
        }
    }

    protected int countEntries(File archive) throws IOException {
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(archive.getCanonicalFile())));
        int count = 0;
        while (zis.getNextEntry() != null) {
            ++count;
        }
        zis.close();
        return count;
    }

    public static void main(String[] args) {
        try {
            new Unzipper().unzip(new File("c:/tmp/tmp.zip"), new File("c:/tmp"), null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void unzip(File archive, File folder, IProgressMonitor monitor) throws IOException {
        int entriesNumber = this.countEntries(archive);
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)entriesNumber);
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(archive.getCanonicalFile())));
        ZipEntry ze = null;
        String archiveName = archive.getAbsolutePath();
        int cpt = 0;
        try {
            while ((ze = zis.getNextEntry()) != null) {
                File f = new File(folder.getCanonicalPath(), ze.getName());
                if (f.exists()) {
                    f.delete();
                }
                if (ze.isDirectory()) {
                    f.mkdirs();
                    continue;
                }
                subMonitor.subTask(RC.getMessage((String)"Unzipper.subTask", (String[])new String[]{archiveName, String.valueOf(cpt), String.valueOf(entriesNumber)}));
                ++cpt;
                f.getParentFile().mkdirs();
                this.extractFile((InputStream)zis, f);
                subMonitor.worked(1);
                f.setLastModified(ze.getTime());
            }
        }
        finally {
            zis.close();
        }
    }

    public ZipEntry[] findEntry(File archive, String regexp) throws IOException {
        Vector<ZipEntry> entries = new Vector<ZipEntry>();
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(new FileInputStream(archive.getCanonicalFile())));
        ZipEntry ze = null;
        if (regexp == null) {
            regexp = ".*";
        }
        Pattern p = Pattern.compile(regexp, 2);
        while ((ze = zis.getNextEntry()) != null) {
            if (!p.matcher(ze.getName()).matches()) continue;
            entries.add(ze);
        }
        ZipEntry[] z = new ZipEntry[entries.size()];
        return entries.toArray(z);
    }

    public void unzip(File archive, String entry, File folder, IProgressMonitor monitor) throws IOException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        ZipFile zipFile = new ZipFile(archive.getCanonicalFile());
        ZipEntry ze = zipFile.getEntry(entry);
        InputStream zis = null;
        String archiveName = archive.getAbsolutePath();
        int cpt = 0;
        try {
            if (ze != null) {
                File f = new File(folder, ze.getName());
                if (f.exists()) {
                    f.delete();
                }
                if (ze.isDirectory()) {
                    f.mkdirs();
                } else {
                    subMonitor.subTask(RC.getMessage((String)"Unzipper.subTask", (String[])new String[]{archiveName, String.valueOf(cpt), String.valueOf(1)}));
                    f.getParentFile().mkdirs();
                    zis = zipFile.getInputStream(ze);
                    this.extractFile(zis, f);
                    subMonitor.worked(1);
                }
                f.setLastModified(ze.getTime());
            }
        }
        finally {
            if (zis != null) {
                zis.close();
            }
        }
    }

    public InputStream getEntryStream(File archive, String entry) throws IOException {
        ZipFile zipFile = new ZipFile(archive.getCanonicalFile());
        ZipEntry ze = zipFile.getEntry(entry);
        InputStream zis = null;
        if (ze != null && !ze.isDirectory()) {
            zis = zipFile.getInputStream(ze);
        }
        return zis;
    }
}

