/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.core.zip;

import com.modeliosoft.modelio.core.internal.core.RC;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.zip.Adler32;
import java.util.zip.CheckedOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.core.runtime.IProgressMonitor;

public class Zipper {
    static final int BUFFER = 2048;
    private String archive = null;
    private boolean aborted = false;
    private ZipOutputStream out = null;

    public Zipper(String archive) {
        this.archive = archive;
    }

    public void compress(String path, IProgressMonitor monitor, String title, String[] filterPathes) {
        String[] pathes = new String[]{path};
        this.compress(pathes, monitor, title, filterPathes);
    }

    public void compress(String[] pathes, IProgressMonitor monitor, String title, String[] filterPathes) {
        int nTotal = this.countEntries(pathes);
        this.aborted = false;
        if (monitor == null) {
            monitor = new /* Unavailable Anonymous Inner Class!! */;
        }
        ZipOutputStream out = this.openZip(this.archive);
        monitor.beginTask(null, nTotal);
        monitor.setTaskName(title == null ? String.valueOf(RC.getString((String)"Creating")) + " " + this.archive : title);
        String[] stringArray = pathes;
        int n = pathes.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            try {
                File f = new File(path);
                if (f.isDirectory()) {
                    this.compressDirectory(out, f.getName(), f, monitor, filterPathes);
                } else if (f.isFile()) {
                    this.compressFile(out, "", f, monitor);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        this.closeZip(out);
        if (this.aborted) {
            File archiveFile = new File(this.archive);
            archiveFile.delete();
        }
    }

    public void compressContent(String path, IProgressMonitor monitor, String title) {
        String[] pathes;
        File dir = new File(path);
        if (dir.isDirectory()) {
            File[] files = dir.listFiles();
            pathes = new String[files.length];
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                pathes[i] = file.getAbsolutePath();
                ++i;
            }
        } else {
            if (dir.isFile()) {
                throw new RuntimeException(RC.getMessage((String)"CannotCompressDirectoryContentFile", (String[])new String[]{path}));
            }
            throw new RuntimeException(RC.getMessage((String)"PathNotFound", (String[])new String[]{path}));
        }
        this.compress(pathes, monitor, title, new String[0]);
    }

    protected int countEntries(String[] pathes) {
        Vector<File> dirs = new Vector<File>();
        String[] stringArray = pathes;
        int n = pathes.length;
        int n2 = 0;
        while (n2 < n) {
            String path = stringArray[n2];
            try {
                File p = new File(path);
                dirs.add(p);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++n2;
        }
        return this.countEntries(dirs);
    }

    protected int countEntries(Vector<File> pathes) {
        int n = 0;
        Vector<File> subdirs = new Vector<File>();
        if (pathes.size() == 0) {
            return 0;
        }
        for (File p : pathes) {
            try {
                File[] files;
                if (p.isFile()) {
                    ++n;
                    continue;
                }
                if (!p.isDirectory()) continue;
                ++n;
                File[] fileArray = files = p.listFiles();
                int n2 = files.length;
                int n3 = 0;
                while (n3 < n2) {
                    File f = fileArray[n3];
                    if (f.isFile()) {
                        ++n;
                    } else if (f.isDirectory()) {
                        subdirs.add(f);
                    }
                    ++n3;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return n += this.countEntries(subdirs);
    }

    protected void closeZip(ZipOutputStream out) {
        try {
            out.close();
            this.out = null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void compressDirectory(ZipOutputStream out, String relativeParent, File dir, IProgressMonitor monitor, String[] filterPathes) {
        if (monitor.isCanceled()) {
            this.aborted = true;
            return;
        }
        String[] files = dir.list();
        List<String> filterPathesList = Arrays.asList(filterPathes);
        String[] stringArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            File f = new File(dir, s);
            if (!filterPathesList.contains(s)) {
                if (f.isFile()) {
                    this.compressFile(out, relativeParent, f, monitor);
                } else if (f.isDirectory()) {
                    this.compressDirectory(out, relativeParent.isEmpty() ? f.getName() : String.valueOf(relativeParent) + "/" + f.getName(), f, monitor, filterPathes);
                }
            }
            ++n2;
        }
    }

    protected void compressFile(ZipOutputStream out, String relativeParent, File f, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            this.aborted = true;
            return;
        }
        monitor.subTask(f.toString());
        FileInputStream fi = null;
        BufferedInputStream buffi = null;
        byte[] data = new byte[2048];
        try {
            fi = new FileInputStream(f);
            buffi = new BufferedInputStream(fi, 2048);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return;
        }
        ZipEntry entry = null;
        entry = relativeParent.isEmpty() ? new ZipEntry(this.unAccent(f.getName())) : new ZipEntry(this.unAccent(String.valueOf(relativeParent) + "/" + f.getName()));
        try {
            int count;
            out.putNextEntry(entry);
            while ((count = buffi.read(data, 0, 2048)) != -1) {
                out.write(data, 0, count);
            }
            out.closeEntry();
            buffi.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        monitor.worked(1);
    }

    protected ZipOutputStream openZip(String archive) {
        try {
            FileOutputStream dest = new FileOutputStream(archive);
            CheckedOutputStream checksum = new CheckedOutputStream(dest, new Adler32());
            BufferedOutputStream buff = new BufferedOutputStream(checksum);
            this.out = new ZipOutputStream(buff);
            this.out.setMethod(8);
            this.out.setLevel(9);
            return this.out;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    protected String unAccent(String s) {
        String temp = Normalizer.normalize(s, Normalizer.Form.NFC);
        return temp.replaceAll("[^\\p{ASCII}]", "");
    }

    public int getBUFFER() {
        return 2048;
    }

    public String getArchive() {
        return this.archive;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    public ZipOutputStream getOut() {
        return this.out;
    }

    public void compress(String path, IProgressMonitor monitor, String title) {
        String[] pathes = new String[]{path};
        this.compress(pathes, monitor, title, new String[0]);
    }
}

