/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.deployer;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.ramcs.deployer.DeployRamcCommand;
import com.modeliosoft.modelio.ramcs.deployer.gui.DeployRamcDataModel;
import com.modeliosoft.modelio.ramcs.deployer.gui.DeployRamcDialog;
import com.modeliosoft.modelio.ramcs.plugin.Ramcs;
import com.modeliosoft.modelio.ramcs.ui.Messages;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class DeployRamcCommand {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        DeployRamcDataModel dataModel = this.promptUser();
        if (dataModel != null) {
            this.deployRamc(dataModel);
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deployRamc(DeployRamcDataModel dataModel) {
        IModelingSession modelingSession = Ramcs.getInstance().getModelingSession();
        String modelComponentPath = dataModel.getModelComponentPath();
        String ramcName = dataModel.getRamcName();
        DeployRamcWithProgress deployLauncher = new DeployRamcWithProgress(this, modelingSession, modelComponentPath, ramcName);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        String taskName = Messages.getMessage((String)"DeployRamcDialog.DeployRamcTask", (String[])new String[]{ramcName});
        ITransactionManager transactionManager = modelingSession.getTransactionManager();
        ITransaction transaction = transactionManager.createTransaction(taskName);
        try {
            try {
                service.run(true, false, (IRunnableWithProgress)deployLauncher);
                transactionManager.commit(transaction);
                transaction = null;
                return;
            }
            catch (InvocationTargetException e) {
                LOG.error((String)"org.modelio.ramcs", (Throwable)e);
                if (transaction == null) return;
                transactionManager.rollback(transaction);
                return;
            }
            catch (InterruptedException e) {
                LOG.warning((String)"org.modelio.ramcs", (Throwable)e);
                if (transaction == null) return;
                transactionManager.rollback(transaction);
                return;
            }
            catch (InvalidTransactionException e) {
                transaction = null;
                LOG.error((String)"org.modelio.ramcs", (Throwable)e);
                if (transaction == null) return;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                transactionManager.rollback(transaction);
                return;
            }
        }
        finally {
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
    }

    private DeployRamcDataModel promptUser() {
        DeployRamcDataModel dataModel;
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        DeployRamcDialog dialog = new DeployRamcDialog(parentShell, dataModel = new DeployRamcDataModel());
        int code = dialog.open();
        if (code == 0) {
            return dataModel;
        }
        return null;
    }
}

