/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.deployer;

import com.modeliosoft.modelio.bridges.mda.infra.RamcManagerBridge;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.INativeModelingSession;
import com.modeliosoft.modelio.core.zip.Unzipper;
import com.modeliosoft.modelio.ramcs.ui.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.FileChannel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.swt.widgets.Display;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class RamcDeployer {
    private InputStream metadataStream = null;

    public void deployRamc(IModelingSession modelingSession, File ramcFile, File projectDirectory, IProgressMonitor monitor) {
        block8: {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)30);
            File tmpDirectory = null;
            try {
                try {
                    subMonitor.subTask(Messages.getMessage((String)"DeployRamcDialog.ExtractModelComponent", (String[])new String[]{ramcFile.getPath()}));
                    tmpDirectory = File.createTempFile("ramc", null);
                    tmpDirectory.delete();
                    tmpDirectory.mkdir();
                    this.unzipRamc(ramcFile, tmpDirectory, (IProgressMonitor)subMonitor.newChild(10));
                    subMonitor.subTask(Messages.getString((String)"DeployRamcDialog.ImportModelComponent"));
                    Element metadataElement = this.openMetadata(tmpDirectory);
                    String ramcName = metadataElement.getAttribute("name");
                    RamcManagerBridge.internalizeRamc((INativeModelingSession)modelingSession.getNativeSession(), (String)ramcName, (File)tmpDirectory);
                    subMonitor.worked(10);
                    subMonitor.subTask(Messages.getString((String)"DeployRamcDialog.ImportFiles"));
                    this.deployFiles(tmpDirectory, projectDirectory, metadataElement);
                    subMonitor.worked(10);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
                    if (tmpDirectory != null) {
                        this.deleteDirectory(tmpDirectory);
                    }
                    this.closeMetadata();
                    break block8;
                }
            }
            catch (Throwable throwable) {
                if (tmpDirectory != null) {
                    this.deleteDirectory(tmpDirectory);
                }
                this.closeMetadata();
                throw throwable;
            }
            if (tmpDirectory != null) {
                this.deleteDirectory(tmpDirectory);
            }
            this.closeMetadata();
        }
    }

    private void deployFiles(File ramcDirectory, File projectPath, Element metadataElement) {
        try {
            NodeList childNodes = metadataElement.getChildNodes();
            File currentFile = null;
            File destinationFile = null;
            long date = 0L;
            int i = 0;
            while (i < childNodes.getLength()) {
                Element el;
                Node n = childNodes.item(i);
                if (n instanceof Element && "file".equals((el = (Element)n).getNodeName())) {
                    currentFile = new File(ramcDirectory, el.getAttribute("archive-name"));
                    destinationFile = new File(projectPath, el.getAttribute("destination-path"));
                    date = Long.valueOf(el.getAttribute("mtime"));
                    destinationFile.getParentFile().mkdirs();
                    this.copy(currentFile, destinationFile);
                    destinationFile.setLastModified(date * 1000L);
                }
                ++i;
            }
        }
        catch (IOException e) {
            System.out.println(Messages.getMessage((String)"DeployRamcDialog.ManifestParsingIOException", (String[])new String[]{e.getMessage()}));
            e.printStackTrace();
        }
    }

    private void unzipRamc(File modelComponentFile, File ramcDirectory, IProgressMonitor monitor) throws IOException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        Unzipper unzipper = new Unzipper();
        unzipper.unzip(modelComponentFile, ramcDirectory, (IProgressMonitor)subMonitor);
    }

    private boolean deleteDirectory(File path) {
        boolean result = true;
        if (path.exists()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                result = files[i].isDirectory() ? (result &= this.deleteDirectory(files[i])) : (result &= files[i].delete());
                ++i;
            }
        }
        return result &= path.delete();
    }

    private File copy(File in, File out) throws IOException {
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        if (!in.equals(out)) {
            inChannel = new FileInputStream(in).getChannel();
            outChannel = new FileOutputStream(out).getChannel();
            try {
                inChannel.transferTo(0L, inChannel.size(), outChannel);
            }
            finally {
                if (inChannel != null) {
                    inChannel.close();
                }
                if (outChannel != null) {
                    outChannel.close();
                }
            }
        }
        return out;
    }

    private void closeMetadata() {
        try {
            if (this.metadataStream != null) {
                this.metadataStream.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private Element openMetadata(File tmpDirectory) {
        File metadataFile = new File(tmpDirectory, "metadatas.xml");
        try {
            this.metadataStream = new FileInputStream(metadataFile);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setXIncludeAware(false);
            dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document xmlDoc = db.parse(this.metadataStream);
            return xmlDoc.getDocumentElement();
        }
        catch (ParserConfigurationException e) {
            System.out.println(Messages.getMessage((String)"DeployRamcDialog.CannotInitXmlParser", (String[])new String[]{e.getMessage()}));
            e.printStackTrace();
        }
        catch (SAXException e) {
            System.out.println(Messages.getMessage((String)"DeployRamcDialog.SaxParsingException", (String[])new String[]{e.getMessage()}));
            e.printStackTrace();
        }
        catch (IOException e) {
            System.out.println(Messages.getMessage((String)"DeployRamcDialog.ManifestParsingIOException", (String[])new String[]{e.getMessage()}));
            e.printStackTrace();
        }
        return null;
    }
}

