/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.deployer.gui;

import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.api.model.uml.statik.IComponent;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.ramcs.plugin.Ramcs;

public class DeployRamcAdapter {
    private String dependencyName = "";
    private String id = "";
    private Version dependencyVersion = null;
    private boolean ramcDependencyInstalled = false;

    public DeployRamcAdapter(String dependencyName, Version dependencyVersion, String id) {
        this.dependencyName = dependencyName;
        this.dependencyVersion = dependencyVersion;
        this.id = id;
        this.initRamcDependencyInstalled();
    }

    public String getDependencyName() {
        return this.dependencyName;
    }

    public Version getDependencyVersion() {
        return this.dependencyVersion;
    }

    public String getId() {
        return this.id;
    }

    public boolean isRamcDependencyInstalled() {
        return this.ramcDependencyInstalled;
    }

    private void initRamcDependencyInstalled() {
        Version artifactVersion;
        IModelingSession modelingSession = Ramcs.getInstance().getModelingSession();
        IPackage rootPackage = modelingSession.getModel().getProject().getModel();
        ObList modelTrees = rootPackage.getOwnedElement(IComponent.class);
        IArtifact ramc = (IArtifact)modelingSession.getModel().findByRef(new ObRef("Artifact", this.id));
        if (ramc == null) {
            for (IModelTree modelTree : modelTrees) {
                IComponent component = (IComponent)modelTree;
                if (!component.isStereotyped("ModelComponent")) continue;
                ObList artifactTrees = component.getOwnedElement(IArtifact.class);
                for (IArtifact artifact : artifactTrees) {
                    Version artifactVersion2 = this.getVersion(artifact);
                    if (!artifact.getName().equals(this.dependencyName) || !artifactVersion2.equals((Object)this.dependencyVersion) && !artifactVersion2.isNewerThan(this.dependencyVersion)) continue;
                    ramc = artifact;
                }
            }
        }
        if (ramc != null && (artifactVersion = this.getVersion(ramc)) != null && (artifactVersion.equals((Object)this.dependencyVersion) || artifactVersion.isNewerThan(this.dependencyVersion))) {
            this.ramcDependencyInstalled = true;
            return;
        }
    }

    private Version getVersion(IArtifact ramc) {
        ObList taggedValues = ramc.getTag();
        for (ITaggedValue taggedValue : taggedValues) {
            ObList parameters;
            ITagType type = taggedValue.getDefinition();
            if (type == null || !type.getName().equals("ModelComponentVersion") || (parameters = taggedValue.getActual()).size() != 1) continue;
            return new Version(((ITagParameter)parameters.get(0)).getValue());
        }
        return null;
    }
}

