/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.deployer.gui;

import com.modeliosoft.modelio.ramcs.deployer.gui.DeployRamcAdapter;
import com.modeliosoft.modelio.ramcs.deployer.gui.DeployRamcContributorAdapter;
import com.modeliosoft.modelio.ramcs.deployer.gui.DeployRamcDataModel;
import com.modeliosoft.modelio.ramcs.deployer.gui.DeployRamcDialog;
import com.modeliosoft.modelio.ramcs.deployer.gui.InvalidModelComponentException;
import com.modeliosoft.modelio.ramcs.ui.Messages;
import java.io.File;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Shell;

public class DeployRamcController
implements ModifyListener {
    private DeployRamcDataModel dataModel = null;
    private DeployRamcDialog dialog = null;

    public DeployRamcController(DeployRamcDataModel dataModel, DeployRamcDialog dialog) {
        this.dataModel = dataModel;
        this.dialog = dialog;
    }

    public void modifyText(ModifyEvent event) {
        String ramcPath = this.dialog.getRamcPath();
        boolean isValidRamcPath = true;
        if (event.widget == this.dialog.ramcPathText) {
            isValidRamcPath = this.validateRamcPath();
            if (isValidRamcPath) {
                try {
                    this.dataModel.updateModelComponentData(ramcPath);
                }
                catch (InvalidModelComponentException e) {
                    this.dialog.invalidateRamcPath(true);
                    MessageDialog.openError((Shell)this.dialog.getShell(), (String)Messages.getString((String)"DeployRamcDialog.InvalidModelComponentTitle"), (String)Messages.getMessage((String)"DeployRamcDialog.InvalidModelComponentMessage", (String[])new String[]{e.getRamcName()}));
                    this.dialog.ramcPathText.setText("");
                }
            }
            this.dialog.invalidateRamcPath(!isValidRamcPath);
        }
        this.dialog.refresh();
        this.dialog.updateButtons(this.validateData());
    }

    private boolean validateRamcPath() {
        String ramcPath = this.dialog.getRamcPath();
        File ramcFile = new File(ramcPath);
        if (ramcPath == null || ramcPath.equals("")) {
            return false;
        }
        if (!ramcFile.isFile()) {
            return false;
        }
        return ramcPath.endsWith(".ramc");
    }

    public boolean validateData() {
        List contributors = this.dataModel.getContributors();
        for (DeployRamcContributorAdapter contributor : contributors) {
            if (contributor.isRamcContributorInstalled()) continue;
            return false;
        }
        List dependencies = this.dataModel.getParentRamcs();
        for (DeployRamcAdapter dependency : dependencies) {
            if (dependency.isRamcDependencyInstalled()) continue;
            return false;
        }
        boolean isRamcPathValid = this.validateRamcPath();
        this.dialog.invalidateRamcPath(!isRamcPathValid);
        return isRamcPathValid;
    }
}

