/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.deployer.gui;

import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.core.zip.Unzipper;
import com.modeliosoft.modelio.ramcs.deployer.gui.DeployRamcAdapter;
import com.modeliosoft.modelio.ramcs.deployer.gui.DeployRamcContributorAdapter;
import com.modeliosoft.modelio.ramcs.deployer.gui.InvalidModelComponentException;
import com.modeliosoft.modelio.ramcs.ui.Messages;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DeployRamcDataModel {
    private String modelComponentPath = "";
    private String ramcName = "";
    private String ramcDescription = "";
    private Version ramcVersion = null;
    private List<DeployRamcContributorAdapter> contributors = new ArrayList();
    private List<DeployRamcAdapter> parentRamcs = new ArrayList();

    public String getModelComponentPath() {
        return this.modelComponentPath;
    }

    public String getRamcName() {
        return this.ramcName;
    }

    public String getRamcDescription() {
        return this.ramcDescription;
    }

    public void setRamcDescription(String value) {
        this.ramcDescription = value;
    }

    public Version getRamcVersion() {
        return this.ramcVersion;
    }

    public void setRamcVersion(Version value) {
        this.ramcVersion = value;
    }

    public List<DeployRamcContributorAdapter> getContributors() {
        return this.contributors;
    }

    public List<DeployRamcAdapter> getParentRamcs() {
        return this.parentRamcs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateModelComponentData(String ramcPath) throws InvalidModelComponentException {
        File ramcFile = new File(ramcPath);
        this.resetData();
        if (!ramcFile.isFile()) return;
        InputStream metadataStream = null;
        try {
            try {
                try {
                    Element ramcNode;
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    dbf.setXIncludeAware(false);
                    dbf.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", false);
                    DocumentBuilder db = dbf.newDocumentBuilder();
                    Unzipper unzipper = new Unzipper();
                    metadataStream = unzipper.getEntryStream(new File(ramcPath), "metadatas.xml");
                    Document xmlDoc = db.parse(metadataStream);
                    Element ramcElement = ramcNode = xmlDoc.getDocumentElement();
                    String manifestVersion = ramcElement.getAttribute("manifest-version");
                    if (this.checkManifestVersion(manifestVersion)) {
                        this.ramcName = ramcElement.getAttribute("name");
                        int version = Integer.valueOf(ramcElement.getAttribute("version"));
                        int release = Integer.valueOf(ramcElement.getAttribute("release"));
                        int clevel = Integer.valueOf(ramcElement.getAttribute("clevel"));
                        this.ramcVersion = new Version(version, release, clevel, 0);
                        NodeList childNodes = xmlDoc.getDocumentElement().getChildNodes();
                        int i = 0;
                        while (i < childNodes.getLength()) {
                            Node n = childNodes.item(i);
                            if (n instanceof Element) {
                                Element el = (Element)n;
                                if ("description".equals(el.getNodeName())) {
                                    this.ramcDescription = el.getTextContent().trim();
                                } else if ("dependencies".equals(el.getNodeName())) {
                                    this.updateDependencies(el);
                                } else if ("contributors".equals(el.getNodeName())) {
                                    this.updateContributors(el);
                                }
                            }
                            ++i;
                        }
                        this.modelComponentPath = ramcPath;
                        return;
                    }
                    String ramcName = ramcElement.getAttribute("name");
                    throw new InvalidModelComponentException(ramcName);
                }
                catch (ParserConfigurationException e) {
                    System.out.println(Messages.getMessage((String)"DeployRamcDialog.CannotInitXmlParser", (String[])new String[]{e.getMessage()}));
                    e.printStackTrace();
                    if (metadataStream == null) return;
                    metadataStream.close();
                    return;
                }
                catch (SAXException e) {
                    System.out.println(Messages.getMessage((String)"DeployRamcDialog.SaxParsingException", (String[])new String[]{e.getMessage()}));
                    e.printStackTrace();
                    if (metadataStream == null) return;
                    metadataStream.close();
                    return;
                }
            }
            finally {
                if (metadataStream != null) {
                    metadataStream.close();
                }
            }
        }
        catch (IOException e) {
            System.out.println(Messages.getMessage((String)"DeployRamcDialog.ManifestParsingIOException", (String[])new String[]{e.getMessage()}));
            e.printStackTrace();
        }
    }

    private void resetData() {
        this.ramcName = "";
        this.ramcVersion = null;
        this.ramcDescription = "";
        this.contributors.clear();
        this.parentRamcs.clear();
    }

    private void updateContributors(Element contributorsNode) {
        NodeList contributorNodes = contributorsNode.getChildNodes();
        DeployRamcContributorAdapter adapter = null;
        int i = 0;
        while (i < contributorNodes.getLength()) {
            Node contributorNode = contributorNodes.item(i);
            if (contributorNode instanceof Element) {
                Element contributorElement = (Element)contributorNode;
                String mdacName = contributorElement.getAttribute("name");
                Version mdacVersion = new Version(contributorElement.getAttribute("version"));
                adapter = new DeployRamcContributorAdapter(mdacName, mdacVersion);
                this.contributors.add(adapter);
            }
            ++i;
        }
    }

    private void updateDependencies(Element dependenciesNode) {
        NodeList dependencyNodes = dependenciesNode.getChildNodes();
        DeployRamcAdapter adapter = null;
        int i = 0;
        while (i < dependencyNodes.getLength()) {
            Node dependencyNode = dependencyNodes.item(i);
            if (dependencyNode instanceof Element) {
                Element dependencyElement = (Element)dependencyNode;
                String dependencyName = dependencyElement.getAttribute("name");
                Version dependencyVersion = new Version(dependencyElement.getAttribute("version"));
                String id = dependencyElement.getAttribute("id");
                adapter = new DeployRamcAdapter(dependencyName, dependencyVersion, id);
                this.parentRamcs.add(adapter);
            }
            ++i;
        }
    }

    private boolean checkManifestVersion(String manifestVersion) {
        Version requiredVersion = new Version(1, 0, 0, 0);
        if (manifestVersion == null || manifestVersion.equals("")) {
            return false;
        }
        Version version = new Version(manifestVersion);
        if (version == null) {
            return false;
        }
        return version.equals((Object)requiredVersion);
    }
}

