/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.deployer.gui;

import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.ramcs.deployer.gui.DeployContributorsContentProvider;
import com.modeliosoft.modelio.ramcs.deployer.gui.DeployContributorsLabelProvider;
import com.modeliosoft.modelio.ramcs.deployer.gui.DeployDependenciesContentProvider;
import com.modeliosoft.modelio.ramcs.deployer.gui.DeployDependenciesLabelProvider;
import com.modeliosoft.modelio.ramcs.deployer.gui.DeployRamcController;
import com.modeliosoft.modelio.ramcs.deployer.gui.DeployRamcDataModel;
import com.modeliosoft.modelio.ramcs.ui.Messages;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.osgi.framework.Bundle;

public class DeployRamcDialog
extends ModelioDialog {
    protected Button createButton = null;
    protected Button cancelButton = null;
    private DeployRamcDataModel dataModel = null;
    private Label ramcPathLabel = null;
    protected Text ramcPathText = null;
    private Button ramcPathButton = null;
    private Image fileChooserImage = null;
    private FileDialog ramcPathChooser = null;
    private Label mdacContributorsLabel = null;
    private Label ramcNameLabel = null;
    private Label ramcVersionLabel = null;
    private Label ramcDescriptionLabel = null;
    private Label ramcDependenciesLabel = null;
    private Text ramcNameText = null;
    private Text ramcVersionText = null;
    private Text ramcDescriptionText = null;
    private TableViewer mdacContributorsList = null;
    private TableViewer ramcDependenciesList = null;
    private DeployRamcController controller = null;

    public DeployRamcDialog(Shell parentShell, DeployRamcDataModel dataModel) {
        super(parentShell);
        this.dataModel = dataModel;
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.createButton = this.createButton(parent, 0, Messages.getString((String)"DeployRamcDialog.Deploy"), false);
        this.cancelButton = this.createButton(parent, 1, Messages.getString((String)"DeployRamcDialog.Cancel"), true);
    }

    public Control createContentArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(1808));
        GridLayout areaLayout = new GridLayout(3, false);
        area.setLayout((Layout)areaLayout);
        this.createRamcPathField(area);
        this.createRamcNameField(area);
        this.createRamcVersionField(area);
        this.createDescriptionField(area);
        this.createDependenciesField(area);
        this.createMdacContributorsField(area);
        this.refresh();
        this.controller = new DeployRamcController(this.dataModel, this);
        this.addListener(this.controller);
        return area;
    }

    private void createRamcPathField(Composite area) {
        this.ramcPathLabel = new Label(area, 0);
        this.ramcPathLabel.setText(Messages.getString((String)"PackageRamcDialog.ModelComponentPath"));
        this.ramcPathText = new Text(area, 2048);
        this.ramcPathButton = new Button(area, 0);
        this.ramcPathButton.setImage(this.getFileChooserButtonImage());
        this.ramcPathChooser = new FileDialog(this.getShell(), 4096);
        this.ramcPathChooser.setFilterExtensions(new String[]{"*.ramc"});
        this.ramcPathChooser.setFilterNames(new String[]{Messages.getString((String)"PackageRamcDialog.RamcFiles")});
        this.ramcPathButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        GridData gd_ramcPathLabel = new GridData(16384, 128, false, false, 1, 1);
        this.ramcPathLabel.setLayoutData((Object)gd_ramcPathLabel);
        GridData gd_ramcPathText = new GridData(4, 128, true, false, 1, 1);
        this.ramcPathText.setLayoutData((Object)gd_ramcPathText);
        GridData gd_ramcPathButton = new GridData(16384, 128, false, false, 1, 1);
        gd_ramcPathButton.heightHint = 21;
        gd_ramcPathButton.widthHint = 21;
        this.ramcPathButton.setLayoutData((Object)gd_ramcPathButton);
    }

    private Image getFileChooserButtonImage() {
        Bundle bundle = Platform.getBundle((String)"org.modelio.ramcs");
        URL url = FileLocator.find((Bundle)bundle, (IPath)new Path("icons/fileChooser_16.png"), null);
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)url);
        this.fileChooserImage = imageDescriptor.createImage();
        return this.fileChooserImage;
    }

    public void init() {
        this.setLogoImage(null);
        this.getShell().setText(Messages.getString((String)"DeployRamcDialog.DialogTitle"));
        this.setTitle(Messages.getString((String)"DeployRamcDialog.MessageTitle"));
        this.setMessage(Messages.getString((String)"DeployRamcDialog.DialogMessage"));
        this.getShell().setSize(500, 500);
        this.getShell().setMinimumSize(500, 450);
        this.updateButtons(this.controller.validateData());
    }

    public boolean close() {
        this.removeListener(this.controller);
        if (this.fileChooserImage != null) {
            this.fileChooserImage.dispose();
            this.fileChooserImage = null;
        }
        return super.close();
    }

    private void createDependenciesField(Composite area) {
        this.ramcDependenciesLabel = new Label(area, 0);
        this.ramcDependenciesLabel.setText(Messages.getString((String)"PackageRamcDialog.RamcDependencies"));
        this.initDependenciesListViewer(area);
        Composite emptyComposite = new Composite(area, 0);
        GridData gd_ramcDependenciesLabel = new GridData(16384, 128, false, false, 1, 1);
        this.ramcDependenciesLabel.setLayoutData((Object)gd_ramcDependenciesLabel);
        GridData gd_emptyComposite = new GridData(16384, 128, false, false, 1, 1);
        gd_emptyComposite.heightHint = 21;
        gd_emptyComposite.widthHint = 21;
        emptyComposite.setLayoutData((Object)gd_emptyComposite);
    }

    private void createDescriptionField(Composite area) {
        this.ramcDescriptionLabel = new Label(area, 0);
        this.ramcDescriptionLabel.setText(Messages.getString((String)"PackageRamcDialog.RamcDescription"));
        this.ramcDescriptionText = new Text(area, 2818);
        this.ramcDescriptionText.setEditable(false);
        this.ramcDescriptionText.setBackground(UIColor.TEXT_READONLY_BG);
        this.ramcDescriptionText.setForeground(UIColor.LABEL_TIP_FG);
        Composite emptyComposite = new Composite(area, 0);
        GridData gd_ramcDescriptionLabel = new GridData(16384, 128, false, false);
        this.ramcDescriptionLabel.setLayoutData((Object)gd_ramcDescriptionLabel);
        GridData gd_ramcDescriptionText = new GridData(4, 4, true, true);
        this.ramcDescriptionText.setLayoutData((Object)gd_ramcDescriptionText);
        GridData gd_emptyComposite = new GridData(16384, 128, false, false, 1, 1);
        gd_emptyComposite.heightHint = 21;
        gd_emptyComposite.widthHint = 21;
        emptyComposite.setLayoutData((Object)gd_emptyComposite);
    }

    private void createRamcVersionField(Composite area) {
        this.ramcVersionLabel = new Label(area, 0);
        this.ramcVersionLabel.setText(Messages.getString((String)"PackageRamcDialog.RamcVersion"));
        this.ramcVersionText = new Text(area, 2048);
        this.ramcVersionText.setEditable(false);
        this.ramcVersionText.setBackground(UIColor.TEXT_READONLY_BG);
        this.ramcVersionText.setForeground(UIColor.LABEL_TIP_FG);
        Composite emptyComposite = new Composite(area, 0);
        GridData gd_ramcVersionLabel = new GridData(16384, 128, false, false, 1, 1);
        this.ramcVersionLabel.setLayoutData((Object)gd_ramcVersionLabel);
        GridData gd_ramcVersionText = new GridData(4, 128, true, false, 1, 1);
        this.ramcVersionText.setLayoutData((Object)gd_ramcVersionText);
        GridData gd_emptyComposite = new GridData(16384, 128, false, false, 1, 1);
        gd_emptyComposite.heightHint = 21;
        gd_emptyComposite.widthHint = 21;
        emptyComposite.setLayoutData((Object)gd_emptyComposite);
    }

    private void createRamcNameField(Composite area) {
        this.ramcNameLabel = new Label(area, 0);
        this.ramcNameLabel.setText(Messages.getString((String)"PackageRamcDialog.RamcName"));
        this.ramcNameText = new Text(area, 2048);
        this.ramcNameText.setEditable(false);
        this.ramcNameText.setBackground(UIColor.TEXT_READONLY_BG);
        this.ramcNameText.setForeground(UIColor.LABEL_TIP_FG);
        Composite emptyComposite = new Composite(area, 0);
        GridData gd_ramcNameLabel = new GridData(16384, 128, false, false, 1, 1);
        this.ramcNameLabel.setLayoutData((Object)gd_ramcNameLabel);
        GridData gd_ramcNameText = new GridData(4, 128, true, false, 1, 1);
        this.ramcNameText.setLayoutData((Object)gd_ramcNameText);
        GridData gd_emptyComposite = new GridData(16384, 128, false, false, 1, 1);
        gd_emptyComposite.heightHint = 21;
        gd_emptyComposite.widthHint = 21;
        emptyComposite.setLayoutData((Object)gd_emptyComposite);
    }

    private void createMdacContributorsField(Composite area) {
        this.mdacContributorsLabel = new Label(area, 0);
        this.mdacContributorsLabel.setText(Messages.getString((String)"PackageRamcDialog.ContributorsMdac"));
        this.initMdacContributorsList(area);
        Composite emptyComposite = new Composite(area, 0);
        GridData gd_mdacContributorsLabel = new GridData(16384, 128, false, false);
        this.mdacContributorsLabel.setLayoutData((Object)gd_mdacContributorsLabel);
        GridData gd_emptyComposite = new GridData(16384, 128, false, false, 1, 1);
        gd_emptyComposite.heightHint = 21;
        gd_emptyComposite.widthHint = 21;
        emptyComposite.setLayoutData((Object)gd_emptyComposite);
    }

    public void addListener(DeployRamcController listener) {
        this.ramcPathText.addModifyListener((ModifyListener)listener);
    }

    public void removeListener(DeployRamcController listener) {
        this.ramcPathText.removeModifyListener((ModifyListener)listener);
    }

    public void refresh() {
        this.ramcNameText.setText(this.dataModel.getRamcName());
        Version ramcVersion = this.dataModel.getRamcVersion();
        if (ramcVersion == null) {
            this.ramcVersionText.setText("");
        } else {
            this.ramcVersionText.setText(String.valueOf(ramcVersion.getMajorVersion()) + "." + ramcVersion.getMinorVersion() + "." + ramcVersion.getBuildVersion());
        }
        this.ramcDescriptionText.setText(this.dataModel.getRamcDescription());
        this.ramcDependenciesList.setInput((Object)this.dataModel.getParentRamcs());
        this.mdacContributorsList.setInput((Object)this.dataModel.getContributors());
    }

    private void initDependenciesListViewer(Composite area) {
        this.ramcDependenciesList = new TableViewer(area, 2564);
        this.ramcDependenciesList.setContentProvider((IContentProvider)new DeployDependenciesContentProvider());
        this.ramcDependenciesList.setLabelProvider((IBaseLabelProvider)new DeployDependenciesLabelProvider());
        this.ramcDependenciesList.getTable().setBackground(UIColor.TEXT_READONLY_BG);
        this.ramcDependenciesList.getTable().setForeground(UIColor.LABEL_TIP_FG);
        GridData gd_ramcDependenciesList = new GridData(4, 4, true, false);
        gd_ramcDependenciesList.heightHint = 50;
        this.ramcDependenciesList.getTable().setLayoutData((Object)gd_ramcDependenciesList);
    }

    private void initMdacContributorsList(Composite area) {
        this.mdacContributorsList = new TableViewer(area, 2564);
        this.mdacContributorsList.getTable().setBackground(UIColor.TEXT_READONLY_BG);
        this.mdacContributorsList.getTable().setForeground(UIColor.LABEL_TIP_FG);
        this.mdacContributorsList.setContentProvider((IContentProvider)new DeployContributorsContentProvider());
        this.mdacContributorsList.setLabelProvider((IBaseLabelProvider)new DeployContributorsLabelProvider());
        GridData gd_mdacContributorsList = new GridData(4, 4, true, false);
        gd_mdacContributorsList.heightHint = 50;
        this.mdacContributorsList.getTable().setLayoutData((Object)gd_mdacContributorsList);
    }

    public Version getVersion() {
        return new Version(this.ramcVersionText.getText());
    }

    public String getDescription() {
        return this.ramcDescriptionText.getText();
    }

    public String getRamcPath() {
        return this.ramcPathText.getText();
    }

    public void updateButtons(boolean canPackage) {
        if (this.createButton != null) {
            this.createButton.setEnabled(canPackage);
        }
    }

    public void invalidateRamcPath(boolean invalid) {
        if (invalid) {
            this.ramcPathText.setForeground(this.ramcPathText.getDisplay().getSystemColor(3));
        } else {
            this.ramcPathText.setForeground(this.ramcPathText.getDisplay().getSystemColor(6));
        }
    }

    protected String getHelpId() {
        return "/com.modeliosoft.modelio.documentation.modeler/html/Model_components_deployment.html";
    }

    static /* synthetic */ FileDialog access$0(DeployRamcDialog deployRamcDialog) {
        return deployRamcDialog.ramcPathChooser;
    }
}

