/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.edition;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.api.model.uml.statik.IElementImport;
import com.modeliosoft.modelio.api.model.uml.statik.IManifestation;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.api.utils.NoteTypeNotFoundException;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.TagTypeNotFoundException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.ramcs.edition.gui.EditManifestedAdapter;
import com.modeliosoft.modelio.ramcs.edition.gui.EditRamcAdapter;
import com.modeliosoft.modelio.ramcs.edition.gui.EditRamcDataModel;
import com.modeliosoft.modelio.ramcs.edition.gui.EditRamcDialog;
import com.modeliosoft.modelio.ramcs.plugin.Ramcs;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class EditRamcCommand {
    public Object execute(IArtifact ramc) {
        EditRamcDataModel dataModel;
        if (ramc != null && (dataModel = this.promptUser(ramc)) != null) {
            this.updateModel(ramc, dataModel);
        }
        return null;
    }

    public boolean accept(ObList<IElement> selectedElements) {
        IModelElement me;
        IElement element;
        return selectedElements.size() == 1 && (element = (IElement)selectedElements.get(0)) instanceof IModelElement && (me = (IModelElement)element).isStereotyped("ModelComponentArchive");
    }

    public boolean isEnabled(ObList<IElement> selectedElements) {
        return true;
    }

    private EditRamcDataModel promptUser(IArtifact ramc) {
        EditRamcDataModel dataModel;
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        EditRamcDialog dialog = new EditRamcDialog(parentShell, dataModel = new EditRamcDataModel(ramc));
        int code = dialog.open();
        if (code == 0) {
            return dataModel;
        }
        return null;
    }

    private void updateModel(IArtifact ramc, EditRamcDataModel dataModel) {
        IModelingSession modelingSession = Ramcs.getInstance().getModelingSession();
        IElementStatus ramcStatus = ramc.getElementStatus();
        if (ramcStatus.isModifiable()) {
            ITransactionManager transactionManager = modelingSession.getTransactionManager();
            ITransaction transaction = transactionManager.createTransaction("Update model component");
            try {
                try {
                    ramc.setName(dataModel.getRamcName());
                    ramc.setFileName(dataModel.getModelComponentPath().getPath());
                    this.updateVersion(ramc, dataModel.getRamcVersion(), modelingSession);
                    this.updateDescription(ramc, dataModel.getRamcDescription(), modelingSession);
                    this.updateManifestations(ramc, dataModel, modelingSession);
                    this.updateDependencies(ramc, dataModel, modelingSession);
                    this.updateExportedFiles(ramc, dataModel, modelingSession);
                    transactionManager.commit(transaction);
                    transaction = null;
                }
                catch (InvalidTransactionException e) {
                    transaction = null;
                    if (transaction != null) {
                        transactionManager.rollback(transaction);
                    }
                }
            }
            finally {
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
            }
        }
    }

    private void updateDescription(IArtifact ramc, String ramcDescription, IModelingSession modelingSession) {
        ObList notes = ramc.getDescriptor();
        INote descriptionNote = null;
        for (INote note : notes) {
            INoteType type = note.getModel();
            if (type == null || !type.getName().equals("description")) continue;
            descriptionNote = note;
        }
        if (descriptionNote == null) {
            IModelFactory factory = modelingSession.getModelFactory();
            try {
                factory.createNote("description", (IModelElement)ramc, ramcDescription);
            }
            catch (NoteTypeNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            descriptionNote.setContent(ramcDescription);
        }
    }

    private void updateVersion(IArtifact ramc, Version ramcVersion, IModelingSession modelingSession) {
        ObList taggedValues = ramc.getTag();
        String buildVersion = String.format("%02d", ramcVersion.getBuildVersion());
        String version = String.valueOf(ramcVersion.getMajorVersion()) + "." + ramcVersion.getMinorVersion() + "." + buildVersion;
        ITaggedValue versionTag = null;
        for (ITaggedValue taggedValue : taggedValues) {
            ITagType type = taggedValue.getDefinition();
            if (type == null || !type.getName().equals("ModelComponentVersion")) continue;
            versionTag = taggedValue;
        }
        if (versionTag == null) {
            IModelFactory factory = modelingSession.getModelFactory();
            try {
                versionTag = factory.createTaggedValue("ModelComponentVersion", (IModelElement)ramc);
                factory.createTagParameter(version, versionTag);
            }
            catch (TagTypeNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            ObList parameters = versionTag.getActual();
            if (parameters.size() > 0) {
                ((ITagParameter)parameters.get(0)).setValue(version);
            }
        }
    }

    private void updateDependencies(IArtifact ramc, EditRamcDataModel dataModel, IModelingSession modelingSession) {
        List requiredRamcAdapters = dataModel.getParentRamcs();
        ArrayList<IArtifact> requiredRamcs = new ArrayList<IArtifact>();
        for (EditRamcAdapter adapter : requiredRamcAdapters) {
            requiredRamcs.add(adapter.getRamc());
        }
        ArrayList<IArtifact> importedRamcs = new ArrayList<IArtifact>();
        for (IElementImport elementImport : ramc.getOwnedImport()) {
            IArtifact importedArtifact;
            INameSpace importedElement = elementImport.getImportedElement();
            if (!(importedElement instanceof IArtifact) || !(importedArtifact = (IArtifact)importedElement).isStereotyped("ModelComponentArchive")) continue;
            importedRamcs.add(importedArtifact);
        }
        for (IArtifact importedRamc : importedRamcs) {
            if (requiredRamcs.contains(importedRamc)) continue;
            this.removeRamcFromModel(modelingSession, ramc, importedRamc);
        }
        for (IArtifact requiredRamc : requiredRamcs) {
            if (importedRamcs.contains(requiredRamc)) continue;
            this.addRamcToModel(modelingSession, ramc, requiredRamc);
        }
    }

    private void addRamcToModel(IModelingSession modelingSession, IArtifact ramc, IArtifact requiredRamc) {
        IModelFactory factory = modelingSession.getModelFactory();
        factory.createElementImport((INameSpace)ramc, (INameSpace)requiredRamc);
    }

    private void removeRamcFromModel(IModelingSession modelingSession, IArtifact ramc, IArtifact ramcToRemove) {
        IModelFactory factory = modelingSession.getModelFactory();
        for (IElementImport elementImport : ramc.getOwnedImport()) {
            IArtifact importedArtifact;
            INameSpace importedElement = elementImport.getImportedElement();
            if (!(importedElement instanceof IArtifact) || !(importedArtifact = (IArtifact)importedElement).equals((Object)ramcToRemove)) continue;
            factory.deleteElement((IElement)elementImport);
        }
    }

    private void updateManifestations(IArtifact ramc, EditRamcDataModel dataModel, IModelingSession modelingSession) {
        List requiredAdapters = dataModel.getManifestedElements();
        ArrayList<IModelElement> requiredElements = new ArrayList<IModelElement>();
        for (EditManifestedAdapter adapter : requiredAdapters) {
            requiredElements.add((IModelElement)adapter.getElement());
        }
        ArrayList<IModelElement> manifestedElements = new ArrayList<IModelElement>();
        for (IManifestation manifestation : ramc.getUtilized()) {
            IModelElement manifestedElement = manifestation.getUtilizedElement();
            manifestedElements.add(manifestedElement);
        }
        for (IModelElement manifestedElement : manifestedElements) {
            if (requiredElements.contains(manifestedElement)) continue;
            this.removeManifestationFromModel(modelingSession, ramc, manifestedElement);
        }
        for (IModelElement requiredElement : requiredElements) {
            if (manifestedElements.contains(requiredElement)) continue;
            this.addManifestationFromModel(modelingSession, ramc, requiredElement);
        }
    }

    private void addManifestationFromModel(IModelingSession modelingSession, IArtifact ramc, IModelElement element) {
        IModelFactory factory = modelingSession.getModelFactory();
        IManifestation manifestation = factory.createManifestation();
        ramc.addUtilized(manifestation);
        manifestation.setUtilizedElement(element);
    }

    private void removeManifestationFromModel(IModelingSession modelingSession, IArtifact ramc, IModelElement manifestedElementToRemove) {
        IModelFactory factory = modelingSession.getModelFactory();
        for (IManifestation manifestation : ramc.getUtilized()) {
            IModelElement manifestedElement = manifestation.getUtilizedElement();
            if (!manifestedElement.equals((Object)manifestedElementToRemove)) continue;
            factory.deleteElement((IElement)manifestation);
        }
    }

    private void updateExportedFiles(IArtifact ramc, EditRamcDataModel dataModel, IModelingSession modelingSession) {
        IModelFactory factory = modelingSession.getModelFactory();
        ObList taggedvalues = ramc.getTag();
        ArrayList<ITaggedValue> taggedValuetoRemove = new ArrayList<ITaggedValue>();
        int cpt = 0;
        for (ITaggedValue taggedvalue : taggedvalues) {
            ITagType type = taggedvalue.getDefinition();
            if (type == null || !type.getName().equals("ModelComponentFiles")) continue;
            if (cpt > 0) {
                taggedValuetoRemove.add(taggedvalue);
            }
            ++cpt;
        }
        for (ITaggedValue taggedValue : taggedValuetoRemove) {
            factory.deleteElement((IElement)taggedValue);
        }
        Set requiredFiles = dataModel.getExportedFiles();
        HashSet<File> exportedFiles = new HashSet<File>();
        taggedvalues = ramc.getTag();
        for (ITaggedValue taggedvalue : taggedvalues) {
            ITagType type = taggedvalue.getDefinition();
            if (type == null || !type.getName().equals("ModelComponentFiles")) continue;
            for (ITagParameter parameter : taggedvalue.getActual()) {
                exportedFiles.add(new File(parameter.getValue()));
            }
        }
        for (File exportedFile : exportedFiles) {
            if (requiredFiles.contains(exportedFile)) continue;
            this.removeExportedFileFromModel(modelingSession, ramc, exportedFile);
        }
        for (File requiredFile : requiredFiles) {
            if (exportedFiles.contains(requiredFile)) continue;
            this.addExportedFileFromModel(modelingSession, ramc, requiredFile);
        }
    }

    private void addExportedFileFromModel(IModelingSession modelingSession, IArtifact ramc, File exportedFile) {
        IModelFactory factory = modelingSession.getModelFactory();
        ITaggedValue tagToUpdate = null;
        ObList taggedvalues = ramc.getTag();
        for (ITaggedValue taggedvalue : taggedvalues) {
            ITagType type = taggedvalue.getDefinition();
            if (type == null || !type.getName().equals("ModelComponentFiles")) continue;
            tagToUpdate = taggedvalue;
            break;
        }
        if (tagToUpdate == null) {
            try {
                tagToUpdate = factory.createTaggedValue("ModelComponentFiles", (IModelElement)ramc);
            }
            catch (TagTypeNotFoundException e) {
                e.printStackTrace();
            }
        }
        if (tagToUpdate != null) {
            factory.createTagParameter(exportedFile.getPath(), tagToUpdate);
        }
    }

    private void removeExportedFileFromModel(IModelingSession modelingSession, IArtifact ramc, File exportedFile) {
        IModelFactory factory = modelingSession.getModelFactory();
        ObList taggedvalues = ramc.getTag();
        for (ITaggedValue taggedvalue : taggedvalues) {
            ITagType type = taggedvalue.getDefinition();
            if (type == null || !type.getName().equals("ModelComponentFiles")) continue;
            for (ITagParameter parameter : taggedvalue.getActual()) {
                if (!parameter.getValue().equals(exportedFile.getPath())) continue;
                factory.deleteElement((IElement)parameter);
                return;
            }
        }
    }
}

