/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.edition.gui;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.api.model.uml.statik.IElementImport;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.ui.dnd.ModelElementTransfer;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.ramcs.edition.gui.EditRamcController;
import com.modeliosoft.modelio.ramcs.edition.gui.EditRamcDialog;
import com.modeliosoft.modelio.ramcs.plugin.Ramcs;
import com.modeliosoft.modelio.ramcs.ui.Messages;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.widgets.Shell;

public class EditDependenciesDropListener
implements DropTargetListener {
    private EditRamcDialog dialog;
    private EditRamcController controler = null;
    private IArtifact currentRamc = null;

    public EditDependenciesDropListener(EditRamcDialog dialog, EditRamcController controler, IArtifact currentRamc) {
        this.controler = controler;
        this.dialog = dialog;
        this.currentRamc = currentRamc;
    }

    public void dragEnter(DropTargetEvent event) {
        ModelElementTransfer elementTransfer = ModelElementTransfer.getInstance();
        int i = 0;
        while (i < event.dataTypes.length) {
            if (elementTransfer.isSupportedType(event.dataTypes[i])) {
                event.currentDataType = event.dataTypes[i];
                break;
            }
            ++i;
        }
        if (elementTransfer.isSupportedType(event.currentDataType)) {
            boolean accept = true;
            ObRef[] refs = (ObRef[])elementTransfer.nativeToJava(event.currentDataType);
            if (refs != null) {
                IElement[] elements = new IElement[refs.length];
                int i2 = 0;
                while (i2 < elements.length) {
                    elements[i2] = Modelio.getInstance().getModelingSession().findByRef(refs[i2]);
                    ++i2;
                }
                IElement[] iElementArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    IElement element = iElementArray[n2];
                    if (element instanceof IArtifact) {
                        IArtifact artifact = (IArtifact)element;
                        if (artifact.equals((Object)this.currentRamc)) {
                            accept = false;
                        }
                        if (!artifact.isStereotyped("ModelComponentArchive")) {
                            accept = false;
                        }
                    } else {
                        accept = false;
                    }
                    ++n2;
                }
            } else {
                accept = true;
            }
            if (!accept) {
                event.detail = 0;
            }
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        ObRef[] refs;
        ModelElementTransfer elementTransfer = ModelElementTransfer.getInstance();
        int i = 0;
        while (i < event.dataTypes.length) {
            if (elementTransfer.isSupportedType(event.dataTypes[i])) {
                event.currentDataType = event.dataTypes[i];
                break;
            }
            ++i;
        }
        if (elementTransfer.isSupportedType(event.currentDataType) && (refs = (ObRef[])elementTransfer.nativeToJava(event.currentDataType)) != null) {
            IModelingSession modelingSession = Ramcs.getInstance().getModelingSession();
            ArrayList<IElement> elements = new ArrayList<IElement>(refs.length);
            int i2 = 0;
            while (i2 < refs.length) {
                elements.add(modelingSession.getModel().findByRef(refs[i2]));
                ++i2;
            }
            if (System.getProperty("os.name").equals("Linux")) {
                for (IElement element : elements) {
                    if (element instanceof IArtifact) {
                        IArtifact artifact = (IArtifact)element;
                        if (artifact.equals((Object)this.currentRamc)) {
                            return;
                        }
                        if (artifact.isStereotyped("ModelComponentArchive")) continue;
                        return;
                    }
                    return;
                }
            }
            ArrayList<IArtifact> parentRamcs = new ArrayList<IArtifact>();
            ArrayList<IArtifact> cycleArtifacts = new ArrayList<IArtifact>();
            for (IElement element : elements) {
                IArtifact artifact = (IArtifact)element;
                if (!artifact.isStereotyped("ModelComponentArchive")) continue;
                if (!this.causeCycle(artifact)) {
                    parentRamcs.add(artifact);
                    continue;
                }
                cycleArtifacts.add(artifact);
            }
            if (cycleArtifacts.size() > 0) {
                StringBuffer cycleArtifactNames = new StringBuffer();
                int i3 = 0;
                for (IArtifact cycleArtifact : cycleArtifacts) {
                    if (i3 > 0) {
                        cycleArtifactNames.append(", ");
                    }
                    cycleArtifactNames.append(cycleArtifact.getName());
                    ++i3;
                }
                if (cycleArtifacts.size() > 1) {
                    MessageDialog.openInformation((Shell)this.dialog.getShell(), (String)Messages.getString((String)"EditRamcDialog.CycleArtifacts.Title"), (String)Messages.getMessage((String)"EditRamcDialog.CycleArtifacts.ModelComponentsMessage", (String[])new String[]{cycleArtifactNames.toString(), this.currentRamc.getName()}));
                } else {
                    MessageDialog.openInformation((Shell)this.dialog.getShell(), (String)Messages.getString((String)"EditRamcDialog.CycleArtifacts.Title"), (String)Messages.getMessage((String)"EditRamcDialog.CycleArtifacts.ModelComponentMessage", (String[])new String[]{cycleArtifactNames.toString(), this.currentRamc.getName()}));
                }
            }
            this.controler.addRequiredRamcs(parentRamcs);
            this.dialog.refresh();
        }
    }

    private boolean causeCycle(IArtifact artifact) {
        ObList elementImports = artifact.getOwnedImport();
        INameSpace importedNamespace = null;
        for (IElementImport elementImport : elementImports) {
            importedNamespace = elementImport.getImportedElement();
            if (!(importedNamespace instanceof IArtifact) || !importedNamespace.isStereotyped("ModelComponentArchive")) continue;
            if (importedNamespace.equals((Object)this.currentRamc)) {
                return true;
            }
            return this.causeCycle((IArtifact)importedNamespace);
        }
        return false;
    }
}

