/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.edition.gui;

import com.modeliosoft.modelio.api.model.analyst.IDictionary;
import com.modeliosoft.modelio.api.model.analyst.IPropertySet;
import com.modeliosoft.modelio.api.model.analyst.IPropertyType;
import com.modeliosoft.modelio.api.model.analyst.IRequirementContainer;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.ui.dnd.ModelElementTransfer;
import com.modeliosoft.modelio.api.utils.ObRef;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.ramcs.edition.gui.EditRamcController;
import com.modeliosoft.modelio.ramcs.edition.gui.EditRamcDialog;
import com.modeliosoft.modelio.ramcs.plugin.Ramcs;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;

public class EditManifestationsDropListener
implements DropTargetListener {
    private EditRamcDialog dialog;
    private EditRamcController controler = null;

    public EditManifestationsDropListener(EditRamcDialog dialog, EditRamcController controler) {
        this.controler = controler;
        this.dialog = dialog;
    }

    public void dragEnter(DropTargetEvent event) {
        ModelElementTransfer elementTransfer = ModelElementTransfer.getInstance();
        int i = 0;
        while (i < event.dataTypes.length) {
            if (elementTransfer.isSupportedType(event.dataTypes[i])) {
                event.currentDataType = event.dataTypes[i];
                break;
            }
            ++i;
        }
        if (elementTransfer.isSupportedType(event.currentDataType)) {
            boolean accept;
            ObRef[] refs = (ObRef[])elementTransfer.nativeToJava(event.currentDataType);
            if (refs != null) {
                IModelingSession modelingSession = Ramcs.getInstance().getModelingSession();
                ArrayList<IElement> elements = new ArrayList<IElement>(refs.length);
                int i2 = 0;
                while (i2 < refs.length) {
                    elements.add(modelingSession.getModel().findByRef(refs[i2]));
                    ++i2;
                }
                accept = this.checkDragged(elements);
            } else {
                accept = true;
            }
            if (!accept) {
                event.detail = 0;
            }
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dragOperationChanged(DropTargetEvent event) {
    }

    public void dragOver(DropTargetEvent event) {
    }

    public void drop(DropTargetEvent event) {
        ObRef[] refs;
        ModelElementTransfer elementTransfer = ModelElementTransfer.getInstance();
        int i = 0;
        while (i < event.dataTypes.length) {
            if (elementTransfer.isSupportedType(event.dataTypes[i])) {
                event.currentDataType = event.dataTypes[i];
                break;
            }
            ++i;
        }
        if (elementTransfer.isSupportedType(event.currentDataType) && (refs = (ObRef[])event.data) != null) {
            ArrayList<IElement> elements = new ArrayList<IElement>(refs.length);
            IModelingSession modelingSession = Ramcs.getInstance().getModelingSession();
            ObRef[] obRefArray = refs;
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                ObRef ref = obRefArray[n2];
                IElement elt = modelingSession.getModel().findByRef(ref);
                if (elt != null) {
                    elements.add(elt);
                }
                ++n2;
            }
            if (this.checkDragged(elements)) {
                this.controler.addManifestedElements(elements);
                this.dialog.refresh();
            }
        }
    }

    public void dropAccept(DropTargetEvent event) {
    }

    private boolean canBeExported(IElement element) {
        if (element instanceof IPackage) {
            return !element.equals((Object)Ramcs.getInstance().getModelingSession().getModel().getProject().getModel());
        }
        if (element instanceof INameSpace) {
            return true;
        }
        if (element instanceof IDictionary) {
            return true;
        }
        if (element instanceof IRequirementContainer) {
            return true;
        }
        if (element instanceof IPropertySet) {
            return true;
        }
        return element instanceof IPropertyType;
    }

    private boolean checkDragged(List<IElement> elements) {
        for (IElement element : elements) {
            IElementStatus elementStatus = element.getElementStatus();
            if (this.canBeExported(element) && !elementStatus.isRamcObject()) continue;
            return false;
        }
        return true;
    }
}

