/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.edition.gui;

import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.api.utils.ObList;

public class EditRamcAdapter {
    private String ramcName = "";
    private String ramcDescription = "";
    private IArtifact ramc = null;
    private Version ramcVersion = null;

    public EditRamcAdapter(IArtifact ramc) {
        this.ramc = ramc;
        this.ramcName = ramc.getName();
        this.ramcVersion = this.getVersion();
        this.ramcDescription = this.getDescription();
    }

    private String getDescription() {
        ObList notes = this.ramc.getDescriptor();
        for (INote note : notes) {
            INoteType type = note.getModel();
            if (type == null || !type.getName().equals("description")) continue;
            return note.getContent();
        }
        return "";
    }

    private Version getVersion() {
        ObList taggedValues = this.ramc.getTag();
        for (ITaggedValue taggedValue : taggedValues) {
            ObList parameters;
            ITagType type = taggedValue.getDefinition();
            if (type == null || !type.getName().equals("ModelComponentVersion") || (parameters = taggedValue.getActual()).size() != 1) continue;
            return new Version(((ITagParameter)parameters.get(0)).getValue());
        }
        return null;
    }

    public String getRamcName() {
        return this.ramcName;
    }

    public String getRamcDescription() {
        return this.ramcDescription;
    }

    public Version getRamcVersion() {
        return this.ramcVersion;
    }

    public IArtifact getRamc() {
        return this.ramc;
    }

    public boolean equals(Object obj) {
        if (obj instanceof EditRamcAdapter) {
            return this.ramc.equals((Object)((EditRamcAdapter)obj).getRamc());
        }
        return false;
    }
}

