/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.edition.gui;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.change.IModelChangeEvent;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import com.modeliosoft.modelio.ramcs.edition.gui.EditManifestedAdapter;
import com.modeliosoft.modelio.ramcs.edition.gui.EditRamcAdapter;
import com.modeliosoft.modelio.ramcs.edition.gui.EditRamcContributorAdapter;
import com.modeliosoft.modelio.ramcs.edition.gui.EditRamcDataModel;
import com.modeliosoft.modelio.ramcs.edition.gui.EditRamcDialog;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Display;

public class EditRamcController
implements ModifyListener,
ICheckStateListener,
IModelChangeListener {
    private EditRamcDataModel dataModel = null;
    private EditRamcDialog dialog = null;
    private static final Pattern RamcNamePattern = Pattern.compile("[\\p{L}\\p{N}\\._ ]+");

    public EditRamcController(EditRamcDataModel dataModel, EditRamcDialog dialog) {
        this.dataModel = dataModel;
        this.dialog = dialog;
    }

    public void modifyText(ModifyEvent event) {
        boolean isValidRamcName = true;
        boolean isValidRamcVersion = true;
        boolean isValidRamcPath = true;
        if (event.widget == this.dialog.ramcNameText) {
            isValidRamcName = this.validateRamcName();
            if (isValidRamcName) {
                this.dataModel.setRamcName(this.dialog.getRamcName());
            }
            this.dialog.invalidateRamcName(!isValidRamcName);
        }
        if (event.widget == this.dialog.ramcPathText) {
            isValidRamcPath = this.validateRamcPath();
            if (isValidRamcPath) {
                this.dataModel.setModelComponentPath(new File(this.dialog.getRamcPath()));
            }
            this.dialog.invalidateRamcPath(!isValidRamcPath);
        }
        if (event.widget == this.dialog.ramcVersionText) {
            isValidRamcVersion = this.validateRamcVersion();
            if (isValidRamcVersion) {
                this.dataModel.setRamcVersion(this.dialog.getVersion());
            }
            this.dialog.invalidateRamcVersion(!isValidRamcVersion);
        }
        String description = this.dialog.getDescription();
        description = description.replaceAll("\r\n", "\n");
        this.dataModel.setRamcDescription(description);
        this.dialog.updateButtons(isValidRamcVersion && isValidRamcPath);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        EditRamcContributorAdapter adapter = (EditRamcContributorAdapter)event.getElement();
        adapter.setSelected(event.getChecked());
    }

    private boolean validateRamcVersion() {
        try {
            this.dialog.getVersion();
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private boolean validateRamcPath() {
        String ramcPath = this.dialog.getRamcPath();
        File ramcFile = new File(ramcPath);
        if (ramcPath == null || ramcPath.equals("")) {
            return false;
        }
        try {
            ramcFile.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        return ramcPath.endsWith(".ramc");
    }

    public boolean validateData() {
        boolean isRamcNameValid = this.validateRamcName();
        boolean isRamcVersionValid = this.validateRamcVersion();
        boolean isRamcPathValid = this.validateRamcPath();
        this.dialog.invalidateRamcName(!isRamcNameValid);
        this.dialog.invalidateRamcVersion(!isRamcVersionValid);
        this.dialog.invalidateRamcPath(!isRamcPathValid);
        return isRamcNameValid && isRamcVersionValid && isRamcPathValid;
    }

    private boolean validateRamcName() {
        String ramcName = this.dialog.getRamcName();
        return RamcNamePattern.matcher(ramcName).matches();
    }

    public void addRequiredRamcs(List<IArtifact> ramcs) {
        EditRamcAdapter adapter = null;
        List requiredRamcs = this.dataModel.getParentRamcs();
        for (IArtifact ramc : ramcs) {
            adapter = new EditRamcAdapter(ramc);
            if (requiredRamcs.contains(adapter)) continue;
            requiredRamcs.add(adapter);
        }
    }

    public void removeRequiredRamc(EditRamcAdapter adapter) {
        List requiredRamcs = this.dataModel.getParentRamcs();
        requiredRamcs.remove(adapter);
    }

    public void addManifestedElements(List<IElement> elements) {
        EditManifestedAdapter adapter = null;
        List manifestedElements = this.dataModel.getManifestedElements();
        for (IElement element : elements) {
            adapter = new EditManifestedAdapter(element);
            if (manifestedElements.contains(adapter)) continue;
            manifestedElements.add(adapter);
        }
    }

    public void removeExportedAdapter(EditManifestedAdapter adapter) {
        List manifestedElements = this.dataModel.getManifestedElements();
        manifestedElements.remove(adapter);
    }

    public void modelChanged(IModelingSession session, IModelChangeEvent event) {
        if (!this.dataModel.getModelComponent().isValid()) {
            this.dialog.close(1);
            return;
        }
        List manifestedAdapters = this.dataModel.getManifestedElements();
        ArrayList<EditManifestedAdapter> manifestedAdaptersToRemove = new ArrayList<EditManifestedAdapter>();
        for (EditManifestedAdapter manifestedAdapter : manifestedAdapters) {
            if (manifestedAdapter.getElement().isValid()) continue;
            manifestedAdaptersToRemove.add(manifestedAdapter);
        }
        for (EditManifestedAdapter manifestedAdapterToRemove : manifestedAdaptersToRemove) {
            this.removeExportedAdapter(manifestedAdapterToRemove);
        }
        List requiredAdapters = this.dataModel.getParentRamcs();
        ArrayList<EditRamcAdapter> requiredAdaptersToRemove = new ArrayList<EditRamcAdapter>();
        for (EditRamcAdapter requiredAdapter : requiredAdapters) {
            if (requiredAdapter.getRamc().isValid()) continue;
            requiredAdaptersToRemove.add(requiredAdapter);
        }
        for (EditRamcAdapter requiredAdapterToRemove : requiredAdaptersToRemove) {
            this.removeRequiredRamc(requiredAdapterToRemove);
        }
        Display display = Display.getDefault();
        if (display != null) {
            display.asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    static /* synthetic */ EditRamcDialog access$0(EditRamcController editRamcController) {
        return editRamcController.dialog;
    }
}

