/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.edition.gui;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.model.analyst.IDictionary;
import com.modeliosoft.modelio.api.model.analyst.IRequirementContainer;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.api.model.uml.statik.IElementImport;
import com.modeliosoft.modelio.api.model.uml.statik.IManifestation;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.ramcs.edition.gui.EditManifestedAdapter;
import com.modeliosoft.modelio.ramcs.edition.gui.EditRamcAdapter;
import com.modeliosoft.modelio.ramcs.plugin.Ramcs;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class EditRamcDataModel {
    private String ramcName = "";
    private String ramcDescription = "";
    private IArtifact ramc = null;
    private Version ramcVersion = null;
    private List<EditRamcAdapter> parentRamcs = null;
    private File modelComponentPath = null;
    private List<EditManifestedAdapter> manifestedElements = null;
    private Set<File> exportedFiles = null;

    public EditRamcDataModel(IArtifact ramc) {
        this.ramc = ramc;
        this.ramcName = ramc.getName();
        this.ramcVersion = this.getVersion();
        this.ramcDescription = this.getDescription();
        this.initRamcPath();
        this.initManifested();
        this.initDependencies();
        this.initExportedFiles();
    }

    private String getDescription() {
        ObList notes = this.ramc.getDescriptor();
        for (INote note : notes) {
            INoteType type = note.getModel();
            if (type == null || !type.getName().equals("description")) continue;
            return note.getContent();
        }
        return "";
    }

    private Version getVersion() {
        ObList taggedValues = this.ramc.getTag();
        for (ITaggedValue taggedValue : taggedValues) {
            ObList parameters;
            ITagType type = taggedValue.getDefinition();
            if (type == null || !type.getName().equals("ModelComponentVersion") || (parameters = taggedValue.getActual()).size() != 1) continue;
            return new Version(((ITagParameter)parameters.get(0)).getValue());
        }
        return new Version(0, 0, 0, 0);
    }

    private void initDependencies() {
        this.parentRamcs = new ArrayList();
        ObList elementImports = this.ramc.getOwnedImport();
        for (IElementImport elementImport : elementImports) {
            INameSpace importedNamespace = elementImport.getImportedElement();
            if (!(importedNamespace instanceof IArtifact) || !importedNamespace.isStereotyped("ModelComponentArchive")) continue;
            IArtifact ramcArtifact = (IArtifact)importedNamespace;
            this.parentRamcs.add(new EditRamcAdapter(ramcArtifact));
        }
    }

    public String getRamcName() {
        return this.ramcName;
    }

    public String getRamcDescription() {
        return this.ramcDescription;
    }

    public void setRamcDescription(String value) {
        this.ramcDescription = value;
    }

    public Version getRamcVersion() {
        return this.ramcVersion;
    }

    public void setRamcVersion(Version value) {
        this.ramcVersion = value;
    }

    public List<EditRamcAdapter> getParentRamcs() {
        return this.parentRamcs;
    }

    private void initRamcPath() {
        this.modelComponentPath = new File(this.ramc.getFileName());
        if (this.modelComponentPath == null || this.modelComponentPath.getPath().equals("")) {
            this.modelComponentPath = this.getDefaultRamcPath();
        }
    }

    private File getDefaultRamcPath() {
        IModelingSession modelingSession = Ramcs.getInstance().getModelingSession();
        IMdac modelComponentMdac = this.getModelComponentMdac();
        if (modelComponentMdac != null) {
            String defaultRamcPath = modelComponentMdac.getConfiguration().getParameterValue("DefaultRamcDirectory");
            File defaultRamcDirectory = new File(defaultRamcPath);
            if (defaultRamcPath != null && !defaultRamcPath.equals("")) {
                try {
                    defaultRamcDirectory.getCanonicalFile();
                }
                catch (IOException e) {
                    defaultRamcDirectory = modelingSession.getWorkspacePath();
                }
            } else {
                defaultRamcDirectory = modelingSession.getWorkspacePath();
            }
            return new File(defaultRamcDirectory, String.valueOf(this.ramc.getName()) + ".ramc");
        }
        return new File(modelingSession.getWorkspacePath(), String.valueOf(this.ramc.getName()) + ".ramc");
    }

    private IMdac getModelComponentMdac() {
        IModelingSession modelingSession = Ramcs.getInstance().getModelingSession();
        ObList mdacModels = modelingSession.getModel().getProject().getInstalled();
        for (IModule mdacModel : mdacModels) {
            if (!mdacModel.getName().equals("ModelComponent")) continue;
            return modelingSession.getMdacRegistry().getStartedMdac(mdacModel);
        }
        return null;
    }

    public File getModelComponentPath() {
        return this.modelComponentPath;
    }

    public void setModelComponentPath(File value) {
        this.modelComponentPath = value;
    }

    public void setRamcName(String name) {
        this.ramcName = name;
    }

    public Set<File> getExportedFiles() {
        return this.exportedFiles;
    }

    private void initExportedFiles() {
        this.exportedFiles = new HashSet();
        ObList taggedvalues = this.ramc.getTag();
        for (ITaggedValue taggedvalue : taggedvalues) {
            ITagType type = taggedvalue.getDefinition();
            if (type == null || !type.getName().equals("ModelComponentFiles")) continue;
            for (ITagParameter parameter : taggedvalue.getActual()) {
                this.exportedFiles.add(new File(parameter.getValue()));
            }
        }
    }

    private void initManifested() {
        this.manifestedElements = new ArrayList();
        ObList manifestations = this.ramc.getUtilized();
        IModelElement me = null;
        for (IManifestation manifestation : manifestations) {
            me = manifestation.getUtilizedElement();
            if (me instanceof INameSpace) {
                this.manifestedElements.add(new EditManifestedAdapter((IElement)me));
                continue;
            }
            if (me instanceof IDictionary) {
                this.manifestedElements.add(new EditManifestedAdapter((IElement)me));
                continue;
            }
            if (!(me instanceof IRequirementContainer)) continue;
            this.manifestedElements.add(new EditManifestedAdapter((IElement)me));
        }
    }

    public List<EditManifestedAdapter> getManifestedElements() {
        return this.manifestedElements;
    }

    public void addExportedFile(File file) {
        this.exportedFiles.add(file);
    }

    public void removeExportedFile(File file) {
        this.exportedFiles.remove(file);
    }

    public IArtifact getModelComponent() {
        return this.ramc;
    }
}

