/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.edition.gui;

import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.api.ui.dnd.LinuxDropTarget;
import com.modeliosoft.modelio.api.ui.dnd.ModelElementTransfer;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import com.modeliosoft.modelio.ramcs.edition.gui.EditDependenciesContentProvider;
import com.modeliosoft.modelio.ramcs.edition.gui.EditDependenciesDropListener;
import com.modeliosoft.modelio.ramcs.edition.gui.EditDependenciesLabelProvider;
import com.modeliosoft.modelio.ramcs.edition.gui.EditFilesContentProvider;
import com.modeliosoft.modelio.ramcs.edition.gui.EditFilesLabelProvider;
import com.modeliosoft.modelio.ramcs.edition.gui.EditManifestationsContentProvider;
import com.modeliosoft.modelio.ramcs.edition.gui.EditManifestationsDropListener;
import com.modeliosoft.modelio.ramcs.edition.gui.EditManifestationsLabelProvider;
import com.modeliosoft.modelio.ramcs.edition.gui.EditRamcController;
import com.modeliosoft.modelio.ramcs.edition.gui.EditRamcDataModel;
import com.modeliosoft.modelio.ramcs.plugin.Ramcs;
import com.modeliosoft.modelio.ramcs.ui.Messages;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.PluginTransfer;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class EditRamcDialog
extends ModelioDialog {
    protected Button createButton = null;
    protected Button cancelButton = null;
    protected EditRamcDataModel dataModel = null;
    private Label ramcPathLabel = null;
    protected Text ramcPathText = null;
    private Button ramcPathButton = null;
    private Image fileChooserImage = null;
    protected FileDialog ramcPathChooser = null;
    private Label ramcNameLabel = null;
    private Label ramcVersionLabel = null;
    private Label ramcDescriptionLabel = null;
    private Label ramcDependenciesLabel = null;
    protected Text ramcNameText = null;
    protected Text ramcVersionText = null;
    protected Text ramcDescriptionText = null;
    private TableViewer ramcDependenciesList = null;
    protected EditRamcController controller = null;
    private Label ramcManifestationsLabel = null;
    private TableViewer ramcManifestationsList = null;
    protected FileDialog filesChooser = null;
    protected Label ramcFilesLabel = null;
    protected TableViewer ramcFilesList = null;
    private Image dropAreaImage = null;
    protected Button addFilesButton = null;
    protected Button removeFilesButton = null;
    private Image deleteImage = null;

    public EditRamcDialog(Shell parentShell, EditRamcDataModel dataModel) {
        super(parentShell);
        this.dataModel = dataModel;
        this.setShellStyle(2160);
        this.dropAreaImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.ramcs", (String)"icons/droparea_21.png").createImage();
        this.deleteImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.ramcs", (String)"icons/delete_16.png").createImage();
        this.fileChooserImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.modelio.ramcs", (String)"icons/fileChooser_16.png").createImage();
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.createButton = this.createButton(parent, 0, Messages.getString((String)"EditRamcDialog.Modify"), true);
        this.cancelButton = this.createButton(parent, 1, Messages.getString((String)"EditRamcDialog.Cancel"), false);
    }

    public Control createContentArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(1808));
        area.setLayout((Layout)new GridLayout());
        TabFolder tabFolder = new TabFolder(area, 0);
        tabFolder.setLayoutData((Object)new GridData(1808));
        TabItem mainTab = new TabItem(tabFolder, 0);
        mainTab.setText(Messages.getString((String)"EditRamcDialog.MainTab"));
        TabItem filesTab = new TabItem(tabFolder, 0);
        filesTab.setText(Messages.getString((String)"EditRamcDialog.FilesTab"));
        Composite mainArea = new Composite((Composite)tabFolder, 0);
        mainTab.setControl((Control)mainArea);
        GridLayout mainAreaLayout = new GridLayout(3, false);
        mainArea.setLayout((Layout)mainAreaLayout);
        this.controller = new EditRamcController(this.dataModel, this);
        IArtifact modelComponent = this.dataModel.getModelComponent();
        boolean isModelComponentEditable = modelComponent.getElementStatus().isModifiable();
        this.createRamcNameField(mainArea, isModelComponentEditable);
        this.createRamcVersionField(mainArea, isModelComponentEditable);
        this.createRamcPathField(mainArea, isModelComponentEditable);
        this.createDescriptionField(mainArea, isModelComponentEditable);
        this.createManifestationsField(mainArea, isModelComponentEditable);
        this.createDependenciesField(mainArea, isModelComponentEditable);
        Composite filesArea = new Composite((Composite)tabFolder, 0);
        filesTab.setControl((Control)filesArea);
        GridLayout filesAreaLayout = new GridLayout(3, false);
        filesArea.setLayout((Layout)filesAreaLayout);
        filesArea.setLayoutData((Object)new GridData(1808));
        this.createFilesField(filesArea, isModelComponentEditable);
        this.refresh();
        this.addListener(this.controller);
        return area;
    }

    private void createRamcPathField(Composite area, boolean isModelComponentEditable) {
        this.ramcPathLabel = new Label(area, 0);
        this.ramcPathLabel.setText(Messages.getString((String)"EditRamcDialog.ModelComponentPath"));
        this.ramcPathText = new Text(area, 2048);
        this.ramcPathText.setEditable(isModelComponentEditable);
        if (!isModelComponentEditable) {
            this.ramcPathText.setForeground(UIColor.EDITOR_ROTEXT_FG);
            this.ramcPathText.setBackground(UIColor.TEXT_READONLY_BG);
        }
        GridData gd_ramcPathLabel = new GridData(16384, 128, false, false, 1, 1);
        this.ramcPathLabel.setLayoutData((Object)gd_ramcPathLabel);
        GridData gd_ramcPathText = new GridData(4, 128, true, false, 1, 1);
        this.ramcPathText.setLayoutData((Object)gd_ramcPathText);
        if (isModelComponentEditable) {
            this.ramcPathButton = new Button(area, 0);
            this.ramcPathButton.setImage(this.fileChooserImage);
            this.ramcPathChooser = new FileDialog(this.getShell(), 4096);
            this.ramcPathChooser.setFilterExtensions(new String[]{"*.ramc"});
            this.ramcPathChooser.setFilterNames(new String[]{Messages.getString((String)"EditRamcDialog.RamcFiles")});
            this.ramcPathButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            GridData gd_ramcPathButton = new GridData(16384, 128, false, false, 1, 1);
            gd_ramcPathButton.heightHint = 21;
            gd_ramcPathButton.widthHint = 21;
            this.ramcPathButton.setLayoutData((Object)gd_ramcPathButton);
        } else {
            Composite emptyComposite = new Composite(area, 0);
            GridData gd_emptyComposite = new GridData(16384, 128, false, false, 1, 1);
            gd_emptyComposite.heightHint = 21;
            gd_emptyComposite.widthHint = 21;
            emptyComposite.setLayoutData((Object)gd_emptyComposite);
        }
    }

    public void init() {
        this.setLogoImage(null);
        IArtifact modelComponent = this.dataModel.getModelComponent();
        boolean isModelComponentEditable = modelComponent.getElementStatus().isModifiable();
        if (isModelComponentEditable) {
            this.getShell().setText(Messages.getString((String)"EditRamcDialog.EditRamcDialogTitle"));
            this.setTitle(Messages.getString((String)"EditRamcDialog.EditRamcDialogTitle"));
            this.setMessage(Messages.getString((String)"EditRamcDialog.EditRamcMessage"));
        } else {
            this.getShell().setText(Messages.getString((String)"EditRamcDialog.ViewRamcDialogTitle"));
            this.setTitle(Messages.getString((String)"EditRamcDialog.ViewRamcDialogTitle"));
            this.setMessage(Messages.getString((String)"EditRamcDialog.ViewRamcMessage"));
        }
        Point parentLocation = this.getShell().getParent().getLocation();
        this.getShell().setLocation(parentLocation.x + 300, parentLocation.y + 200);
        this.getShell().setSize(500, 600);
        this.getShell().setMinimumSize(500, 550);
        this.updateButtons(this.controller.validateData());
    }

    public boolean close() {
        this.removeListener(this.controller);
        if (this.fileChooserImage != null) {
            this.fileChooserImage.dispose();
            this.fileChooserImage = null;
        }
        if (this.dropAreaImage != null) {
            this.dropAreaImage.dispose();
            this.dropAreaImage = null;
        }
        if (this.deleteImage != null) {
            this.deleteImage.dispose();
            this.deleteImage = null;
        }
        return super.close();
    }

    private void createDependenciesField(Composite area, boolean isModelComponentEditable) {
        this.ramcDependenciesLabel = new Label(area, 0);
        this.ramcDependenciesLabel.setText(Messages.getString((String)"EditRamcDialog.RamcDependencies"));
        this.initDependenciesListViewer(area, isModelComponentEditable);
        Label targetLabel = new Label(area, 0);
        targetLabel.setImage(this.dropAreaImage);
        GridData gd_ramcDependenciesLabel = new GridData(16384, 128, false, false, 1, 1);
        this.ramcDependenciesLabel.setLayoutData((Object)gd_ramcDependenciesLabel);
        GridData gd_targetLabel = new GridData(16384, 128, false, false, 1, 1);
        gd_targetLabel.heightHint = 21;
        gd_targetLabel.widthHint = 21;
        targetLabel.setLayoutData((Object)gd_targetLabel);
    }

    private void createDescriptionField(Composite area, boolean isModelComponentEditable) {
        this.ramcDescriptionLabel = new Label(area, 0);
        this.ramcDescriptionLabel.setText(Messages.getString((String)"EditRamcDialog.RamcDescription"));
        this.ramcDescriptionText = new Text(area, 2818);
        this.ramcDescriptionText.setEditable(isModelComponentEditable);
        if (!isModelComponentEditable) {
            this.ramcDescriptionText.setForeground(UIColor.EDITOR_ROTEXT_FG);
            this.ramcDescriptionText.setBackground(UIColor.TEXT_READONLY_BG);
        }
        Composite emptyComposite = new Composite(area, 0);
        GridData gd_ramcDescriptionLabel = new GridData(16384, 128, false, false);
        this.ramcDescriptionLabel.setLayoutData((Object)gd_ramcDescriptionLabel);
        GridData gd_ramcDescriptionText = new GridData(4, 4, true, true);
        this.ramcDescriptionText.setLayoutData((Object)gd_ramcDescriptionText);
        GridData gd_emptyComposite = new GridData(16384, 128, false, false, 1, 1);
        gd_emptyComposite.heightHint = 21;
        gd_emptyComposite.widthHint = 21;
        emptyComposite.setLayoutData((Object)gd_emptyComposite);
    }

    private void createRamcVersionField(Composite area, boolean isModelComponentEditable) {
        this.ramcVersionLabel = new Label(area, 0);
        this.ramcVersionLabel.setText(Messages.getString((String)"EditRamcDialog.RamcVersion"));
        this.ramcVersionText = new Text(area, 2048);
        this.ramcVersionText.setEditable(isModelComponentEditable);
        if (!isModelComponentEditable) {
            this.ramcVersionText.setForeground(UIColor.EDITOR_ROTEXT_FG);
            this.ramcVersionText.setBackground(UIColor.TEXT_READONLY_BG);
        }
        Composite emptyComposite = new Composite(area, 0);
        GridData gd_ramcVersionLabel = new GridData(16384, 128, false, false, 1, 1);
        this.ramcVersionLabel.setLayoutData((Object)gd_ramcVersionLabel);
        GridData gd_ramcVersionText = new GridData(4, 128, true, false, 1, 1);
        this.ramcVersionText.setLayoutData((Object)gd_ramcVersionText);
        GridData gd_emptyComposite = new GridData(16384, 128, false, false, 1, 1);
        gd_emptyComposite.heightHint = 21;
        gd_emptyComposite.widthHint = 21;
        emptyComposite.setLayoutData((Object)gd_emptyComposite);
    }

    private void createRamcNameField(Composite area, boolean isModelComponentEditable) {
        this.ramcNameLabel = new Label(area, 0);
        this.ramcNameLabel.setText(Messages.getString((String)"EditRamcDialog.RamcName"));
        this.ramcNameText = new Text(area, 2048);
        this.ramcNameText.setEditable(isModelComponentEditable);
        if (!isModelComponentEditable) {
            this.ramcNameText.setForeground(UIColor.EDITOR_ROTEXT_FG);
            this.ramcNameText.setBackground(UIColor.TEXT_READONLY_BG);
        }
        Composite emptyComposite = new Composite(area, 0);
        GridData gd_ramcNameLabel = new GridData(16384, 128, false, false, 1, 1);
        this.ramcNameLabel.setLayoutData((Object)gd_ramcNameLabel);
        GridData gd_ramcNameText = new GridData(4, 128, true, false, 1, 1);
        this.ramcNameText.setLayoutData((Object)gd_ramcNameText);
        GridData gd_emptyComposite = new GridData(16384, 128, false, false, 1, 1);
        gd_emptyComposite.heightHint = 21;
        gd_emptyComposite.widthHint = 21;
        emptyComposite.setLayoutData((Object)gd_emptyComposite);
    }

    private void addListener(EditRamcController listener) {
        IModelingSession modelingSession = Ramcs.getInstance().getModelingSession();
        modelingSession.getModel().addModelListener((IModelChangeListener)listener);
        this.ramcNameText.addModifyListener((ModifyListener)listener);
        this.ramcPathText.addModifyListener((ModifyListener)listener);
        this.ramcVersionText.addModifyListener((ModifyListener)listener);
        this.ramcDescriptionText.addModifyListener((ModifyListener)listener);
    }

    private void removeListener(EditRamcController listener) {
        this.ramcNameText.removeModifyListener((ModifyListener)listener);
        this.ramcPathText.removeModifyListener((ModifyListener)listener);
        this.ramcVersionText.removeModifyListener((ModifyListener)listener);
        this.ramcDescriptionText.removeModifyListener((ModifyListener)listener);
        IModelingSession modelingSession = Ramcs.getInstance().getModelingSession();
        modelingSession.getModel().removeModelListener((IModelChangeListener)listener);
    }

    public void refresh() {
        this.ramcNameText.setText(this.dataModel.getRamcName());
        Version ramcVersion = this.dataModel.getRamcVersion();
        if (ramcVersion == null) {
            this.ramcVersionText.setText("");
        } else {
            String buildVersion = String.format("%02d", ramcVersion.getBuildVersion());
            this.ramcVersionText.setText(String.valueOf(ramcVersion.getMajorVersion()) + "." + ramcVersion.getMinorVersion() + "." + buildVersion);
        }
        this.ramcPathText.setText(this.dataModel.getModelComponentPath().getPath());
        this.ramcDescriptionText.setText(this.dataModel.getRamcDescription());
        this.ramcDependenciesList.setInput((Object)this.dataModel.getParentRamcs());
        this.ramcManifestationsList.setInput((Object)this.dataModel.getManifestedElements());
        this.ramcFilesList.setInput((Object)this.dataModel.getExportedFiles());
    }

    private void initDependenciesListViewer(Composite area, boolean isModelComponentEditable) {
        this.ramcDependenciesList = new TableViewer(area, 2564);
        this.ramcDependenciesList.setContentProvider((IContentProvider)new EditDependenciesContentProvider());
        this.ramcDependenciesList.setLabelProvider((IBaseLabelProvider)new EditDependenciesLabelProvider());
        if (isModelComponentEditable) {
            int operations = 2;
            Transfer[] types = new Transfer[]{ModelElementTransfer.getInstance(), PluginTransfer.getInstance()};
            Object target = System.getProperty("os.name").equals("Linux") ? new LinuxDropTarget((Control)this.ramcDependenciesList.getTable(), operations) : new DropTarget((Control)this.ramcDependenciesList.getTable(), operations);
            target.setTransfer(types);
            EditDependenciesDropListener dropListener = new EditDependenciesDropListener(this, this.controller, this.dataModel.getModelComponent());
            target.addDropListener((DropTargetListener)dropListener);
            this.ramcDependenciesList.getTable().addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.ramcDependenciesList.getTable().setForeground(UIColor.EDITOR_ROTEXT_FG);
            this.ramcDependenciesList.getTable().setBackground(UIColor.TEXT_READONLY_BG);
        }
        GridData gd_ramcDependenciesList = new GridData(4, 4, true, false);
        gd_ramcDependenciesList.heightHint = 50;
        this.ramcDependenciesList.getTable().setLayoutData((Object)gd_ramcDependenciesList);
    }

    public Version getVersion() {
        return new Version(this.ramcVersionText.getText());
    }

    public String getDescription() {
        return this.ramcDescriptionText.getText();
    }

    public String getRamcPath() {
        return this.ramcPathText.getText();
    }

    public void invalidateRamcVersion(boolean invalid) {
        IArtifact modelComponent = this.dataModel.getModelComponent();
        boolean isModelComponentEditable = modelComponent.getElementStatus().isModifiable();
        if (isModelComponentEditable) {
            if (invalid) {
                this.ramcVersionText.setForeground(this.ramcVersionText.getDisplay().getSystemColor(3));
            } else {
                this.ramcVersionText.setForeground(this.ramcVersionText.getDisplay().getSystemColor(6));
            }
        } else {
            this.ramcVersionText.setForeground(UIColor.EDITOR_ROTEXT_FG);
        }
    }

    public void updateButtons(boolean canPackage) {
        if (this.createButton != null) {
            this.createButton.setEnabled(canPackage);
        }
    }

    public void invalidateRamcPath(boolean invalid) {
        IArtifact modelComponent = this.dataModel.getModelComponent();
        boolean isModelComponentEditable = modelComponent.getElementStatus().isModifiable();
        if (isModelComponentEditable) {
            if (invalid) {
                this.ramcPathText.setForeground(this.ramcPathText.getDisplay().getSystemColor(3));
            } else {
                this.ramcPathText.setForeground(this.ramcPathText.getDisplay().getSystemColor(6));
            }
        } else {
            this.ramcPathText.setForeground(UIColor.EDITOR_ROTEXT_FG);
        }
    }

    public String getRamcName() {
        return this.ramcNameText.getText();
    }

    public void invalidateRamcName(boolean invalid) {
        IArtifact modelComponent = this.dataModel.getModelComponent();
        boolean isModelComponentEditable = modelComponent.getElementStatus().isModifiable();
        if (isModelComponentEditable) {
            if (invalid) {
                this.ramcNameText.setForeground(this.ramcNameText.getDisplay().getSystemColor(3));
            } else {
                this.ramcNameText.setForeground(this.ramcNameText.getDisplay().getSystemColor(6));
            }
        } else {
            this.ramcNameText.setForeground(UIColor.EDITOR_ROTEXT_FG);
        }
    }

    private void createManifestationsField(Composite area, boolean isModelComponentEditable) {
        this.ramcManifestationsLabel = new Label(area, 0);
        this.ramcManifestationsLabel.setText(Messages.getString((String)"EditRamcDialog.RamcManifestationLabel"));
        this.initManifestationsListViewer(area, isModelComponentEditable);
        Label targetLabel = new Label(area, 0);
        targetLabel.setImage(this.dropAreaImage);
        GridData gd_ramcManifestationsLabel = new GridData(16384, 128, false, false, 1, 1);
        this.ramcManifestationsLabel.setLayoutData((Object)gd_ramcManifestationsLabel);
        GridData gd_targetLabel = new GridData(16384, 128, false, false, 1, 1);
        gd_targetLabel.heightHint = 21;
        gd_targetLabel.widthHint = 21;
        targetLabel.setLayoutData((Object)gd_targetLabel);
    }

    private void initManifestationsListViewer(Composite area, boolean isModelComponentEditable) {
        this.ramcManifestationsList = new TableViewer(area, 2564);
        this.ramcManifestationsList.setContentProvider((IContentProvider)new EditManifestationsContentProvider());
        this.ramcManifestationsList.setLabelProvider((IBaseLabelProvider)new EditManifestationsLabelProvider());
        if (isModelComponentEditable) {
            int operations = 2;
            Transfer[] types = new Transfer[]{ModelElementTransfer.getInstance(), PluginTransfer.getInstance()};
            Object target = System.getProperty("os.name").equals("Linux") ? new LinuxDropTarget((Control)this.ramcManifestationsList.getTable(), operations) : new DropTarget((Control)this.ramcManifestationsList.getTable(), operations);
            target.setTransfer(types);
            EditManifestationsDropListener dropListener = new EditManifestationsDropListener(this, this.controller);
            target.addDropListener((DropTargetListener)dropListener);
            this.ramcManifestationsList.getTable().addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.ramcManifestationsList.getTable().setForeground(UIColor.EDITOR_ROTEXT_FG);
            this.ramcManifestationsList.getTable().setBackground(UIColor.TEXT_READONLY_BG);
        }
        GridData gd_ramcManifestationsList = new GridData(4, 4, true, false);
        gd_ramcManifestationsList.heightHint = 100;
        this.ramcManifestationsList.getTable().setLayoutData((Object)gd_ramcManifestationsList);
    }

    private void createFilesField(Composite area, boolean isModelComponentEditable) {
        IModelingSession modelingSession = Ramcs.getInstance().getModelingSession();
        this.ramcFilesLabel = new Label(area, 0);
        this.ramcFilesLabel.setText(Messages.getString((String)"EditRamcDialog.RamcFilesLabel"));
        this.initFilesListViewer(area, isModelComponentEditable);
        Composite buttonComposite = new Composite(area, 0);
        GridLayout l_buttonComposite = new GridLayout(1, false);
        l_buttonComposite.horizontalSpacing = 0;
        l_buttonComposite.marginWidth = 0;
        buttonComposite.setLayout((Layout)l_buttonComposite);
        GridData gd_buttonComposite = new GridData(16384, 4, false, true, 1, 1);
        gd_buttonComposite.widthHint = 21;
        buttonComposite.setLayoutData((Object)gd_buttonComposite);
        if (isModelComponentEditable) {
            this.addFilesButton = new Button(buttonComposite, 0);
            this.addFilesButton.setImage(this.fileChooserImage);
            this.removeFilesButton = new Button(buttonComposite, 0);
            this.removeFilesButton.setImage(this.deleteImage);
            this.filesChooser = new FileDialog(this.getShell(), 4098);
            String projectPath = modelingSession.getProjectSpacePath().getPath();
            this.filesChooser.setFilterPath(projectPath);
            this.addFilesButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
            this.removeFilesButton.addSelectionListener((SelectionListener)new /* Unavailable Anonymous Inner Class!! */);
        }
        GridData gd_ramcFilesLabel = new GridData(16384, 128, false, false, 1, 1);
        this.ramcFilesLabel.setLayoutData((Object)gd_ramcFilesLabel);
        if (isModelComponentEditable) {
            GridData gd_addFilesButton = new GridData(16384, 128, false, false, 1, 1);
            gd_addFilesButton.heightHint = 21;
            gd_addFilesButton.widthHint = 21;
            this.addFilesButton.setLayoutData((Object)gd_addFilesButton);
            GridData gd_removeFilesButton = new GridData(16384, 128, false, false, 1, 1);
            gd_removeFilesButton.horizontalSpan = 0;
            gd_removeFilesButton.heightHint = 21;
            gd_removeFilesButton.widthHint = 21;
            this.removeFilesButton.setLayoutData((Object)gd_removeFilesButton);
        }
        Composite emptyComposite1 = new Composite(area, 0);
        Label exportedFileDescription = new Label(area, 64);
        exportedFileDescription.setText(Messages.getString((String)"EditRamcDialog.ExportedFileDescription"));
        exportedFileDescription.setForeground(UIColor.LABEL_TIP_FG);
        Composite emptyComposite2 = new Composite(area, 0);
        GridData gd_emptyComposite1 = new GridData(16384, 128, false, false, 1, 1);
        gd_emptyComposite1.heightHint = 21;
        gd_emptyComposite1.widthHint = 21;
        emptyComposite1.setLayoutData((Object)gd_emptyComposite1);
        GridData gd_exportedFileDescription = new GridData(4, 128, true, false, 1, 1);
        gd_exportedFileDescription.heightHint = 40;
        exportedFileDescription.setLayoutData((Object)gd_exportedFileDescription);
        GridData gd_emptyComposite2 = new GridData(16384, 128, false, false, 1, 1);
        gd_emptyComposite2.heightHint = 21;
        gd_emptyComposite2.widthHint = 21;
        emptyComposite2.setLayoutData((Object)gd_emptyComposite2);
    }

    private void initFilesListViewer(Composite area, boolean isModelComponentEditable) {
        this.ramcFilesList = new TableViewer(area, 2562);
        this.ramcFilesList.setContentProvider((IContentProvider)new EditFilesContentProvider());
        this.ramcFilesList.setLabelProvider((IBaseLabelProvider)new EditFilesLabelProvider());
        if (isModelComponentEditable) {
            this.ramcFilesList.getTable().addKeyListener((KeyListener)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.ramcFilesList.getTable().setForeground(UIColor.EDITOR_ROTEXT_FG);
            this.ramcFilesList.getTable().setBackground(UIColor.TEXT_READONLY_BG);
        }
        GridData gd_ramcFilesList = new GridData(4, 4, true, true);
        this.ramcFilesList.getTable().setLayoutData((Object)gd_ramcFilesList);
    }

    public boolean close(int code) {
        this.setReturnCode(code);
        return this.close();
    }

    protected String getHelpId() {
        return "/com.modeliosoft.modelio.documentation.modeler/html/Model_components_development.html";
    }
}

