/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.packager;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.api.modelio.Modelio;
import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.api.module.IPeerMdac;
import com.modeliosoft.modelio.api.utils.NoteTypeNotFoundException;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.TagTypeNotFoundException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.ramcs.packager.MdacMCContributor;
import com.modeliosoft.modelio.ramcs.packager.PackageRamcCommand;
import com.modeliosoft.modelio.ramcs.packager.gui.PackageRamcDataModel;
import com.modeliosoft.modelio.ramcs.packager.gui.PackageRamcDialog;
import com.modeliosoft.modelio.ramcs.plugin.Ramcs;
import com.modeliosoft.modelio.ramcs.ui.Messages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class PackageRamcCommand {
    public Object execute(IArtifact ramc) {
        PackageRamcDataModel dataModel;
        if (ramc != null && (dataModel = this.promptUser(ramc)) != null) {
            this.updateModel(ramc, dataModel);
            this.packageRamc(ramc, dataModel);
        }
        return null;
    }

    public boolean accept(ObList<IElement> selectedElements) {
        IElement element;
        if (selectedElements.size() == 1 && (element = (IElement)selectedElements.get(0)) instanceof IArtifact) {
            IArtifact ramc = (IArtifact)element;
            IElementStatus status = ramc.getElementStatus();
            if (ramc.isStereotyped("ModelComponentArchive") && !status.isRamcObject()) {
                return true;
            }
        }
        return false;
    }

    public boolean isEnabled(ObList<IElement> selectedElements) {
        return true;
    }

    private PackageRamcDataModel promptUser(IArtifact ramc) {
        PackageRamcDataModel dataModel;
        Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        PackageRamcDialog dialog = new PackageRamcDialog(parentShell, dataModel = new PackageRamcDataModel(ramc));
        int code = dialog.open();
        if (code == 0) {
            return dataModel;
        }
        return null;
    }

    private void updateModel(IArtifact ramc, PackageRamcDataModel dataModel) {
        boolean updateDescription;
        IModelingSession modelingSession = Ramcs.getInstance().getModelingSession();
        IElementStatus ramcStatus = ramc.getElementStatus();
        boolean updateFileName = !dataModel.getModelComponentFile().equals(new File(ramc.getFileName())) && ramcStatus.isModifiable();
        boolean updateVersion = !dataModel.getRamcVersion().equals((Object)this.getVersion(ramc)) && ramcStatus.isModifiable();
        boolean bl = updateDescription = !dataModel.getRamcDescription().equals(this.getDescription(ramc)) && ramcStatus.isModifiable();
        if (updateFileName || updateVersion || updateDescription) {
            ITransactionManager transactionManager = modelingSession.getTransactionManager();
            ITransaction transaction = transactionManager.createTransaction("Update model component");
            try {
                try {
                    if (updateFileName) {
                        ramc.setFileName(dataModel.getModelComponentFile().getPath());
                    }
                    if (updateVersion) {
                        this.updateVersion(ramc, dataModel.getRamcVersion(), modelingSession);
                    }
                    if (updateDescription) {
                        this.updateDescription(ramc, dataModel.getRamcDescription(), modelingSession);
                    }
                    transactionManager.commit(transaction);
                    transaction = null;
                }
                catch (InvalidTransactionException e) {
                    transaction = null;
                    if (transaction != null) {
                        transactionManager.rollback(transaction);
                    }
                }
            }
            finally {
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
            }
        }
    }

    private void packageRamc(IArtifact ramc, PackageRamcDataModel dataModel) {
        List contributors = dataModel.getCheckedContributors();
        HashSet<IPeerMdac> peerMdacs = new HashSet<IPeerMdac>();
        for (MdacMCContributor contributor : contributors) {
            peerMdacs.add(contributor.getMdac().getPeerMdac());
        }
        File ramcFile = dataModel.getModelComponentFile();
        if (!ramcFile.isAbsolute()) {
            ramcFile = new File(Modelio.getInstance().getContext().getWorkspacePath(), ramcFile.getPath());
        }
        if (ramcFile.exists()) {
            Shell parentShell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            boolean confirmOverwrite = MessageDialog.openConfirm((Shell)parentShell, (String)Messages.getString((String)"PackageRamcDialog.RamcFileAlreadyExistsTitle"), (String)Messages.getMessage((String)"PackageRamcDialog.RamcFileAlreadyExistsMessage", (String[])new String[]{ramcFile.getPath()}));
            if (confirmOverwrite) {
                ramcFile.delete();
            } else {
                return;
            }
        }
        PackageRamcWithProgress packageLauncher = new PackageRamcWithProgress(this, ramc, peerMdacs, ramcFile);
        IProgressService service = PlatformUI.getWorkbench().getProgressService();
        try {
            service.run(true, false, (IRunnableWithProgress)packageLauncher);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void updateDescription(IArtifact ramc, String ramcDescription, IModelingSession modelingSession) {
        ObList notes = ramc.getDescriptor();
        INote descriptionNote = null;
        for (INote note : notes) {
            INoteType type = note.getModel();
            if (type == null || !type.getName().equals("description")) continue;
            descriptionNote = note;
        }
        if (descriptionNote == null) {
            IModelFactory factory = modelingSession.getModelFactory();
            try {
                factory.createNote("description", (IModelElement)ramc, ramcDescription);
            }
            catch (NoteTypeNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            descriptionNote.setContent(ramcDescription);
        }
    }

    private void updateVersion(IArtifact ramc, Version ramcVersion, IModelingSession modelingSession) {
        ObList taggedValues = ramc.getTag();
        String buildVersion = String.format("%02d", ramcVersion.getBuildVersion());
        String version = String.valueOf(ramcVersion.getMajorVersion()) + "." + ramcVersion.getMinorVersion() + "." + buildVersion;
        ITaggedValue versionTag = null;
        for (ITaggedValue taggedValue : taggedValues) {
            ITagType type = taggedValue.getDefinition();
            if (type == null || !type.getName().equals("ModelComponentVersion")) continue;
            versionTag = taggedValue;
        }
        if (versionTag == null) {
            IModelFactory factory = modelingSession.getModelFactory();
            try {
                versionTag = factory.createTaggedValue("ModelComponentVersion", (IModelElement)ramc);
                factory.createTagParameter(version, versionTag);
            }
            catch (TagTypeNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            ObList parameters = versionTag.getActual();
            if (parameters.size() > 0) {
                ((ITagParameter)parameters.get(0)).setValue(version);
            }
        }
    }

    private Version getVersion(IArtifact ramc) {
        ObList taggedValues = ramc.getTag();
        for (ITaggedValue taggedValue : taggedValues) {
            ObList parameters;
            ITagType type = taggedValue.getDefinition();
            if (type == null || !type.getName().equals("ModelComponentVersion") || (parameters = taggedValue.getActual()).size() != 1) continue;
            return new Version(((ITagParameter)parameters.get(0)).getValue());
        }
        return null;
    }

    private String getDescription(IArtifact ramc) {
        ObList notes = ramc.getDescriptor();
        for (INote note : notes) {
            INoteType type = note.getModel();
            if (type == null || !type.getName().equals("description")) continue;
            return note.getContent();
        }
        return "";
    }
}

