/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.packager;

import com.modeliosoft.modelio.api.mc.IModelComponentContent;
import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.api.model.uml.statik.IElementImport;
import com.modeliosoft.modelio.api.model.uml.statik.IManifestation;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.api.module.IPeerMdac;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.TagTypeNotFoundException;
import com.modeliosoft.modelio.bridges.mda.infra.RamcManagerBridge;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.jni.INativeModelingSession;
import com.modeliosoft.modelio.core.model.IMetamodelExtensions;
import com.modeliosoft.modelio.core.zip.Zipper;
import com.modeliosoft.modelio.ramcs.packager.MdacMCContributor;
import com.modeliosoft.modelio.ramcs.plugin.Ramcs;
import com.modeliosoft.modelio.ramcs.ui.Messages;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

public class RamcPackager {
    public void packageRamc(IArtifact ramc, Set<IPeerMdac> peerMdacs, File ramcFile, IProgressMonitor monitor) {
        block8: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(peerMdacs.size() + 4));
            File ramcDirectory = null;
            try {
                try {
                    IModelingSession modelingSession = Ramcs.getInstance().getModelingSession();
                    ramcDirectory = File.createTempFile("ramc", null);
                    ramcDirectory.delete();
                    ramcDirectory.mkdir();
                    List contributors = this.getContributors(peerMdacs);
                    HashSet noteTypes = new HashSet();
                    HashSet tagTypes = new HashSet();
                    HashSet dependencyStereotypes = new HashSet();
                    HashSet elements = new HashSet();
                    HashSet<String> files = new HashSet<String>();
                    this.initRamcContribution(modelingSession, ramc, elements, tagTypes, files);
                    subMonitor.worked(1);
                    for (MdacMCContributor contributor : contributors) {
                        subMonitor.subTask(Messages.getMessage((String)"PackageRamcDialog.AskForMdacContribution", (String[])new String[]{contributor.getMdac().getLabel()}));
                        IModelComponentContent content = contributor.getContributor().contribute(ramc);
                        noteTypes.addAll(content.getNoteTypes());
                        tagTypes.addAll(content.getTagTypes());
                        dependencyStereotypes.addAll(content.getDependencyStereotypes());
                        elements.addAll(content.getElements());
                        Set contentFiles = content.getFiles();
                        for (String string : contentFiles) {
                            String replacedString = string.replace('\\', '/');
                            files.add(replacedString);
                        }
                        subMonitor.worked(1);
                    }
                    subMonitor.subTask(Messages.getString((String)"PackageRamcDialog.ExportModel"));
                    RamcManagerBridge.externalizeRamc((INativeModelingSession)modelingSession.getNativeSession(), (IArtifact)ramc, (File)ramcDirectory, noteTypes, tagTypes, dependencyStereotypes, elements);
                    subMonitor.worked(1);
                    subMonitor.subTask(Messages.getString((String)"PackageRamcDialog.ExportFiles"));
                    BufferedWriter buffer = this.openMetadataStream(ramcDirectory);
                    this.writeMetadataHeader(ramc, buffer);
                    this.writeMetadataContributors(contributors, buffer);
                    this.writeMetadataDependencies(ramc, buffer);
                    this.addFiles(files, ramcDirectory, buffer);
                    this.writeMetadataFooter(buffer);
                    this.closeMetadataStream(buffer);
                    subMonitor.worked(1);
                    subMonitor.subTask(Messages.getMessage((String)"PackageRamcDialog.ArchiveModelComponent", (String[])new String[]{ramcFile.getPath()}));
                    ramcFile.getParentFile().mkdirs();
                    this.zipRamc(ramcDirectory, ramcFile, (IProgressMonitor)subMonitor);
                    subMonitor.worked(1);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    this.deleteDirectory(ramcDirectory);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                this.deleteDirectory(ramcDirectory);
                throw throwable;
            }
            this.deleteDirectory(ramcDirectory);
        }
    }

    private List<MdacMCContributor> getContributors(Set<IPeerMdac> peerMdacs) {
        ArrayList<MdacMCContributor> contributors = new ArrayList<MdacMCContributor>();
        for (IMdac mdac : Ramcs.getInstance().getModelingSession().getMdacRegistry().getStartedMdacs()) {
            if (!peerMdacs.contains(mdac.getPeerMdac()) || mdac.getModelComponentContributor() == null) continue;
            contributors.add(new MdacMCContributor(mdac, mdac.getModelComponentContributor()));
        }
        return contributors;
    }

    private void zipRamc(File ramcDirectory, File archive, IProgressMonitor monitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor);
        Zipper zipper = new Zipper(archive.getPath());
        zipper.compressContent(ramcDirectory.getPath(), (IProgressMonitor)subMonitor, "Zip archive");
    }

    private void addFiles(Set<String> files, File ramcDirectory, BufferedWriter buffer) throws IOException {
        int fileCpt = 0;
        File projectDirectory = Ramcs.getInstance().getModelingSession().getProjectSpacePath();
        String ramcFileName = null;
        for (String file : files) {
            File currentFile = new File(projectDirectory, file);
            ramcFileName = "File" + fileCpt;
            if (currentFile.isFile()) {
                this.copy(currentFile, new File(ramcDirectory, ramcFileName));
                buffer.append("    <file archive-name=\"");
                buffer.append(ramcFileName);
                buffer.append("\" destination-path=\"");
                buffer.append(file);
                buffer.append("\" mtime=\"");
                buffer.append(String.valueOf(currentFile.lastModified() / 1000L));
                buffer.append("\"/>\n");
            } else {
                System.err.println("RamcPackager - Invalid file path: " + currentFile.toString());
            }
            ++fileCpt;
        }
    }

    private File copy(File in, File out) throws IOException {
        FileChannel inChannel = null;
        FileChannel outChannel = null;
        if (!in.equals(out)) {
            inChannel = new FileInputStream(in).getChannel();
            outChannel = new FileOutputStream(out).getChannel();
            try {
                inChannel.transferTo(0L, inChannel.size(), outChannel);
            }
            finally {
                if (inChannel != null) {
                    inChannel.close();
                }
                if (outChannel != null) {
                    outChannel.close();
                }
            }
        }
        return out;
    }

    private void writeMetadataDependencies(IArtifact ramc, BufferedWriter buffer) throws IOException {
        buffer.append("    <dependencies>\n");
        Version parentVersion = null;
        String parentVersionStr = null;
        ObList elementImports = ramc.getOwnedImport();
        for (IElementImport elementImport : elementImports) {
            INameSpace importedNamespace = elementImport.getImportedElement();
            if (!(importedNamespace instanceof IArtifact) || !importedNamespace.isStereotyped("ModelComponentArchive")) continue;
            parentVersion = this.getVersion((IArtifact)importedNamespace);
            if (parentVersion == null) {
                parentVersion = new Version("0");
            }
            parentVersionStr = String.valueOf(parentVersion.getMajorVersion()) + "." + parentVersion.getMinorVersion() + "." + parentVersion.getBuildVersion();
            buffer.append("        <dependency name=\"" + importedNamespace.getName() + "\" version=\"" + parentVersionStr + "\" id=\"" + importedNamespace.getIdentifier() + "\"/>\n");
        }
        buffer.append("    </dependencies>\n");
    }

    private void writeMetadataHeader(IArtifact ramc, BufferedWriter buffer) throws IOException {
        Version ramcVersion = this.getVersion(ramc);
        String ramcDescription = this.getDescription(ramc);
        buffer.append("<?xml version=\"1.0\" encoding=\"iso-8859-1\"?>\n");
        buffer.append("<ram-component manifest-version=\"1.0\" name=\"" + ramc.getName() + "\" version=\"" + ramcVersion.getMajorVersion() + "\" release=\"" + ramcVersion.getMinorVersion() + "\"  clevel=\"" + ramcVersion.getBuildVersion() + "\">\n");
        buffer.append("    <description>\n");
        buffer.append("        <![CDATA[" + ramcDescription + "]" + "]>\n");
        buffer.append("    </description>\n");
    }

    private Version getVersion(IArtifact ramc) {
        ObList taggedValues = ramc.getTag();
        for (ITaggedValue taggedValue : taggedValues) {
            ObList parameters;
            ITagType type = taggedValue.getDefinition();
            if (type == null || !type.getName().equals("ModelComponentVersion") || (parameters = taggedValue.getActual()).size() != 1) continue;
            return new Version(((ITagParameter)parameters.get(0)).getValue());
        }
        return null;
    }

    private String getDescription(IArtifact ramc) {
        ObList notes = ramc.getDescriptor();
        for (INote note : notes) {
            INoteType type = note.getModel();
            if (type == null || !type.getName().equals("description")) continue;
            return note.getContent();
        }
        return "";
    }

    private void writeMetadataFooter(BufferedWriter buffer) throws IOException {
        buffer.append("</ram-component>");
    }

    private BufferedWriter openMetadataStream(File ramcDirectory) throws IOException {
        File metadataFile = new File(ramcDirectory, "metadatas.xml");
        FileWriter out = new FileWriter(metadataFile);
        BufferedWriter buffer = new BufferedWriter(out);
        return buffer;
    }

    private boolean deleteDirectory(File path) {
        boolean result = true;
        if (path.exists()) {
            File[] files = path.listFiles();
            int i = 0;
            while (i < files.length) {
                result = files[i].isDirectory() ? (result &= this.deleteDirectory(files[i])) : (result &= files[i].delete());
                ++i;
            }
        }
        return result &= path.delete();
    }

    private void writeMetadataContributors(List<MdacMCContributor> contributors, BufferedWriter buffer) throws IOException {
        buffer.append("    <contributors>\n");
        for (MdacMCContributor contributor : contributors) {
            IMdac mdac = contributor.getMdac();
            buffer.append("        <contributor name=\"" + mdac.getName() + "\" version=\"" + mdac.getVersion().toString() + "\"/>\n");
        }
        buffer.append("    </contributors>\n");
    }

    private void closeMetadataStream(BufferedWriter buffer) throws IOException {
        buffer.close();
    }

    private void initRamcContribution(IModelingSession modelingSession, IArtifact ramc, Set<IElement> elements, Set<ITagType> tagTypes, Set<String> files) {
        IMetamodelExtensions extensions = modelingSession.getModel().getMetamodelExtensions();
        ObList manifestations = ramc.getUtilized();
        for (IManifestation manifestation : manifestations) {
            elements.add((IElement)manifestation.getUtilizedElement());
        }
        try {
            tagTypes.add(extensions.getTagType(IArtifact.class, "ModelComponentVersion"));
        }
        catch (TagTypeNotFoundException e) {
            e.printStackTrace();
        }
        try {
            tagTypes.add(extensions.getTagType(IArtifact.class, "ModelComponentFiles"));
        }
        catch (TagTypeNotFoundException e) {
            e.printStackTrace();
        }
        ObList tags = ramc.getTag();
        for (ITaggedValue tag : tags) {
            if (!tag.getDefinition().getName().equals("ModelComponentFiles")) continue;
            for (ITagParameter parameter : tag.getActual()) {
                String replacedString = parameter.getValue().replace('\\', '/');
                files.add(replacedString);
            }
        }
    }
}

