/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.packager.gui;

import com.modeliosoft.modelio.ramcs.packager.gui.PackageRamcContributorAdapter;
import com.modeliosoft.modelio.ramcs.packager.gui.PackageRamcDataModel;
import com.modeliosoft.modelio.ramcs.packager.gui.PackageRamcDialog;
import java.io.File;
import java.io.IOException;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;

public class PackageRamcController
implements ModifyListener,
ICheckStateListener {
    private PackageRamcDataModel dataModel = null;
    private PackageRamcDialog dialog = null;

    public PackageRamcController(PackageRamcDataModel dataModel, PackageRamcDialog dialog) {
        this.dataModel = dataModel;
        this.dialog = dialog;
    }

    public void modifyText(ModifyEvent event) {
        boolean isValidRamcVersion = true;
        boolean isValidRamcPath = true;
        if (event.widget == this.dialog.ramcPathText) {
            isValidRamcPath = this.validateRamcPath();
            if (isValidRamcPath) {
                this.dataModel.setModelComponentFile(new File(this.dialog.getRamcPath()));
            }
            this.dialog.invalidateRamcPath(!isValidRamcPath);
        }
        if (event.widget == this.dialog.ramcVersionText) {
            isValidRamcVersion = this.validateRamcVersion();
            if (isValidRamcVersion) {
                this.dataModel.setRamcVersion(this.dialog.getVersion());
            }
            this.dialog.invalidateRamcVersion(!isValidRamcVersion);
        }
        this.dataModel.setRamcDescription(this.dialog.getDescription());
        this.dialog.updateButtons(isValidRamcVersion && isValidRamcPath);
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        PackageRamcContributorAdapter adapter = (PackageRamcContributorAdapter)event.getElement();
        adapter.setSelected(event.getChecked());
    }

    private boolean validateRamcVersion() {
        try {
            this.dialog.getVersion();
            return true;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private boolean validateRamcPath() {
        String ramcPath = this.dialog.getRamcPath();
        File ramcFile = new File(ramcPath);
        if (ramcPath == null || ramcPath.equals("")) {
            return false;
        }
        try {
            ramcFile.getCanonicalFile();
        }
        catch (IOException e) {
            return false;
        }
        return ramcPath.endsWith(".ramc");
    }

    public boolean validateData() {
        boolean isRamcVersionValid = this.validateRamcVersion();
        boolean isRamcPathValid = this.validateRamcPath();
        this.dialog.invalidateRamcVersion(!isRamcVersionValid);
        this.dialog.invalidateRamcPath(!isRamcPathValid);
        return isRamcVersionValid && isRamcPathValid;
    }
}

