/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.packager.gui;

import com.modeliosoft.modelio.api.mdac.IMdac;
import com.modeliosoft.modelio.api.model.extension.IModule;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.api.model.uml.statik.IElementImport;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.ramcs.packager.MdacMCContributor;
import com.modeliosoft.modelio.ramcs.packager.gui.PackageRamcAdapter;
import com.modeliosoft.modelio.ramcs.packager.gui.PackageRamcContributorAdapter;
import com.modeliosoft.modelio.ramcs.plugin.Ramcs;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PackageRamcDataModel {
    private String ramcName = "";
    private String ramcDescription = "";
    private Version ramcVersion;
    private List<PackageRamcContributorAdapter> contributors = null;
    private List<PackageRamcAdapter> parentRamcs = null;
    private File modelComponentPath = null;
    private IArtifact ramc;

    public PackageRamcDataModel(IArtifact ramc) {
        this.ramc = ramc;
        this.ramcName = ramc.getName();
        this.ramcVersion = this.getVersion();
        this.ramcDescription = this.getDescription();
        this.initRamcPath();
        this.initDependencies();
        this.initContributors();
    }

    private String getDescription() {
        ObList notes = this.ramc.getDescriptor();
        for (INote note : notes) {
            INoteType type = note.getModel();
            if (type == null || !type.getName().equals("description")) continue;
            return note.getContent();
        }
        return "";
    }

    private Version getVersion() {
        ObList taggedValues = this.ramc.getTag();
        for (ITaggedValue taggedValue : taggedValues) {
            ObList parameters;
            ITagType type = taggedValue.getDefinition();
            if (type == null || !type.getName().equals("ModelComponentVersion") || (parameters = taggedValue.getActual()).size() != 1) continue;
            return new Version(((ITagParameter)parameters.get(0)).getValue());
        }
        return new Version("");
    }

    private void initContributors() {
        this.contributors = new ArrayList();
        for (IMdac mdac : Ramcs.getInstance().getModelingSession().getMdacRegistry().getStartedMdacs()) {
            if (mdac.getModelComponentContributor() == null) continue;
            this.contributors.add(new PackageRamcContributorAdapter(new MdacMCContributor(mdac, mdac.getModelComponentContributor())));
        }
    }

    private void initDependencies() {
        this.parentRamcs = new ArrayList();
        ObList elementImports = this.ramc.getOwnedImport();
        for (IElementImport elementImport : elementImports) {
            INameSpace importedNamespace = elementImport.getImportedElement();
            if (!(importedNamespace instanceof IArtifact) || !importedNamespace.isStereotyped("ModelComponentArchive")) continue;
            IArtifact ramcArtifact = (IArtifact)importedNamespace;
            this.parentRamcs.add(new PackageRamcAdapter(ramcArtifact));
        }
    }

    public String getRamcName() {
        return this.ramcName;
    }

    public String getRamcDescription() {
        return this.ramcDescription;
    }

    public void setRamcDescription(String value) {
        this.ramcDescription = value;
    }

    public Version getRamcVersion() {
        return this.ramcVersion;
    }

    public void setRamcVersion(Version value) {
        this.ramcVersion = value;
    }

    public List<PackageRamcContributorAdapter> getContributors() {
        return this.contributors;
    }

    public List<PackageRamcAdapter> getParentRamcs() {
        return this.parentRamcs;
    }

    public Object[] getCheckedContributorsAdapters() {
        ArrayList<PackageRamcContributorAdapter> checkedContributors = new ArrayList<PackageRamcContributorAdapter>();
        for (PackageRamcContributorAdapter adapter : this.contributors) {
            if (!adapter.isSelected()) continue;
            checkedContributors.add(adapter);
        }
        return checkedContributors.toArray();
    }

    public List<MdacMCContributor> getCheckedContributors() {
        ArrayList<MdacMCContributor> checkedContributors = new ArrayList<MdacMCContributor>();
        for (PackageRamcContributorAdapter adapter : this.contributors) {
            if (!adapter.isSelected()) continue;
            checkedContributors.add(adapter.getContributor());
        }
        return checkedContributors;
    }

    private void initRamcPath() {
        this.modelComponentPath = new File(this.ramc.getFileName());
        if (this.modelComponentPath == null || this.modelComponentPath.getPath().equals("")) {
            this.modelComponentPath = this.getDefaultRamcPath();
        }
    }

    private File getDefaultRamcPath() {
        IModelingSession modelingSession = Ramcs.getInstance().getModelingSession();
        IMdac modelComponentMdac = this.getModelComponentMdac();
        if (modelComponentMdac != null) {
            String defaultRamcPath = modelComponentMdac.getConfiguration().getParameterValue("DefaultRamcDirectory");
            File defaultRamcDirectory = new File(defaultRamcPath);
            if (defaultRamcPath != null && !defaultRamcPath.equals("")) {
                try {
                    defaultRamcDirectory.getCanonicalFile();
                }
                catch (IOException e) {
                    defaultRamcDirectory = modelingSession.getWorkspacePath();
                }
            } else {
                defaultRamcDirectory = modelingSession.getWorkspacePath();
            }
            return new File(defaultRamcDirectory, String.valueOf(this.ramc.getName()) + ".ramc");
        }
        return new File(modelingSession.getWorkspacePath(), String.valueOf(this.ramc.getName()) + ".ramc");
    }

    private IMdac getModelComponentMdac() {
        IModelingSession modelingSession = Ramcs.getInstance().getModelingSession();
        ObList mdacModels = modelingSession.getModel().getProject().getInstalled();
        for (IModule mdacModel : mdacModels) {
            if (!mdacModel.getName().equals("ModelComponent")) continue;
            return modelingSession.getMdacRegistry().getStartedMdac(mdacModel);
        }
        return null;
    }

    public IArtifact getModelComponent() {
        return this.ramc;
    }

    public void setModelComponentFile(File file) {
        this.modelComponentPath = file;
    }

    public File getModelComponentFile() {
        return this.modelComponentPath;
    }
}

