/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.remove;

import com.modeliosoft.modelio.api.model.analyst.IAnalystProject;
import com.modeliosoft.modelio.api.model.analyst.IDictionary;
import com.modeliosoft.modelio.api.model.analyst.IDictionaryElement;
import com.modeliosoft.modelio.api.model.analyst.IPropertyContainer;
import com.modeliosoft.modelio.api.model.analyst.IRequirementContainer;
import com.modeliosoft.modelio.api.model.analyst.IRequirementElement;
import com.modeliosoft.modelio.api.model.extension.IProject;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IElementStatus;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IModelElement;
import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.api.model.uml.statik.IComponent;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.api.utils.exceptions.InvalidModelManipulationException;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.factory.IModelFactory;
import com.modeliosoft.modelio.core.jni.IAccessManager;
import com.modeliosoft.modelio.core.jni.ITransaction;
import com.modeliosoft.modelio.core.log.LOG;
import com.modeliosoft.modelio.core.model.CompositionServices;
import com.modeliosoft.modelio.core.transaction.ITransactionManager;
import com.modeliosoft.modelio.core.transaction.InvalidTransactionException;
import com.modeliosoft.modelio.ramcs.ui.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;

public class DeleteModelComponents
implements IRunnableWithProgress {
    private IModelingSession modelingSession = null;
    private List<IArtifact> modelComponentsToRemove = null;

    public DeleteModelComponents(IModelingSession modelingSession, List<IArtifact> modelComponentsToRemove) {
        this.modelingSession = modelingSession;
        this.modelComponentsToRemove = modelComponentsToRemove;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        block21: {
            String taskName = Messages.getString((String)"DeleteModelComponentDialog.DeleteModelComponents");
            monitor.beginTask(taskName, this.modelComponentsToRemove.size() * 10);
            ITransactionManager transactionManager = this.modelingSession.getTransactionManager();
            ITransaction transaction = transactionManager.createTransaction(taskName);
            try {
                try {
                    IPackage rootPackage = this.getRootPackage();
                    IRequirementContainer rootRequirement = this.getRootRequirement();
                    IRequirementContainer rootGoal = this.getRootGoal();
                    IRequirementContainer rootBusinessRule = this.getRootBusinessRule();
                    IDictionary rootDictionary = this.getRootDictionary();
                    IPropertyContainer rootProperties = this.getRootProperties();
                    IAccessManager accessManager = this.modelingSession.getAccessManager();
                    boolean mustRelockCMSRootPackage = this.unlockCMSIfNeeded(accessManager, (IModelElement)rootPackage);
                    boolean mustRelockCMSRootRequirement = this.unlockCMSIfNeeded(accessManager, (IModelElement)rootRequirement);
                    boolean mustRelockCMSRootProperties = this.unlockCMSIfNeeded(accessManager, (IModelElement)rootProperties);
                    boolean mustRelockCMSRootGoal = this.unlockCMSIfNeeded(accessManager, (IModelElement)rootGoal);
                    boolean mustRelockCMSRootBusinessRule = this.unlockCMSIfNeeded(accessManager, (IModelElement)rootBusinessRule);
                    boolean mustRelockCMSRootDictionary = this.unlockCMSIfNeeded(accessManager, (IModelElement)rootDictionary);
                    boolean mustRelockWriteRootReqRight = this.unlockWriteIfNeeded(accessManager, (IModelElement)rootRequirement);
                    boolean mustRelockWriteRootGoalRight = this.unlockWriteIfNeeded(accessManager, (IModelElement)rootGoal);
                    boolean mustRelockWriteRootBusinessRuleRight = this.unlockWriteIfNeeded(accessManager, (IModelElement)rootBusinessRule);
                    boolean mustRelockWriteRootDictionaryRight = this.unlockWriteIfNeeded(accessManager, (IModelElement)rootDictionary);
                    for (IArtifact modelComponent : this.modelComponentsToRemove) {
                        monitor.subTask(Messages.getMessage((String)"DeleteModelComponentDialog.DeleteModelComponent", (String[])new String[]{modelComponent.getName()}));
                        try {
                            this.deleteModelComponent(modelComponent, monitor);
                        }
                        catch (InvalidModelManipulationException e) {
                            this.handleException(modelComponent, e);
                        }
                    }
                    if (mustRelockWriteRootReqRight) {
                        accessManager.setUserWriteRight((IElement)rootRequirement, false);
                    }
                    if (mustRelockWriteRootGoalRight) {
                        accessManager.setUserWriteRight((IElement)rootGoal, false);
                    }
                    if (mustRelockWriteRootBusinessRuleRight) {
                        accessManager.setUserWriteRight((IElement)rootBusinessRule, false);
                    }
                    if (mustRelockWriteRootDictionaryRight) {
                        accessManager.setUserWriteRight((IElement)rootDictionary, false);
                    }
                    if (mustRelockCMSRootPackage) {
                        accessManager.setCmsLocked((IElement)rootPackage, true);
                    }
                    if (mustRelockCMSRootRequirement) {
                        accessManager.setCmsLocked((IElement)rootRequirement, true);
                    }
                    if (mustRelockCMSRootProperties) {
                        accessManager.setCmsLocked((IElement)rootProperties, true);
                    }
                    if (mustRelockCMSRootGoal) {
                        accessManager.setCmsLocked((IElement)rootGoal, true);
                    }
                    if (mustRelockCMSRootBusinessRule) {
                        accessManager.setCmsLocked((IElement)rootBusinessRule, true);
                    }
                    if (mustRelockCMSRootDictionary) {
                        accessManager.setCmsLocked((IElement)rootDictionary, true);
                    }
                    transactionManager.commit(transaction);
                    transaction = null;
                }
                catch (InvalidTransactionException e) {
                    LOG.error((String)"org.modelio.ramcs", (Throwable)e);
                    transaction = null;
                    if (transaction != null) {
                        transactionManager.rollback(transaction);
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (transaction != null) {
                    transactionManager.rollback(transaction);
                }
                throw throwable;
            }
            if (transaction != null) {
                transactionManager.rollback(transaction);
            }
        }
        monitor.done();
    }

    private void deleteModelComponent(IArtifact artifactComponent, IProgressMonitor monitor) {
        IModelTree componentOwner;
        IModelFactory factory = this.modelingSession.getModelFactory();
        IRequirementContainer rootRequirement = this.getRootRequirement();
        IRequirementContainer rootGoal = this.getRootGoal();
        IRequirementContainer rootBusinessRule = this.getRootBusinessRule();
        IDictionary rootDictionary = this.getRootDictionary();
        IRequirementContainer rootRequirementToDelete = this.getElementToDelete(rootRequirement, artifactComponent.getName());
        IRequirementContainer rootGoalToDelete = this.getElementToDelete(rootGoal, artifactComponent.getName());
        IRequirementContainer rootBusinessRuleToDelete = this.getElementToDelete(rootBusinessRule, artifactComponent.getName());
        IDictionary rootDictionaryToDelete = this.getElementToDelete(rootDictionary, artifactComponent.getName());
        IModelTree artifactOwner = artifactComponent.getOwner();
        IComponent modelComponent = null;
        if (artifactOwner instanceof IComponent && !(modelComponent = (IComponent)artifactOwner).isStereotyped("ModelComponent") && (componentOwner = modelComponent.getOwner()) instanceof IComponent) {
            modelComponent = (IComponent)componentOwner;
        }
        if (modelComponent != null && modelComponent.isStereotyped("ModelComponent")) {
            this.setRights((IModelElement)modelComponent);
            monitor.worked(1);
            factory.deleteElement((IElement)modelComponent);
            monitor.worked(1);
        } else {
            monitor.worked(2);
        }
        if (rootRequirementToDelete != null) {
            this.setRights((IModelElement)rootRequirementToDelete);
            monitor.worked(1);
            factory.deleteElement((IElement)rootRequirementToDelete);
            monitor.worked(1);
        } else {
            monitor.worked(2);
        }
        if (rootGoalToDelete != null) {
            this.setRights((IModelElement)rootGoalToDelete);
            monitor.worked(1);
            factory.deleteElement((IElement)rootGoalToDelete);
            monitor.worked(1);
        } else {
            monitor.worked(2);
        }
        if (rootBusinessRuleToDelete != null) {
            this.setRights((IModelElement)rootBusinessRuleToDelete);
            monitor.worked(1);
            factory.deleteElement((IElement)rootBusinessRuleToDelete);
            monitor.worked(1);
        } else {
            monitor.worked(2);
        }
        if (rootDictionaryToDelete != null) {
            this.setRights((IModelElement)rootDictionaryToDelete);
            monitor.worked(1);
            factory.deleteElement((IElement)rootDictionaryToDelete);
            monitor.worked(1);
        } else {
            monitor.worked(2);
        }
    }

    private IAnalystProject getAnalystProject() {
        IProject project = this.modelingSession.getModel().getProject();
        IAnalystProject reqProject = project.getRootRequirement();
        return reqProject;
    }

    private IDictionary getElementToDelete(IDictionary root, String name) {
        if (root != null) {
            ObList containersList = root.getOwned();
            for (IDictionaryElement container : containersList) {
                if (!container.getName().equals(name) || !(container instanceof IDictionary)) continue;
                return (IDictionary)container;
            }
        }
        return null;
    }

    private IRequirementContainer getElementToDelete(IRequirementContainer root, String name) {
        if (root != null) {
            ObList containersList = root.getOwned();
            for (IRequirementElement container : containersList) {
                if (!container.getName().equals(name) || !(container instanceof IRequirementContainer)) continue;
                return (IRequirementContainer)container;
            }
        }
        return null;
    }

    private IRequirementContainer getRootBusinessRule() {
        IAnalystProject reqProject = this.getAnalystProject();
        if (reqProject != null) {
            return reqProject.getBusinessRuleRoot();
        }
        return null;
    }

    private IDictionary getRootDictionary() {
        IAnalystProject reqProject = this.getAnalystProject();
        if (reqProject != null) {
            return reqProject.getDictionaryRoot();
        }
        return null;
    }

    private IRequirementContainer getRootGoal() {
        IAnalystProject reqProject = this.getAnalystProject();
        if (reqProject != null) {
            return reqProject.getGoalRoot();
        }
        return null;
    }

    private IPackage getRootPackage() {
        return this.modelingSession.getModel().getProject().getModel();
    }

    private IPropertyContainer getRootProperties() {
        IAnalystProject reqProject = this.getAnalystProject();
        if (reqProject != null) {
            return reqProject.getProperties();
        }
        return null;
    }

    private IRequirementContainer getRootRequirement() {
        IAnalystProject reqProject = this.getAnalystProject();
        if (reqProject != null) {
            return reqProject.getRequirementRoot();
        }
        return null;
    }

    private void handleException(IArtifact modelComponent, InvalidModelManipulationException error) throws InvocationTargetException {
        Display.getDefault().syncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        throw new InvocationTargetException(error);
    }

    private void setRamcObject(IElement element, boolean value) {
        IAccessManager accessManager = this.modelingSession.getAccessManager();
        accessManager.setRamcObject(element, value);
    }

    private void setRights(IModelElement modelComponent) {
        IAccessManager accessManager = this.modelingSession.getAccessManager();
        accessManager.setRamcObject((IElement)modelComponent, false);
        accessManager.setUserWriteRight((IElement)modelComponent, true);
        List children = CompositionServices.getAllCompositionChildren((IElement)modelComponent);
        for (IElement child : children) {
            this.setRamcObject(child, false);
            accessManager.setUserWriteRight(child, true);
        }
    }

    private boolean unlockCMSIfNeeded(IAccessManager accessManager, IModelElement element) {
        IElementStatus status;
        if (element != null && (status = element.getElementStatus()).isCmsLocked()) {
            accessManager.setCmsLocked((IElement)element, false);
            return true;
        }
        return false;
    }

    private boolean unlockWriteIfNeeded(IAccessManager accessManager, IModelElement element) {
        IElementStatus status;
        if (element != null && !(status = element.getElementStatus()).hasUserWriteRight()) {
            accessManager.setUserWriteRight((IElement)element, true);
            return true;
        }
        return false;
    }
}

