/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.remove;

import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.ramcs.plugin.Ramcs;
import com.modeliosoft.modelio.ramcs.remove.DeleteModelComponents;
import com.modeliosoft.modelio.ramcs.remove.gui.DeleteModelComponentDialog;
import com.modeliosoft.modelio.ramcs.ui.Messages;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public class RemoveRamcCommand {
    public Object execute(ExecutionEvent event) {
        IModelingSession modelingSession = Ramcs.getInstance().getModelingSession();
        if (modelingSession != null) {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            DeleteModelComponentDialog dialog = new DeleteModelComponentDialog(shell, modelingSession);
            dialog.setBlockOnOpen(true);
            int code = dialog.open();
            List modelComponentsToRemove = dialog.getModelComponentsToRemove();
            if (code == 0 && modelComponentsToRemove.size() > 0) {
                String[] buttonLabels = new String[]{Messages.getString((String)"DeleteModelComponentDialog.ConfirmModelComponentDeletionOk"), Messages.getString((String)"DeleteModelComponentDialog.ConfirmModelComponentDeletionCancel")};
                MessageDialog confirmDialog = new MessageDialog(shell, Messages.getString((String)"DeleteModelComponentDialog.ConfirmModelComponentDeletionTitle"), shell.getImage(), Messages.getString((String)"DeleteModelComponentDialog.ConfirmModelComponentDeletionMessage"), 4, buttonLabels, 1);
                if (confirmDialog.open() == 0) {
                    IProgressService service = PlatformUI.getWorkbench().getProgressService();
                    try {
                        DeleteModelComponents deleteModelComponents = new DeleteModelComponents(modelingSession, modelComponentsToRemove);
                        service.run(true, false, (IRunnableWithProgress)deleteModelComponents);
                    }
                    catch (InvocationTargetException e) {
                        e.printStackTrace();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }
}

