/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.remove.gui;

import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INoteType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagParameter;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITagType;
import com.modeliosoft.modelio.api.model.uml.infrastructure.ITaggedValue;
import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.api.model.uml.statik.IElementImport;
import com.modeliosoft.modelio.api.model.uml.statik.INameSpace;
import com.modeliosoft.modelio.api.modelio.Version;
import com.modeliosoft.modelio.api.utils.ObList;
import java.util.ArrayList;
import java.util.List;

public class DeleteModelComponentAdapter
implements Comparable<DeleteModelComponentAdapter> {
    private String modelComponentName = "";
    private String modelComponentDescription = "";
    private IArtifact modelComponent = null;
    private Version modelComponentVersion = null;
    private boolean toDelete = false;

    public DeleteModelComponentAdapter(IArtifact modelComponent) {
        this.modelComponent = modelComponent;
        this.modelComponentName = modelComponent.getName();
        this.modelComponentVersion = this.getVersion();
        this.modelComponentDescription = this.getDescription();
    }

    private String getDescription() {
        ObList notes = this.modelComponent.getDescriptor();
        for (INote note : notes) {
            INoteType type = note.getModel();
            if (type == null || !type.getName().equals("description")) continue;
            return note.getContent();
        }
        return "";
    }

    private Version getVersion() {
        ObList taggedValues = this.modelComponent.getTag();
        for (ITaggedValue taggedValue : taggedValues) {
            ObList parameters;
            ITagType type = taggedValue.getDefinition();
            if (type == null || !type.getName().equals("ModelComponentVersion") || (parameters = taggedValue.getActual()).size() != 1) continue;
            return new Version(((ITagParameter)parameters.get(0)).getValue());
        }
        return null;
    }

    public String getModelComponentName() {
        return this.modelComponentName;
    }

    public String getModelComponentDescription() {
        return this.modelComponentDescription;
    }

    public Version getModelComponentVersion() {
        return this.modelComponentVersion;
    }

    public IArtifact getModelComponent() {
        return this.modelComponent;
    }

    public boolean isToDelete() {
        return this.toDelete;
    }

    public void setToDelete(boolean toDelete) {
        this.toDelete = toDelete;
    }

    @Override
    public int compareTo(DeleteModelComponentAdapter o) {
        IArtifact otherModelComponent = o.getModelComponent();
        List requiredArtifact = this.getAllRequiredModelComponents(otherModelComponent);
        if (requiredArtifact.contains(this.modelComponent)) {
            return 1;
        }
        return 0;
    }

    public List<IArtifact> getRequiredModelComponents(IArtifact theModelComponent) {
        ArrayList<IArtifact> requiredArtifacts = new ArrayList<IArtifact>();
        ObList elementImports = theModelComponent.getOwnedImport();
        for (IElementImport elementImport : elementImports) {
            INameSpace ns = elementImport.getImportedElement();
            if (!(ns instanceof IArtifact) || !ns.isStereotyped("ModelComponentArchive")) continue;
            requiredArtifacts.add((IArtifact)ns);
        }
        return requiredArtifacts;
    }

    public List<IArtifact> getAllRequiredModelComponents(IArtifact theModelComponent) {
        ArrayList<IArtifact> requiredArtifacts = new ArrayList<IArtifact>();
        ObList elementImports = theModelComponent.getOwnedImport();
        for (IElementImport elementImport : elementImports) {
            INameSpace ns = elementImport.getImportedElement();
            if (!(ns instanceof IArtifact) || !ns.isStereotyped("ModelComponentArchive")) continue;
            requiredArtifacts.add((IArtifact)ns);
            requiredArtifacts.addAll(this.getRequiredModelComponents((IArtifact)ns));
        }
        return requiredArtifacts;
    }
}

