/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.ramcs.remove.gui;

import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.api.model.uml.statik.IComponent;
import com.modeliosoft.modelio.api.model.uml.statik.IModelTree;
import com.modeliosoft.modelio.api.model.uml.statik.IPackage;
import com.modeliosoft.modelio.api.ui.ModelioDialog;
import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.api.utils.ObList;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.ramcs.remove.gui.DeleteModelComponentAdapter;
import com.modeliosoft.modelio.ramcs.remove.gui.DeleteModelComponentDataProvider;
import com.modeliosoft.modelio.ramcs.remove.gui.DeleteModelComponentDialog;
import com.modeliosoft.modelio.ramcs.ui.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;

public class DeleteModelComponentDialog
extends ModelioDialog {
    protected Composite composite = null;
    protected CheckboxTableViewer viewer = null;
    Text modelComponentDescriptionText = null;
    protected IModelingSession modelingSession = null;
    private List<DeleteModelComponentAdapter> modelComponentAdapters = null;
    protected ScrolledComposite scrolledComposite = null;

    public Control createContentArea(Composite parent) {
        this.composite = new Composite(parent, 0);
        this.composite.setFont(parent.getFont());
        FormLayout compositeLayout = new FormLayout();
        compositeLayout.marginWidth = 3;
        compositeLayout.marginHeight = 3;
        this.composite.setLayout((Layout)compositeLayout);
        GridData data = new GridData(1808);
        this.composite.setLayoutData((Object)data);
        String[] columnNames = new String[]{"DeleteModelComponentDialog.Name", "DeleteModelComponentDialog.Version", "DeleteModelComponentDialog.Dependencies"};
        this.viewer = CheckboxTableViewer.newCheckList((Composite)this.composite, (int)67618);
        this.viewer.getTable().setHeaderVisible(true);
        GridData tableData = new GridData();
        tableData.horizontalAlignment = 4;
        tableData.verticalAlignment = 4;
        tableData.grabExcessHorizontalSpace = true;
        tableData.grabExcessVerticalSpace = true;
        this.viewer.getTable().setLayoutData((Object)tableData);
        TableColumn column0 = new TableColumn(this.viewer.getTable(), 16384, 0);
        column0.setWidth(150);
        column0.setText(Messages.getString((String)"DeleteModelComponentDialog.Name"));
        TableColumn column1 = new TableColumn(this.viewer.getTable(), 16384, 1);
        column1.setWidth(100);
        column1.setText(Messages.getString((String)"DeleteModelComponentDialog.Version"));
        TableColumn column2 = new TableColumn(this.viewer.getTable(), 16384, 2);
        column2.setWidth(350);
        column2.setText(Messages.getString((String)"DeleteModelComponentDialog.Dependencies"));
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)new ModuleSelectionListener(this, this));
        this.viewer.addCheckStateListener((ICheckStateListener)new CheckStateListener(this, this));
        this.viewer.setColumnProperties(columnNames);
        DeleteModelComponentDataProvider dataProvider = new DeleteModelComponentDataProvider();
        this.viewer.setLabelProvider((IBaseLabelProvider)dataProvider);
        this.viewer.setContentProvider((IContentProvider)dataProvider);
        this.viewer.setInput((Object)this.modelComponentAdapters);
        FormData fd_viewerComposite = new FormData();
        fd_viewerComposite.left = new FormAttachment(0, 0);
        fd_viewerComposite.right = new FormAttachment(100, 0);
        fd_viewerComposite.top = new FormAttachment(0, 0);
        fd_viewerComposite.bottom = new FormAttachment(100, -85);
        this.viewer.getTable().setLayoutData((Object)fd_viewerComposite);
        this.scrolledComposite = new ScrolledComposite(this.composite, 512);
        GridLayout gl_scrolledComposite = new GridLayout(1, false);
        this.scrolledComposite.setLayout((Layout)gl_scrolledComposite);
        this.modelComponentDescriptionText = new Text((Composite)this.scrolledComposite, 64);
        this.modelComponentDescriptionText.setEditable(false);
        this.modelComponentDescriptionText.setForeground(UIColor.LABEL_TIP_FG);
        GridData fd_modelComponentDescriptionText = new GridData(4, 4, true, true);
        this.modelComponentDescriptionText.setLayoutData((Object)fd_modelComponentDescriptionText);
        this.scrolledComposite.setContent((Control)this.modelComponentDescriptionText);
        Point point = this.modelComponentDescriptionText.computeSize(-1, -1);
        this.scrolledComposite.setMinSize(point);
        this.scrolledComposite.setExpandVertical(true);
        this.scrolledComposite.setExpandHorizontal(true);
        FormData fd_scrolledComposite = new FormData();
        fd_scrolledComposite.left = new FormAttachment(0, 3);
        fd_scrolledComposite.right = new FormAttachment(100, -3);
        fd_scrolledComposite.top = new FormAttachment((Control)this.viewer.getTable(), 5);
        fd_scrolledComposite.bottom = new FormAttachment(100, -3);
        this.scrolledComposite.setLayoutData((Object)fd_scrolledComposite);
        this.refresh();
        return this.composite;
    }

    public void addButtonsInButtonBar(Composite parent) {
        this.createButton(parent, 0, Messages.getString((String)"DeleteModelComponentDialog.Delete"), true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    public void init() {
        this.getShell().setText(Messages.getString((String)"DeleteModelComponentDialog.Title"));
        this.setTitle(Messages.getString((String)"DeleteModelComponentDialog.Title"));
        this.setMessage(Messages.getString((String)"DeleteModelComponentDialog.Message"));
        this.getShell().setMinimumSize(600, 300);
    }

    public DeleteModelComponentDialog(Shell parentShell, IModelingSession modelingSession) {
        super(parentShell);
        this.modelingSession = modelingSession;
        IPackage rootPackage = this.modelingSession.getModel().getProject().getModel();
        this.modelComponentAdapters = new ArrayList();
        ObList components = rootPackage.getOwnedElement(IComponent.class);
        for (IModelTree component : components) {
            if (!(component instanceof IComponent) || !component.isStereotyped("ModelComponent")) continue;
            ObList artifacts = component.getOwnedElement(IArtifact.class);
            for (IArtifact artifact : artifacts) {
                if (!artifact.isStereotyped("ModelComponentArchive")) continue;
                this.modelComponentAdapters.add(new DeleteModelComponentAdapter(artifact));
            }
            ObList moduleComponents = component.getOwnedElement(IComponent.class);
            for (IModelTree moduleComponent : moduleComponents) {
                if (!(moduleComponent instanceof IComponent) || !moduleComponent.isStereotyped("JMDAComponent")) continue;
                ObList moduleArtifacts = moduleComponent.getOwnedElement(IArtifact.class);
                for (IArtifact moduleArtifact : moduleArtifacts) {
                    if (!moduleArtifact.isStereotyped("ModelComponentArchive")) continue;
                    this.modelComponentAdapters.add(new DeleteModelComponentAdapter(moduleArtifact));
                }
            }
        }
    }

    private void refresh() {
        int i = 0;
        while (i < this.modelComponentAdapters.size()) {
            DeleteModelComponentAdapter adapter = (DeleteModelComponentAdapter)this.modelComponentAdapters.get(i);
            this.viewer.setChecked((Object)adapter, adapter.isToDelete());
            ++i;
        }
        this.viewer.refresh();
    }

    public void setModelComponentDescription(String description) {
        this.modelComponentDescriptionText.setText(description);
        Point point = this.modelComponentDescriptionText.computeSize(this.modelComponentDescriptionText.getParent().getSize().x, -1, true);
        this.scrolledComposite.setMinSize(point);
    }

    public boolean close() {
        return super.close();
    }

    public Composite getComposite() {
        return this.composite;
    }

    public CheckboxTableViewer getViewer() {
        return this.viewer;
    }

    public Text getModuleDescriptionLabel() {
        return this.modelComponentDescriptionText;
    }

    public IModelingSession getModelingSession() {
        return this.modelingSession;
    }

    public List<DeleteModelComponentAdapter> getModuleAdapters() {
        return this.modelComponentAdapters;
    }

    public List<IArtifact> getModelComponentsToRemove() {
        ArrayList<DeleteModelComponentAdapter> adaptersToDelete = new ArrayList<DeleteModelComponentAdapter>();
        ArrayList<IArtifact> artifactsToDelete = new ArrayList<IArtifact>();
        for (DeleteModelComponentAdapter adapter : this.modelComponentAdapters) {
            if (!adapter.isToDelete()) continue;
            adaptersToDelete.add(adapter);
        }
        Collections.sort(adaptersToDelete);
        for (DeleteModelComponentAdapter adapter : adaptersToDelete) {
            artifactsToDelete.add(adapter.getModelComponent());
        }
        return artifactsToDelete;
    }

    protected String getHelpId() {
        return "/com.modeliosoft.modelio.documentation.modeler/html/Model_components_deleting.html";
    }

    static /* synthetic */ void access$0(DeleteModelComponentDialog deleteModelComponentDialog) {
        deleteModelComponentDialog.refresh();
    }

    static /* synthetic */ List access$1(DeleteModelComponentDialog deleteModelComponentDialog) {
        return deleteModelComponentDialog.modelComponentAdapters;
    }
}

