/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.symbol.view;

import com.modeliosoft.modelio.diagram.elements.core.model.IGmObject;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.NamedStyle;
import com.modeliosoft.modelio.diagram.styles.manager.StyleManager;
import com.modeliosoft.modelio.diagram.styles.plugin.DiagramStyles;
import com.modeliosoft.modelio.diagram.symbol.view.StyleEditor;
import com.modeliosoft.modelio.diagram.symbol.view.StyleSelector;
import org.eclipse.jface.action.ControlContribution;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StyleSelector
extends ControlContribution {
    protected static final String DIAGRAM_SETTINGS_STYLE = "diagram settings";
    public static final String ID = "com.modeliosoft.modelio.diagram.symbol.StyleSelectorID";
    private IGmObject gmObject;
    private Combo combo;

    public StyleSelector() {
        super(ID);
    }

    protected Control createControl(Composite parent) {
        this.combo = new Combo(parent, 8);
        this.combo.addFocusListener((FocusListener)new StyleComboFocusListener(this, this, this.combo));
        this.combo.addSelectionListener((SelectionListener)new StyleComboSelectionAdapter(this, this, this.combo));
        this.populateCombo();
        return this.combo;
    }

    public void changeStyle(IStyle style) {
        StyleEditor se = new StyleEditor(this.gmObject);
        if (style != null) {
            se.setCascadedStyle(style);
        } else if (this.gmObject != this.gmObject.getDiagram()) {
            IStyle diagramStyle = this.gmObject.getDiagram().getStyle();
            se.setCascadedStyle(diagramStyle);
            se.reset();
        }
    }

    public void update(IGmObject gmObject) {
        if (gmObject == null) {
            this.combo.removeAll();
            this.combo.setEnabled(false);
            return;
        }
        this.populateCombo();
        this.gmObject = gmObject;
        IStyle diagramStyle = this.gmObject.getDiagram().getStyle();
        IStyle gmObjectBaseStyle = this.gmObject.getStyle().getCascadedStyle();
        if (gmObjectBaseStyle == diagramStyle) {
            this.combo.setText(DIAGRAM_SETTINGS_STYLE);
        } else if (gmObjectBaseStyle instanceof NamedStyle) {
            this.combo.setText(((NamedStyle)gmObjectBaseStyle).getName());
        } else {
            this.combo.select(0);
        }
        boolean isEditable = gmObject.isEditable();
        this.combo.setEnabled(isEditable);
        this.combo.pack();
    }

    protected void populateCombo() {
        this.combo.removeAll();
        this.combo.add(DIAGRAM_SETTINGS_STYLE, 0);
        StyleManager sm = DiagramStyles.getInstance().getStyleManager();
        for (String label : sm.getAvailableStyles()) {
            this.combo.add(label);
        }
    }
}

