/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.diagram.symbol.view;

import com.modeliosoft.modelio.api.ui.UIColor;
import com.modeliosoft.modelio.diagram.elements.core.model.IGmObject;
import com.modeliosoft.modelio.diagram.styles.core.IStyle;
import com.modeliosoft.modelio.diagram.styles.core.IStyleChangeListener;
import com.modeliosoft.modelio.diagram.styles.core.StyleKey;
import com.modeliosoft.modelio.diagram.styles.manager.StyleModelProvider;
import com.modeliosoft.modelio.diagram.styles.viewer.StyleViewer;
import com.modeliosoft.modelio.diagram.symbol.view.StyleEditor;
import com.modeliosoft.modelio.diagram.symbol.view.StyleSelector;
import com.modeliosoft.modelio.diagram.symbol.view.SymbolView;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class SymbolView
extends ViewPart
implements IStyleChangeListener,
ISelectionListener,
PropertyChangeListener {
    public static final String VIEW_ID = "com.modeliosoft.modelio.diagram.symbol.SymbolViewID";
    private StyleSelector styleSelector;
    private IGmObject selectedSymbol;
    private StyleViewer styleViewer;
    private SashForm sash;
    private Text descriptionText;

    public void createPartControl(Composite parent) {
        this.sash = new SashForm(parent, 512);
        this.sash.setLayout((Layout)new FillLayout());
        this.styleViewer = new StyleViewer((Composite)this.sash, null);
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.styleSelector = new StyleSelector();
        toolBarManager.add((IContributionItem)this.styleSelector);
        toolBarManager.update(true);
        this.descriptionText = this.createHelpPanel((Composite)this.sash);
        this.sash.setWeights(new int[]{80, 20});
        this.styleViewer.getTreeViewer().addSelectionChangedListener((ISelectionChangedListener)new DescriptionTextUpdater(this.descriptionText));
    }

    public void setFocus() {
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        site.getPage().addSelectionListener((ISelectionListener)this);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        if (sel == null) {
            return;
        }
        if (part == null || !part.equals(part)) {
            return;
        }
        if (sel instanceof IStructuredSelection) {
            List selectedElements = ((IStructuredSelection)sel).toList();
            if (selectedElements.size() == 1 && selectedElements.get(0) instanceof IAdaptable) {
                IAdaptable selectedAdapter = (IAdaptable)selectedElements.get(0);
                IGmObject gmObject = (IGmObject)selectedAdapter.getAdapter(IGmObject.class);
                this.setSelectedSymbol(gmObject);
            } else {
                this.setSelectedSymbol(null);
            }
        }
    }

    private Text createHelpPanel(Composite parent) {
        Text newText = new Text(parent, 586);
        newText.setBackground(UIColor.TEXT_READONLY_BG);
        newText.setText("");
        newText.setVisible(false);
        return newText;
    }

    public void toggleHelpPanel() {
        if (!this.descriptionText.isDisposed()) {
            boolean currentState = this.descriptionText.getVisible();
            if (currentState) {
                this.descriptionText.setVisible(false);
            } else {
                this.descriptionText.setVisible(true);
            }
            this.descriptionText.getParent().layout();
        }
    }

    private void setSelectedSymbol(IGmObject selectedSymbol) {
        if (this.selectedSymbol != null && this.selectedSymbol == selectedSymbol) {
            return;
        }
        if (this.selectedSymbol != null) {
            this.selectedSymbol.getStyle().removeListener((IStyleChangeListener)this);
            this.selectedSymbol.removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.selectedSymbol = selectedSymbol;
        if (selectedSymbol != null) {
            boolean isEditable = selectedSymbol.isEditable();
            StyleModelProvider model = new StyleModelProvider((IStyle)new StyleEditor(selectedSymbol), (Collection)selectedSymbol.getStyleKeys(), isEditable);
            this.styleViewer.setModel(model);
            this.styleViewer.getTreeViewer().expandAll();
            this.styleViewer.getTreeViewer().refresh();
            this.styleSelector.update(selectedSymbol);
            this.selectedSymbol.getStyle().addListener((IStyleChangeListener)this);
            this.selectedSymbol.addPropertyChangeListener((PropertyChangeListener)this);
        } else {
            this.styleViewer.setModel(null);
            this.styleSelector.update(selectedSymbol);
        }
    }

    public void dispose() {
        this.getViewSite().getPage().removeSelectionListener((ISelectionListener)this);
        super.dispose();
    }

    public IGmObject getSelectedSymbol() {
        return this.selectedSymbol;
    }

    public void styleChanged(StyleKey property, Object newValue) {
        if (this.selectedSymbol == null) {
            return;
        }
        Collection keyfilter = this.styleViewer.getModel().getKeyfilter();
        if (keyfilter == null) {
            return;
        }
        if (!keyfilter.equals(this.selectedSymbol.getStyleKeys())) {
            StyleModelProvider model = new StyleModelProvider((IStyle)new StyleEditor(this.selectedSymbol), (Collection)this.selectedSymbol.getStyleKeys(), true);
            this.styleViewer.setModel(model);
            this.styleViewer.getTreeViewer().expandAll();
            this.styleViewer.getTreeViewer().refresh();
            this.styleSelector.update(this.selectedSymbol);
        }
    }

    public void styleChanged(IStyle changedStyle) {
        Collection keyfilter = this.styleViewer.getModel().getKeyfilter();
        if (keyfilter == null) {
            return;
        }
        if (!keyfilter.equals(this.selectedSymbol.getStyleKeys())) {
            StyleModelProvider model = new StyleModelProvider((IStyle)new StyleEditor(this.selectedSymbol), (Collection)this.selectedSymbol.getStyleKeys(), true);
            this.styleViewer.setModel(model);
            this.styleViewer.getTreeViewer().expandAll();
            this.styleViewer.getTreeViewer().refresh();
            this.styleSelector.update(this.selectedSymbol);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("Delete")) {
            this.setSelectedSymbol(null);
        }
    }
}

