/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.accessibility;

import com.sun.java.accessibility._AccessibleState;
import com.sun.java.accessibility.util.AWTEventMonitor;
import com.sun.java.accessibility.util.AccessibilityEventMonitor;
import com.sun.java.accessibility.util.EventQueueMonitor;
import com.sun.java.accessibility.util.SwingEventMonitor;
import com.sun.java.accessibility.util.Translator;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleAction;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleEditableText;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleExtendedTable;
import javax.accessibility.AccessibleHyperlink;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRelation;
import javax.accessibility.AccessibleRelationSet;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleTable;
import javax.accessibility.AccessibleText;
import javax.accessibility.AccessibleValue;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.TreeUI;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import javax.swing.text.TabSet;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class AccessBridge
implements Runnable {
    public static final String AccessBridgeVersion = "AccessBridge 2.0.2";
    private static AccessBridge theAccessBridge;
    private ObjectReferences references;
    private EventHandler eventHandler;
    private boolean runningOnJDK1_4 = false;
    private boolean runningOnJDK1_5 = false;
    private boolean useJAWT_DLL = false;
    private Hashtable accessibleRoleMap = new Hashtable();
    private ArrayList extendedVirtualNameSearchRoles = new ArrayList();
    private ArrayList noExtendedVirtualNameSearchParentRoles = new ArrayList();
    private Method javaGetComponentFromNativeWindowHandleMethod;
    private Method javaGetNativeWindowHandleFromComponentMethod;
    Toolkit toolkit;
    private static Hashtable windowHandleToContextMap;
    private static Hashtable contextToWindowHandleMap;
    private static Vector nativeWindowHandlers;
    Hashtable hashtab = new Hashtable();
    private int _visibleChildrenCount;
    private AccessibleContext _visibleChild;
    private int _currentVisibleIndex;
    private boolean _foundVisibleChild;
    public static final long PROPERTY_CHANGE_EVENTS = 1L;
    public static final long FOCUS_GAINED_EVENTS = 2L;
    public static final long FOCUS_LOST_EVENTS = 4L;
    public static final long FOCUS_EVENTS = 6L;
    public static final long CARET_UPATE_EVENTS = 8L;
    public static final long CARET_EVENTS = 8L;
    public static final long MOUSE_CLICKED_EVENTS = 16L;
    public static final long MOUSE_ENTERED_EVENTS = 32L;
    public static final long MOUSE_EXITED_EVENTS = 64L;
    public static final long MOUSE_PRESSED_EVENTS = 128L;
    public static final long MOUSE_RELEASED_EVENTS = 256L;
    public static final long MOUSE_EVENTS = 496L;
    public static final long MENU_CANCELED_EVENTS = 512L;
    public static final long MENU_DESELECTED_EVENTS = 1024L;
    public static final long MENU_SELECTED_EVENTS = 2048L;
    public static final long MENU_EVENTS = 3584L;
    public static final long POPUPMENU_CANCELED_EVENTS = 4096L;
    public static final long POPUPMENU_WILL_BECOME_INVISIBLE_EVENTS = 8192L;
    public static final long POPUPMENU_WILL_BECOME_VISIBLE_EVENTS = 16384L;
    public static final long POPUPMENU_EVENTS = 28672L;
    public static final long PROPERTY_NAME_CHANGE_EVENTS = 1L;
    public static final long PROPERTY_DESCRIPTION_CHANGE_EVENTS = 2L;
    public static final long PROPERTY_STATE_CHANGE_EVENTS = 4L;
    public static final long PROPERTY_VALUE_CHANGE_EVENTS = 8L;
    public static final long PROPERTY_SELECTION_CHANGE_EVENTS = 16L;
    public static final long PROPERTY_TEXT_CHANGE_EVENTS = 32L;
    public static final long PROPERTY_CARET_CHANGE_EVENTS = 64L;
    public static final long PROPERTY_VISIBLEDATA_CHANGE_EVENTS = 128L;
    public static final long PROPERTY_CHILD_CHANGE_EVENTS = 256L;
    public static final long PROPERTY_ACTIVEDESCENDENT_CHANGE_EVENTS = 512L;
    public static final long PROPERTY_EVENTS = 1023L;
    private AccessibleRole[] allAccessibleRoles = new AccessibleRole[]{AccessibleRole.ALERT, AccessibleRole.COLUMN_HEADER, AccessibleRole.CANVAS, AccessibleRole.COMBO_BOX, AccessibleRole.DESKTOP_ICON, AccessibleRole.INTERNAL_FRAME, AccessibleRole.DESKTOP_PANE, AccessibleRole.OPTION_PANE, AccessibleRole.WINDOW, AccessibleRole.FRAME, AccessibleRole.DIALOG, AccessibleRole.COLOR_CHOOSER, AccessibleRole.DIRECTORY_PANE, AccessibleRole.FILE_CHOOSER, AccessibleRole.FILLER, AccessibleRole.ICON, AccessibleRole.LABEL, AccessibleRole.ROOT_PANE, AccessibleRole.GLASS_PANE, AccessibleRole.LAYERED_PANE, AccessibleRole.LIST, AccessibleRole.LIST_ITEM, AccessibleRole.MENU_BAR, AccessibleRole.POPUP_MENU, AccessibleRole.MENU, AccessibleRole.MENU_ITEM, AccessibleRole.SEPARATOR, AccessibleRole.PAGE_TAB_LIST, AccessibleRole.PAGE_TAB, AccessibleRole.PANEL, AccessibleRole.PROGRESS_BAR, AccessibleRole.PASSWORD_TEXT, AccessibleRole.PUSH_BUTTON, AccessibleRole.TOGGLE_BUTTON, AccessibleRole.CHECK_BOX, AccessibleRole.RADIO_BUTTON, AccessibleRole.ROW_HEADER, AccessibleRole.SCROLL_PANE, AccessibleRole.SCROLL_BAR, AccessibleRole.VIEWPORT, AccessibleRole.SLIDER, AccessibleRole.SPLIT_PANE, AccessibleRole.TABLE, AccessibleRole.TEXT, AccessibleRole.TREE, AccessibleRole.TOOL_BAR, AccessibleRole.TOOL_TIP, AccessibleRole.AWT_COMPONENT, AccessibleRole.SWING_COMPONENT, AccessibleRole.UNKNOWN};

    public static void main(String[] stringArray) {
        new AccessBridge();
    }

    public AccessBridge() {
        theAccessBridge = this;
        this.references = new ObjectReferences();
        Runtime runtime = Runtime.getRuntime();
        shutdownHook shutdownHook2 = new shutdownHook();
        runtime.addShutdownHook(new Thread(shutdownHook2));
        this.initAccessibleRoleMap();
        String string = this.getJavaVersionProperty();
        this.debugString("JDK version = " + string);
        this.useJAWT_DLL = string.compareTo("1.4.1") >= 0;
        this.runningOnJDK1_4 = string.compareTo("1.4") >= 0;
        boolean bl = this.runningOnJDK1_5 = string.compareTo("1.5") >= 0;
        if (this.useJAWT_DLL) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.loadLibrary("JAWT");
                    System.loadLibrary("JAWTAccessBridge-64");
                    return null;
                }
            });
        }
        if (this.initHWNDcalls()) {
            EventQueueMonitor.isGUIInitialized();
            this.eventHandler = new EventHandler(this);
            if (this.runningOnJDK1_4) {
                MenuSelectionManager.defaultManager().addChangeListener(this.eventHandler);
            }
            AccessBridge.addNativeWindowHandler(new DefaultNativeWindowHandler());
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.start();
            this.debugString("AccessBridge started");
        } else {
            this.debugString("Cannot load the AccessBridge - couldn't init HWND calls");
        }
    }

    private void initAccessibleRoleMap() {
        try {
            Class<?> clazz = Class.forName("javax.accessibility.AccessibleRole");
            if (null != clazz) {
                AccessibleRole accessibleRole = AccessibleRole.UNKNOWN;
                Field[] fieldArray = clazz.getFields();
                int n = 0;
                for (n = 0; n < fieldArray.length; ++n) {
                    Field field = fieldArray[n];
                    if (AccessibleRole.class != field.getType()) continue;
                    AccessibleRole accessibleRole2 = (AccessibleRole)field.get(accessibleRole);
                    String string = accessibleRole2.toDisplayString(Locale.US);
                    this.accessibleRoleMap.put(string, accessibleRole2);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.COMBO_BOX);
        try {
            this.extendedVirtualNameSearchRoles.add(AccessibleRole.DATE_EDITOR);
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.LIST);
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.PASSWORD_TEXT);
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.SLIDER);
        try {
            this.extendedVirtualNameSearchRoles.add(AccessibleRole.SPIN_BOX);
        }
        catch (NoSuchFieldError noSuchFieldError) {
            // empty catch block
        }
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.TABLE);
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.TEXT);
        this.extendedVirtualNameSearchRoles.add(AccessibleRole.UNKNOWN);
        this.noExtendedVirtualNameSearchParentRoles.add(AccessibleRole.TABLE);
        this.noExtendedVirtualNameSearchParentRoles.add(AccessibleRole.TOOL_BAR);
    }

    @Override
    public native void run();

    public native void sendDebugString(String var1);

    public void debugString(String string) {
    }

    public void decrementReference(Object object) {
        this.references.decrement(object);
    }

    public String getJavaVersionProperty() {
        String string = System.getProperty("java.version");
        if (string != null) {
            this.references.increment(string);
            return string;
        }
        return null;
    }

    public String getAccessBridgeVersion() {
        String string = new String(AccessBridgeVersion);
        this.references.increment(string);
        return string;
    }

    public native int isJAWTInstalled();

    public native int jawtGetNativeWindowHandleFromComponent(Component var1);

    public native Component jawtGetComponentFromNativeWindowHandle(int var1);

    public boolean initHWNDcalls() {
        Class[] classArray = new Class[]{Integer.TYPE};
        Class[] classArray2 = new Class[1];
        try {
            classArray2[0] = Class.forName("java.awt.Component");
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.debugString("Exception: " + classNotFoundException.toString());
        }
        Object[] objectArray = new Object[1];
        boolean bl = false;
        this.toolkit = Toolkit.getDefaultToolkit();
        if (this.useJAWT_DLL) {
            bl = true;
        } else {
            try {
                this.javaGetComponentFromNativeWindowHandleMethod = this.toolkit.getClass().getMethod("getComponentFromNativeWindowHandle", classArray);
                if (this.javaGetComponentFromNativeWindowHandleMethod != null) {
                    try {
                        objectArray[0] = new Integer(1);
                        Component component = (Component)this.javaGetComponentFromNativeWindowHandleMethod.invoke((Object)this.toolkit, objectArray);
                        bl = true;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        this.debugString("Exception: " + invocationTargetException.toString());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        this.debugString("Exception: " + illegalAccessException.toString());
                    }
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.debugString("Exception: " + noSuchMethodException.toString());
            }
            catch (SecurityException securityException) {
                this.debugString("Exception: " + securityException.toString());
            }
            try {
                this.javaGetNativeWindowHandleFromComponentMethod = this.toolkit.getClass().getMethod("getNativeWindowHandleFromComponent", classArray2);
                if (this.javaGetNativeWindowHandleFromComponentMethod != null) {
                    try {
                        objectArray[0] = new Button("OK");
                        Integer n = (Integer)this.javaGetNativeWindowHandleFromComponentMethod.invoke((Object)this.toolkit, objectArray);
                        bl = true;
                    }
                    catch (InvocationTargetException invocationTargetException) {
                        this.debugString("Exception: " + invocationTargetException.toString());
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        this.debugString("Exception: " + illegalAccessException.toString());
                    }
                    catch (Exception exception) {
                        this.debugString("Exception: " + exception.toString());
                    }
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.debugString("Exception: " + noSuchMethodException.toString());
            }
            catch (SecurityException securityException) {
                this.debugString("Exception: " + securityException.toString());
            }
        }
        return bl;
    }

    public static void registerVirtualFrame(Accessible accessible, Integer n) {
        if (accessible != null) {
            windowHandleToContextMap.put(n, accessible.getAccessibleContext());
            contextToWindowHandleMap.put(accessible.getAccessibleContext(), n);
        }
    }

    public static void revokeVirtualFrame(Accessible accessible, Integer n) {
        windowHandleToContextMap.remove(n);
        contextToWindowHandleMap.remove(accessible.getAccessibleContext());
    }

    public static void addNativeWindowHandler(NativeWindowHandler nativeWindowHandler) {
        theAccessBridge.debugString("addNativeWindowHandler=" + nativeWindowHandler.getClass());
        if (nativeWindowHandler == null) {
            throw new IllegalArgumentException();
        }
        nativeWindowHandlers.addElement(nativeWindowHandler);
    }

    public static boolean removeNativeWindowHandler(NativeWindowHandler nativeWindowHandler) {
        theAccessBridge.debugString("removeNativeWindowHandler=" + nativeWindowHandler.getClass());
        if (nativeWindowHandler == null) {
            throw new IllegalArgumentException();
        }
        return nativeWindowHandlers.removeElement(nativeWindowHandler);
    }

    public boolean isJavaWindow(int n) {
        AccessibleContext accessibleContext = this.getContextFromNativeWindowHandle(n);
        if (accessibleContext != null) {
            this.saveContextToWindowHandleMapping(accessibleContext, n);
            return true;
        }
        return false;
    }

    private void saveContextToWindowHandleMapping(AccessibleContext accessibleContext, int n) {
        this.debugString("saveContextToWindowHandleMapping...");
        if (accessibleContext == null) {
            return;
        }
        if (!contextToWindowHandleMap.containsKey(accessibleContext)) {
            this.debugString("saveContextToWindowHandleMapping: ac = " + accessibleContext + "; handle = " + n);
            contextToWindowHandleMap.put(accessibleContext, new Integer(n));
        }
    }

    public AccessibleContext getContextFromNativeWindowHandle(int n) {
        Object v = windowHandleToContextMap.get(new Integer(n));
        if (v instanceof AccessibleContext) {
            this.saveContextToWindowHandleMapping((AccessibleContext)v, n);
            return (AccessibleContext)v;
        }
        int n2 = nativeWindowHandlers.size();
        for (int i = 0; i < n2; ++i) {
            NativeWindowHandler nativeWindowHandler = (NativeWindowHandler)nativeWindowHandlers.elementAt(i);
            Accessible accessible = nativeWindowHandler.getAccessibleFromNativeWindowHandle(n);
            if (accessible == null) continue;
            this.saveContextToWindowHandleMapping(accessible.getAccessibleContext(), n);
            return accessible.getAccessibleContext();
        }
        return null;
    }

    public int getNativeWindowHandleFromContext(AccessibleContext accessibleContext) {
        this.debugString("getNativeWindowHandleFromContext: ac = " + accessibleContext);
        Enumeration enumeration = contextToWindowHandleMap.keys();
        while (enumeration.hasMoreElements()) {
            this.debugString(" next elem = " + enumeration.nextElement());
        }
        Object v = contextToWindowHandleMap.get(accessibleContext);
        if (v instanceof Integer) {
            this.debugString(" returning (success) " + (Integer)v);
            return (Integer)v;
        }
        this.debugString(" returning (failure) 0");
        return 0;
    }

    public int getNativeWindowHandleFromComponent(Component component) {
        if (this.useJAWT_DLL) {
            this.debugString("*** calling jawtGetNativeWindowHandleFromComponent");
            return this.jawtGetNativeWindowHandleFromComponent(component);
        }
        Object[] objectArray = new Object[1];
        this.debugString("*** calling javaGetNativeWindowHandleFromComponent");
        if (this.javaGetNativeWindowHandleFromComponentMethod != null) {
            try {
                objectArray[0] = component;
                Integer n = (Integer)this.javaGetNativeWindowHandleFromComponentMethod.invoke((Object)this.toolkit, objectArray);
                contextToWindowHandleMap.put(component.getAccessibleContext(), n);
                return n;
            }
            catch (InvocationTargetException invocationTargetException) {
                this.debugString("Exception: " + invocationTargetException.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                this.debugString("Exception: " + illegalAccessException.toString());
            }
        }
        return -1;
    }

    public AccessibleContext getAccessibleContextAt(int n, int n2, AccessibleContext accessibleContext) {
        if (accessibleContext == null) {
            return null;
        }
        if (windowHandleToContextMap != null && windowHandleToContextMap.containsValue(this.getRootAccessibleContext(accessibleContext))) {
            return this.getAccessibleContextAt_1(n, n2, accessibleContext);
        }
        return this.getAccessibleContextAt_2(n, n2, accessibleContext);
    }

    private AccessibleContext getRootAccessibleContext(AccessibleContext accessibleContext) {
        if (accessibleContext == null) {
            return null;
        }
        Accessible accessible = accessibleContext.getAccessibleParent();
        if (accessible == null) {
            return accessibleContext;
        }
        Accessible accessible2 = accessible.getAccessibleContext().getAccessibleParent();
        while (accessible2 != null) {
            accessible = accessible2;
            accessible2 = accessible.getAccessibleContext().getAccessibleParent();
        }
        return accessible.getAccessibleContext();
    }

    public AccessibleContext getAccessibleContextAt_1(int n, int n2, AccessibleContext accessibleContext) {
        AccessibleComponent accessibleComponent;
        this.debugString(" : getAccessibleContextAt_1 called");
        this.debugString("   -> x = " + n + " y = " + n2 + " parent = " + accessibleContext);
        if (accessibleContext != null && (accessibleComponent = accessibleContext.getAccessibleComponent()) != null) {
            AccessibleContext accessibleContext2;
            Point point = accessibleComponent.getLocation();
            Accessible accessible = accessibleComponent.getAccessibleAt(new Point(n - point.x, n2 - point.y));
            if (accessible != null && (accessibleContext2 = accessible.getAccessibleContext()) != null) {
                if (accessibleContext2 != accessibleContext) {
                    return this.getAccessibleContextAt_1(n - point.x, n2 - point.y, accessibleContext2);
                }
                this.debugString("   returning ac = " + accessibleContext2);
                return accessibleContext2;
            }
        }
        return accessibleContext;
    }

    public AccessibleContext getAccessibleContextAt_2(int n, int n2, AccessibleContext accessibleContext) {
        AccessibleContext accessibleContext2;
        this.debugString("getAccessibleContextAt_2 called");
        this.debugString("   -> x = " + n + " y = " + n2 + " parent = " + accessibleContext);
        Accessible accessible = EventQueueMonitor.getAccessibleAt(new Point(n, n2));
        if (accessible != null && (accessibleContext2 = accessible.getAccessibleContext()) != null) {
            this.debugString("   returning childAC = " + accessibleContext2);
            return accessibleContext2;
        }
        this.debugString("returning AccessibleContext = null");
        return null;
    }

    public AccessibleContext getAccessibleContextWithFocus() {
        AccessibleContext accessibleContext;
        Accessible accessible;
        Component component = AWTEventMonitor.getComponentWithFocus();
        if (component != null && (accessible = Translator.getAccessible(component)) != null && (accessibleContext = accessible.getAccessibleContext()) != null) {
            return accessibleContext;
        }
        return null;
    }

    public String getAccessibleNameFromContext(AccessibleContext accessibleContext) {
        this.debugString("***** ac = " + accessibleContext.getClass());
        if (accessibleContext != null) {
            String string = accessibleContext.getAccessibleName();
            if (string != null) {
                this.references.increment(string);
                this.debugString("Returning AccessibleName from Context: " + string);
                return string;
            }
            return null;
        }
        this.debugString("getAccessibleNameFromContext; ac = null!");
        return null;
    }

    public String getVirtualAccessibleNameFromContext(AccessibleContext accessibleContext) {
        if (null != accessibleContext) {
            int n;
            String string;
            String string2 = accessibleContext.getAccessibleName();
            if (null != string2 && 0 != string2.length()) {
                this.debugString("bk -- The Virtual Accessible Name was obtained from AccessibleContext::getAccessibleName.");
                this.references.increment(string2);
                return string2;
            }
            String string3 = accessibleContext.getAccessibleDescription();
            if (null != string3 && 0 != string3.length()) {
                this.debugString("bk -- The Virtual Accessible Name was obtained from AccessibleContext::getAccessibleDescription.");
                this.references.increment(string3);
                return string3;
            }
            boolean bl = false;
            AccessibleRole accessibleRole = accessibleContext.getAccessibleRole();
            AccessibleContext accessibleContext2 = null;
            AccessibleRole accessibleRole2 = AccessibleRole.UNKNOWN;
            if (this.extendedVirtualNameSearchRoles.contains(accessibleRole) && null != (accessibleContext2 = this.getAccessibleParentFromContext(accessibleContext)) && AccessibleRole.UNKNOWN != (accessibleRole2 = accessibleContext2.getAccessibleRole())) {
                bl = true;
                if (this.noExtendedVirtualNameSearchParentRoles.contains(accessibleRole2)) {
                    bl = false;
                }
            }
            if (!bl) {
                AccessibleValue accessibleValue;
                this.debugString("bk -- getVirtualAccessibleNameFromContext will not use the extended name search algorithm.  role = " + accessibleRole.toDisplayString(Locale.US));
                if (AccessibleRole.LABEL == accessibleRole) {
                    int n2;
                    Object object;
                    AccessibleText accessibleText = accessibleContext.getAccessibleText();
                    if (null != accessibleText && null != (object = this.getAccessibleTextRangeFromContext(accessibleContext, 0, n2 = accessibleText.getCharCount()))) {
                        this.debugString("bk -- The Virtual Accessible Name was obtained from the Accessible Text of the LABEL object.");
                        this.references.increment(object);
                        return object;
                    }
                    this.debugString("bk -- Attempting to obtain the Virtual Accessible Name from the Accessible Icon information.");
                    AccessibleIcon[] accessibleIconArray = accessibleContext.getAccessibleIcon();
                    if (null != accessibleIconArray && accessibleIconArray.length > 0) {
                        this.debugString("bk -- The Virtual Accessible Name was obtained from the description of the first Accessible Icon found in the LABEL object.");
                        object = accessibleIconArray[0].getAccessibleIconDescription();
                        this.references.increment(object);
                        return object;
                    }
                    accessibleContext2 = this.getAccessibleParentFromContext(accessibleContext);
                    if (null != accessibleContext2 && AccessibleRole.TABLE == (accessibleRole2 = accessibleContext2.getAccessibleRole())) {
                        object = null;
                        int n3 = accessibleContext.getAccessibleIndexInParent();
                        object = this.getAccessibleChildFromContext(accessibleContext2, n3);
                        this.debugString("bk -- Making a second attempt to obtain the Virtual Accessible Name from the Accessible Icon information for the Table Cell.");
                        accessibleIconArray = ((AccessibleContext)object).getAccessibleIcon();
                        if (null != accessibleIconArray && accessibleIconArray.length > 0) {
                            this.debugString("bk -- The Virtual Accessible Name was obtained from the description of the first Accessible Icon found in the Table Cell object.");
                            String string4 = accessibleIconArray[0].getAccessibleIconDescription();
                            this.references.increment(string4);
                            return string4;
                        }
                    }
                } else if (AccessibleRole.TOGGLE_BUTTON == accessibleRole || AccessibleRole.PUSH_BUTTON == accessibleRole) {
                    this.debugString("bk -- Attempting to obtain the Virtual Accessible Name from the Accessible Icon information.");
                    AccessibleIcon[] accessibleIconArray = accessibleContext.getAccessibleIcon();
                    if (null != accessibleIconArray && accessibleIconArray.length > 0) {
                        this.debugString("bk -- The Virtual Accessible Name was obtained from the description of the first Accessible Icon found in the TOGGLE_BUTTON or PUSH_BUTTON object.");
                        String string5 = accessibleIconArray[0].getAccessibleIconDescription();
                        this.references.increment(string5);
                        return string5;
                    }
                } else if (AccessibleRole.CHECK_BOX == accessibleRole && null != (accessibleValue = accessibleContext.getAccessibleValue())) {
                    string2 = null;
                    Number number = accessibleValue.getCurrentAccessibleValue();
                    if (null != number && null != (string2 = 1 == number.intValue() ? Boolean.TRUE.toString() : (0 == number.intValue() ? Boolean.FALSE.toString() : number.toString()))) {
                        this.references.increment(string2);
                        return string2;
                    }
                }
                return null;
            }
            String string6 = accessibleContext2.getAccessibleName();
            String string7 = accessibleContext2.getAccessibleDescription();
            if (AccessibleRole.SLIDER == accessibleRole && AccessibleRole.PANEL == accessibleRole2 && null != string6) {
                this.debugString("bk -- The Virtual Accessible Name was obtained from the Accessible Name of the SLIDER object's parent object.");
                this.references.increment(string6);
                return string6;
            }
            boolean bl2 = false;
            AccessibleContext accessibleContext3 = accessibleContext;
            if (AccessibleRole.TEXT == accessibleRole && AccessibleRole.COMBO_BOX == accessibleRole2) {
                bl2 = true;
                if (null != string6) {
                    this.debugString("bk -- The Virtual Accessible Name for this Edit Combo box was obtained from the Accessible Name of the object's parent object.");
                    this.references.increment(string6);
                    return string6;
                }
                if (null != string7) {
                    this.debugString("bk -- The Virtual Accessible Name for this Edit Combo box was obtained from the Accessible Description of the object's parent object.");
                    this.references.increment(string7);
                    return string7;
                }
                accessibleContext3 = accessibleContext2;
                accessibleRole2 = AccessibleRole.UNKNOWN;
                accessibleContext2 = this.getAccessibleParentFromContext(accessibleContext3);
                if (null != accessibleContext2) {
                    accessibleRole2 = accessibleContext2.getAccessibleRole();
                }
            }
            if (null != (string = this.getJavaVersionProperty()) && string.compareTo("1.3") >= 0) {
                AccessibleRelation accessibleRelation;
                Object[] objectArray;
                Object object;
                AccessibleRelationSet accessibleRelationSet = accessibleContext3.getAccessibleRelationSet();
                if (accessibleRelationSet.size() > 0 && accessibleRelationSet.contains(AccessibleRelation.LABELED_BY) && (object = (objectArray = (accessibleRelation = accessibleRelationSet.get(AccessibleRelation.LABELED_BY)).getTarget())[0]) instanceof Accessible) {
                    AccessibleContext accessibleContext4 = ((Accessible)object).getAccessibleContext();
                    String string8 = accessibleContext4.getAccessibleName();
                    String string9 = accessibleContext4.getAccessibleDescription();
                    if (null != string8) {
                        this.debugString("bk -- The Virtual Accessible Name was obtained using the LABELED_BY AccessibleRelation -- Name Case.");
                        this.references.increment(string8);
                        return string8;
                    }
                    if (null != string9) {
                        this.debugString("bk -- The Virtual Accessible Name was obtained using the LABELED_BY AccessibleRelation -- Description Case.");
                        this.references.increment(string9);
                        return string9;
                    }
                }
            } else {
                this.debugString("bk -- This version of Java does not support AccessibleContext::getAccessibleRelationSet.");
            }
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            n4 = accessibleContext3.getAccessibleIndexInParent();
            if (null != accessibleContext2) {
                n5 = accessibleContext2.getAccessibleChildrenCount() - 1;
            }
            n6 = this.getAccessibleXcoordFromContext(accessibleContext3);
            n7 = this.getAccessibleYcoordFromContext(accessibleContext3);
            n8 = this.getAccessibleWidthFromContext(accessibleContext3);
            n9 = this.getAccessibleHeightFromContext(accessibleContext3);
            n10 = n6 + 2;
            n11 = n7 + 2;
            Accessible accessible = null;
            AccessibleContext accessibleContext5 = null;
            AccessibleRole accessibleRole3 = AccessibleRole.UNKNOWN;
            int n12 = 0;
            int n13 = 0;
            int n14 = 0;
            int n15 = 0;
            String string10 = null;
            String string11 = null;
            for (n = n4 - 1; n >= 0; --n) {
                accessible = accessibleContext2.getAccessibleChild(n);
                if (null == accessible || null == (accessibleContext5 = accessible.getAccessibleContext()) || AccessibleRole.LABEL != (accessibleRole3 = accessibleContext5.getAccessibleRole())) continue;
                n12 = this.getAccessibleXcoordFromContext(accessibleContext5);
                n13 = this.getAccessibleYcoordFromContext(accessibleContext5);
                n14 = this.getAccessibleWidthFromContext(accessibleContext5);
                n15 = this.getAccessibleHeightFromContext(accessibleContext5);
                if (n12 < n6 && n13 <= n11 && n11 <= n13 + n15) {
                    string10 = accessibleContext5.getAccessibleName();
                    if (null != string10) {
                        this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Name of a LABEL object positioned to the left of the object.");
                        this.references.increment(string10);
                        return string10;
                    }
                    string11 = accessibleContext5.getAccessibleDescription();
                    if (null == string11) continue;
                    this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Description of a LABEL object positioned to the left of the object.");
                    this.references.increment(string11);
                    return string11;
                }
                if (n13 >= n11 || n12 > n10 || n10 > n12 + n14) continue;
                string10 = accessibleContext5.getAccessibleName();
                if (null != string10) {
                    this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Name of a LABEL object positioned above the object.");
                    this.references.increment(string10);
                    return string10;
                }
                string11 = accessibleContext5.getAccessibleDescription();
                if (null == string11) continue;
                this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Description of a LABEL object positioned above the object.");
                this.references.increment(string11);
                return string11;
            }
            for (n = n4 + 1; n <= n5; ++n) {
                accessible = accessibleContext2.getAccessibleChild(n);
                if (null == accessible || null == (accessibleContext5 = accessible.getAccessibleContext()) || AccessibleRole.LABEL != (accessibleRole3 = accessibleContext5.getAccessibleRole())) continue;
                n12 = this.getAccessibleXcoordFromContext(accessibleContext5);
                n13 = this.getAccessibleYcoordFromContext(accessibleContext5);
                n14 = this.getAccessibleWidthFromContext(accessibleContext5);
                n15 = this.getAccessibleHeightFromContext(accessibleContext5);
                if (n12 < n6 && n13 <= n11 && n11 <= n13 + n15) {
                    string10 = accessibleContext5.getAccessibleName();
                    if (null != string10) {
                        this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Name of a LABEL object positioned to the left of the object.");
                        this.references.increment(string10);
                        return string10;
                    }
                    string11 = accessibleContext5.getAccessibleDescription();
                    if (null == string11) continue;
                    this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Description of a LABEL object positioned to the left of the object.");
                    this.references.increment(string11);
                    return string11;
                }
                if (n13 >= n11 || n12 > n10 || n10 > n12 + n14) continue;
                string10 = accessibleContext5.getAccessibleName();
                if (null != string10) {
                    this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Name of a LABEL object positioned above the object.");
                    this.references.increment(string10);
                    return string10;
                }
                string11 = accessibleContext5.getAccessibleDescription();
                if (null == string11) continue;
                this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Description of a LABEL object positioned above the object.");
                this.references.increment(string11);
                return string11;
            }
            if (AccessibleRole.TEXT == accessibleRole || AccessibleRole.COMBO_BOX == accessibleRole || bl2) {
                for (n = n4 - 1; n >= 0; --n) {
                    accessible = accessibleContext2.getAccessibleChild(n);
                    if (null == accessible || null == (accessibleContext5 = accessible.getAccessibleContext()) || AccessibleRole.PUSH_BUTTON != (accessibleRole3 = accessibleContext5.getAccessibleRole()) && AccessibleRole.TOGGLE_BUTTON != accessibleRole3) continue;
                    n12 = this.getAccessibleXcoordFromContext(accessibleContext5);
                    n13 = this.getAccessibleYcoordFromContext(accessibleContext5);
                    n14 = this.getAccessibleWidthFromContext(accessibleContext5);
                    n15 = this.getAccessibleHeightFromContext(accessibleContext5);
                    if (n12 >= n6 || n13 > n11 || n11 > n13 + n15) continue;
                    string10 = accessibleContext5.getAccessibleName();
                    if (null != string10) {
                        this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Name of a PUSH_BUTTON or TOGGLE_BUTTON object positioned to the left of the object.");
                        this.references.increment(string10);
                        return string10;
                    }
                    string11 = accessibleContext5.getAccessibleDescription();
                    if (null == string11) continue;
                    this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Description of a PUSH_BUTTON or TOGGLE_BUTTON object positioned to the left of the object.");
                    this.references.increment(string11);
                    return string11;
                }
                for (n = n4 + 1; n <= n5; ++n) {
                    accessible = accessibleContext2.getAccessibleChild(n);
                    if (null == accessible || null == (accessibleContext5 = accessible.getAccessibleContext()) || AccessibleRole.PUSH_BUTTON != (accessibleRole3 = accessibleContext5.getAccessibleRole()) && AccessibleRole.TOGGLE_BUTTON != accessibleRole3) continue;
                    n12 = this.getAccessibleXcoordFromContext(accessibleContext5);
                    n13 = this.getAccessibleYcoordFromContext(accessibleContext5);
                    n14 = this.getAccessibleWidthFromContext(accessibleContext5);
                    n15 = this.getAccessibleHeightFromContext(accessibleContext5);
                    if (n12 >= n6 || n13 > n11 || n11 > n13 + n15) continue;
                    string10 = accessibleContext5.getAccessibleName();
                    if (null != string10) {
                        this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Name of a PUSH_BUTTON or TOGGLE_BUTTON object positioned to the left of the object.");
                        this.references.increment(string10);
                        return string10;
                    }
                    string11 = accessibleContext5.getAccessibleDescription();
                    if (null == string11) continue;
                    this.debugString("bk -- The Virtual Accessible Name was obtained from Accessible Description of a PUSH_BUTTON or TOGGLE_BUTTON object positioned to the left of the object.");
                    this.references.increment(string11);
                    return string11;
                }
            }
            return null;
        }
        this.debugString("AccessBridge::getVirtualAccessibleNameFromContext error - ac == null.");
        return null;
    }

    public String getAccessibleDescriptionFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            String string = accessibleContext.getAccessibleDescription();
            if (string != null) {
                this.references.increment(string);
                this.debugString("Returning AccessibleDescription from Context: " + string);
                return string;
            }
        } else {
            this.debugString("getAccessibleDescriptionFromContext; ac = null");
        }
        return null;
    }

    public String getAccessibleRoleStringFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            String string;
            AccessibleRole accessibleRole = accessibleContext.getAccessibleRole();
            if (accessibleRole != null && (string = accessibleRole.toDisplayString(Locale.US)) != null) {
                this.references.increment(string);
                this.debugString("Returning AccessibleRole from Context: " + string);
                return string;
            }
        } else {
            this.debugString("getAccessibleRoleStringFromContext; ac = null");
        }
        return null;
    }

    public String getAccessibleRoleStringFromContext_en_US(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            String string;
            AccessibleRole accessibleRole = accessibleContext.getAccessibleRole();
            if (accessibleRole != null && (string = accessibleRole.toDisplayString(Locale.US)) != null) {
                this.references.increment(string);
                this.debugString("Returning AccessibleRole in en_US from Context: " + string);
                return string;
            }
        } else {
            this.debugString("getAccessibleRoleStringFromContext; ac = null");
        }
        return null;
    }

    public String getAccessibleStatesStringFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            String string;
            AccessibleStateSet accessibleStateSet = accessibleContext.getAccessibleStateSet();
            if (accessibleStateSet != null && (string = accessibleStateSet.toString()) != null && string.indexOf(_AccessibleState.MANAGES_DESCENDANTS.toDisplayString(Locale.US)) == -1) {
                AccessibleRole accessibleRole = accessibleContext.getAccessibleRole();
                if (accessibleRole == AccessibleRole.LIST || accessibleRole == AccessibleRole.TABLE || accessibleRole == AccessibleRole.TREE) {
                    string = string + ",";
                    string = string + _AccessibleState.MANAGES_DESCENDANTS.toDisplayString(Locale.US);
                }
                this.references.increment(string);
                this.debugString("Returning AccessibleStateSet from Context: " + string);
                return string;
            }
        } else {
            this.debugString("getAccessibleStatesStringFromContext; ac = null");
        }
        return null;
    }

    public String getAccessibleStatesStringFromContext_en_US(AccessibleContext accessibleContext) {
        AccessibleStateSet accessibleStateSet;
        if (accessibleContext != null && (accessibleStateSet = accessibleContext.getAccessibleStateSet()) != null) {
            String string = "";
            AccessibleState[] accessibleStateArray = accessibleStateSet.toArray();
            if (accessibleStateArray != null && accessibleStateArray.length > 0) {
                string = accessibleStateArray[0].toDisplayString(Locale.US);
                for (int i = 1; i < accessibleStateArray.length; ++i) {
                    string = string + "," + accessibleStateArray[i].toDisplayString(Locale.US);
                }
            }
            this.references.increment(string);
            this.debugString("Returning AccessibleStateSet en_US from Context: " + string);
            return string;
        }
        this.debugString("getAccessibleStatesStringFromContext; ac = null");
        return null;
    }

    public AccessibleContext getAccessibleParentFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            AccessibleContext accessibleContext2;
            Accessible accessible = accessibleContext.getAccessibleParent();
            if (accessible != null && (accessibleContext2 = accessible.getAccessibleContext()) != null) {
                this.debugString("Returning AccessibleParent from Context");
                return accessibleContext2;
            }
        } else {
            this.debugString("getAccessibleParentFromContext; ac = null");
        }
        return null;
    }

    public int getAccessibleIndexInParentFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            this.debugString("Returning Accessible IndexInParent from Context: " + accessibleContext.getAccessibleIndexInParent());
            return accessibleContext.getAccessibleIndexInParent();
        }
        this.debugString("AccessibleIndexInParent; ac = null");
        return -1;
    }

    public int getAccessibleChildrenCountFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            this.debugString("Returning Accessible ChildrenCount from Context: " + accessibleContext.getAccessibleChildrenCount());
            return accessibleContext.getAccessibleChildrenCount();
        }
        this.debugString("getAccessibleChildrenCountFromContext; ac = null");
        return -1;
    }

    public AccessibleContext getAccessibleChildFromContext(AccessibleContext accessibleContext, int n) {
        Accessible accessible;
        if (accessibleContext == null) {
            return null;
        }
        Accessible accessible2 = accessibleContext.getAccessibleParent();
        if (accessible2 instanceof Accessible) {
            int n2 = accessibleContext.getAccessibleIndexInParent();
            Accessible accessible3 = accessible2.getAccessibleContext().getAccessibleChild(n2);
            if (accessible3 instanceof JTable) {
                Serializable serializable;
                int n3;
                JTable jTable = (JTable)accessible3;
                AccessibleTable accessibleTable = jTable.getAccessibleContext().getAccessibleTable();
                int n4 = this.getAccessibleTableRow(accessibleTable, n);
                TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n4, n3 = this.getAccessibleTableColumn(accessibleTable, n));
                if (tableCellRenderer == null) {
                    serializable = jTable.getColumnClass(n3);
                    tableCellRenderer = jTable.getDefaultRenderer((Class<?>)serializable);
                }
                if ((serializable = tableCellRenderer.getTableCellRendererComponent(jTable, jTable.getValueAt(n4, n3), false, false, n4, n3)) instanceof Accessible) {
                    return ((Accessible)((Object)serializable)).getAccessibleContext();
                }
            }
        }
        if ((accessible = accessibleContext.getAccessibleChild(n)) != null) {
            return accessible.getAccessibleContext();
        }
        return null;
    }

    public Rectangle getAccessibleBoundsOnScreenFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            Rectangle rectangle;
            AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
            if (accessibleComponent != null && (rectangle = accessibleComponent.getBounds()) != null) {
                try {
                    Point point = accessibleComponent.getLocationOnScreen();
                    if (point != null) {
                        rectangle.x = point.x;
                        rectangle.y = point.y;
                        return rectangle;
                    }
                }
                catch (Exception exception) {
                    this.debugString("*** Caught EXCEPTION in getAccessibleBoundsOnScreenFromContext: " + exception.toString());
                }
            }
        } else {
            this.debugString("getAccessibleBoundsOnScreenFromContext; ac = null");
        }
        return null;
    }

    public int getAccessibleXcoordFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            Rectangle rectangle = this.getAccessibleBoundsOnScreenFromContext(accessibleContext);
            if (rectangle != null) {
                this.debugString(" - Returning Accessible x coord from Context: " + rectangle.x);
                return rectangle.x;
            }
        } else {
            this.debugString("getAccessibleXcoordFromContext ac = null");
        }
        return -1;
    }

    public int getAccessibleYcoordFromContext(AccessibleContext accessibleContext) {
        this.debugString("getAccessibleYcoordFromContext() called");
        if (accessibleContext != null) {
            Rectangle rectangle = this.getAccessibleBoundsOnScreenFromContext(accessibleContext);
            if (rectangle != null) {
                return rectangle.y;
            }
        } else {
            this.debugString("getAccessibleYcoordFromContext; ac = null");
        }
        return -1;
    }

    public int getAccessibleHeightFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            Rectangle rectangle = this.getAccessibleBoundsOnScreenFromContext(accessibleContext);
            if (rectangle != null) {
                return rectangle.height;
            }
        } else {
            this.debugString("getAccessibleHeightFromContext; ac = null");
        }
        return -1;
    }

    public int getAccessibleWidthFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            Rectangle rectangle = this.getAccessibleBoundsOnScreenFromContext(accessibleContext);
            if (rectangle != null) {
                return rectangle.width;
            }
        } else {
            this.debugString("getAccessibleWidthFromContext; ac = null");
        }
        return -1;
    }

    public AccessibleComponent getAccessibleComponentFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
            if (accessibleComponent != null) {
                this.debugString("Returning AccessibleComponent Context");
                return accessibleComponent;
            }
        } else {
            this.debugString("getAccessibleComponentFromContext; ac = null");
        }
        return null;
    }

    public AccessibleAction getAccessibleActionFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            AccessibleAction accessibleAction = accessibleContext.getAccessibleAction();
            if (accessibleAction != null) {
                this.debugString("Returning AccessibleAction Context");
                return accessibleAction;
            }
        } else {
            this.debugString("getAccessibleActionFromContext; ac = null");
        }
        return null;
    }

    public AccessibleSelection getAccessibleSelectionFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            AccessibleSelection accessibleSelection = accessibleContext.getAccessibleSelection();
            if (accessibleSelection != null) {
                this.debugString("returning AccessibleSelection Context=" + accessibleSelection.getClass());
                return accessibleSelection;
            }
        } else {
            this.debugString("getAccessibleSelectionFromContext; ac = null");
        }
        return null;
    }

    public AccessibleText getAccessibleTextFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            AccessibleText accessibleText = accessibleContext.getAccessibleText();
            if (accessibleText != null) {
                this.debugString("Returning AccessibleText Context");
                return accessibleText;
            }
        } else {
            this.debugString("getAccessibleTextFromContext; ac = null");
        }
        return null;
    }

    public AccessibleValue getAccessibleValueFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            AccessibleValue accessibleValue = accessibleContext.getAccessibleValue();
            if (accessibleValue != null) {
                this.debugString("Returning AccessibleValue Context");
                return accessibleValue;
            }
        } else {
            this.debugString("getAccessibleValueFromContext; ac = null");
        }
        return null;
    }

    public Rectangle getCaretLocation(AccessibleContext accessibleContext) {
        this.debugString("getCaretLocation");
        Rectangle rectangle = null;
        if (accessibleContext != null) {
            Accessible accessible = accessibleContext.getAccessibleParent();
            this.debugString("  parent = " + accessible.getClass());
            if (accessible instanceof Accessible) {
                int n = accessibleContext.getAccessibleIndexInParent();
                this.debugString("  indexInParent = " + n);
                Accessible accessible2 = accessible.getAccessibleContext().getAccessibleChild(n);
                if (accessible2 instanceof JTextComponent) {
                    JTextComponent jTextComponent = (JTextComponent)accessible2;
                    try {
                        rectangle = jTextComponent.modelToView(jTextComponent.getCaretPosition());
                        if (rectangle != null) {
                            Point point = jTextComponent.getLocationOnScreen();
                            rectangle.translate(point.x, point.y);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        // empty catch block
                    }
                }
            }
        }
        this.debugString("  returning = " + rectangle);
        return rectangle;
    }

    public int getCaretLocationX(AccessibleContext accessibleContext) {
        Rectangle rectangle = this.getCaretLocation(accessibleContext);
        if (rectangle != null) {
            return rectangle.x;
        }
        return -1;
    }

    public int getCaretLocationY(AccessibleContext accessibleContext) {
        Rectangle rectangle = this.getCaretLocation(accessibleContext);
        if (rectangle != null) {
            return rectangle.y;
        }
        return -1;
    }

    public int getCaretLocationHeight(AccessibleContext accessibleContext) {
        Rectangle rectangle = this.getCaretLocation(accessibleContext);
        if (rectangle != null) {
            return rectangle.height;
        }
        return -1;
    }

    public int getCaretLocationWidth(AccessibleContext accessibleContext) {
        Rectangle rectangle = this.getCaretLocation(accessibleContext);
        if (rectangle != null) {
            return rectangle.width;
        }
        return -1;
    }

    public int getAccessibleCharCountFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            AccessibleText accessibleText = accessibleContext.getAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getCharCount();
            }
        } else {
            this.debugString("getAccessibleCharCountFromContext; ac = null");
        }
        return -1;
    }

    public int getAccessibleCaretPositionFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            AccessibleText accessibleText = accessibleContext.getAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getCaretPosition();
            }
        } else {
            this.debugString("getAccessibleCaretPositionFromContext; ac = null");
        }
        return -1;
    }

    public int getAccessibleIndexAtPointFromContext(AccessibleContext accessibleContext, int n, int n2) {
        this.debugString("getAccessibleIndexAtPointFromContext: x = " + n + "; y = " + n2);
        if (accessibleContext != null) {
            AccessibleText accessibleText = accessibleContext.getAccessibleText();
            AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
            if (accessibleText != null && accessibleComponent != null) {
                try {
                    Point point = accessibleComponent.getLocationOnScreen();
                    this.debugString("  getLocationOnScreen = " + point);
                    if (point != null) {
                        if ((n -= point.x) < 0) {
                            n = 0;
                        }
                        if ((n2 -= point.y) < 0) {
                            n2 = 0;
                        }
                        Point point2 = new Point(n, n2);
                        this.debugString("  newPoint = " + point2);
                        int n3 = accessibleText.getIndexAtPoint(new Point(n, n2));
                        this.debugString("  indexAtPoint = " + n3);
                        return n3;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.debugString("  returning -1");
        return -1;
    }

    public String getAccessibleLetterAtIndexFromContext(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            String string;
            AccessibleText accessibleText = accessibleContext.getAccessibleText();
            if (accessibleText != null && (string = accessibleText.getAtIndex(1, n)) != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getAccessibleLetterAtIndexFromContext; ac = null");
        }
        return null;
    }

    public String getAccessibleWordAtIndexFromContext(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            String string;
            AccessibleText accessibleText = accessibleContext.getAccessibleText();
            if (accessibleText != null && (string = accessibleText.getAtIndex(2, n)) != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getAccessibleWordAtIndexFromContext; ac = null");
        }
        return null;
    }

    public String getAccessibleSentenceAtIndexFromContext(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            String string;
            AccessibleText accessibleText = accessibleContext.getAccessibleText();
            if (accessibleText != null && (string = accessibleText.getAtIndex(3, n)) != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getAccessibleSentenceAtIndexFromContext; ac = null");
        }
        return null;
    }

    public int getAccessibleTextSelectionStartFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            AccessibleText accessibleText = accessibleContext.getAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getSelectionStart();
            }
        } else {
            this.debugString("getAccessibleTextSelectionStartFromContext; ac = null");
        }
        return -1;
    }

    public int getAccessibleTextSelectionEndFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            AccessibleText accessibleText = accessibleContext.getAccessibleText();
            if (accessibleText != null) {
                return accessibleText.getSelectionEnd();
            }
        } else {
            this.debugString("getAccessibleTextSelectionEndFromContext; ac = null");
        }
        return -1;
    }

    public String getAccessibleTextSelectedTextFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            String string;
            AccessibleText accessibleText = accessibleContext.getAccessibleText();
            if (accessibleText != null && (string = accessibleText.getSelectedText()) != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getAccessibleTextSelectedTextFromContext; ac = null");
        }
        return null;
    }

    public String getAccessibleAttributesAtIndexFromContext(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            AttributeSet attributeSet;
            String string;
            AccessibleText accessibleText = accessibleContext.getAccessibleText();
            if (accessibleText != null && (string = this.expandStyleConstants(attributeSet = accessibleText.getCharacterAttribute(n))) != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getAccessibleAttributesAtIndexFromContext; ac = null");
        }
        return null;
    }

    public int getAccessibleTextLineLeftBoundsFromContext(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            AccessibleText accessibleText = accessibleContext.getAccessibleText();
            if (accessibleText != null) {
                Rectangle rectangle = accessibleText.getCharacterBounds(n);
                int n2 = accessibleText.getCharCount();
                if (rectangle == null) {
                    return -1;
                }
                int n3 = 1;
                int n4 = n - n3 < 0 ? 0 : n - n3;
                Rectangle rectangle2 = accessibleText.getCharacterBounds(n4);
                while (rectangle2 != null && rectangle2.y >= rectangle.y && n4 > 0) {
                    n4 = n - (n3 <<= 1) < 0 ? 0 : n - n3;
                    rectangle2 = accessibleText.getCharacterBounds(n4);
                }
                if (n4 != 0) {
                    n3 >>= 1;
                    while (n3 > 0) {
                        rectangle2 = accessibleText.getCharacterBounds(n4 + n3);
                        if (rectangle2.y < rectangle.y) {
                            n4 += n3;
                        }
                        n3 >>= 1;
                    }
                    ++n4;
                }
                return n4;
            }
        } else {
            this.debugString("getAccessibleTextLineLeftBoundsFromContext; ac = null");
        }
        return -1;
    }

    public int getAccessibleTextLineRightBoundsFromContext(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            AccessibleText accessibleText = accessibleContext.getAccessibleText();
            if (accessibleText != null) {
                Rectangle rectangle = accessibleText.getCharacterBounds(n);
                int n2 = accessibleText.getCharCount();
                if (rectangle == null) {
                    return -1;
                }
                int n3 = 1;
                int n4 = n + n3 > n2 - 1 ? n2 - 1 : n + n3;
                Rectangle rectangle2 = accessibleText.getCharacterBounds(n4);
                while (rectangle2 != null && rectangle2.y <= rectangle.y && n4 < n2 - 1) {
                    n4 = n + (n3 <<= 1) > n2 - 1 ? n2 - 1 : n + n3;
                    rectangle2 = accessibleText.getCharacterBounds(n4);
                }
                if (n4 != n2 - 1) {
                    n3 >>= 1;
                    while (n3 > 0) {
                        rectangle2 = accessibleText.getCharacterBounds(n4 - n3);
                        if (rectangle2.y > rectangle.y) {
                            n4 -= n3;
                        }
                        n3 >>= 1;
                    }
                    --n4;
                }
                return n4;
            }
        } else {
            this.debugString("getAccessibleTextLineRightBoundsFromContext; ac = null");
        }
        return -1;
    }

    public String getAccessibleTextRangeFromContext(AccessibleContext accessibleContext, int n, int n2) {
        if (accessibleContext != null) {
            AccessibleText accessibleText = accessibleContext.getAccessibleText();
            if (accessibleText != null) {
                if (n > n2) {
                    return null;
                }
                if (n2 >= accessibleText.getCharCount()) {
                    return null;
                }
                StringBuffer stringBuffer = new StringBuffer(n2 - n + 1);
                for (int i = n; i <= n2; ++i) {
                    stringBuffer.append(accessibleText.getAtIndex(1, i));
                }
                String string = stringBuffer.toString();
                if (string != null) {
                    this.references.increment(string);
                    return string;
                }
            }
        } else {
            this.debugString("getAccessibleTextRangeFromContext; ac = null");
        }
        return null;
    }

    public AttributeSet getAccessibleAttributeSetAtIndexFromContext(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            AttributeSet attributeSet;
            AccessibleText accessibleText = accessibleContext.getAccessibleText();
            if (accessibleText != null && (attributeSet = accessibleText.getCharacterAttribute(n)) != null) {
                this.references.increment(attributeSet);
                return attributeSet;
            }
        } else {
            this.debugString("getAccessibleAttributeSetAtIndexFromContext; ac = null");
        }
        return null;
    }

    public Rectangle getAccessibleTextRectAtIndexFromContext(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            Rectangle rectangle;
            AccessibleText accessibleText = accessibleContext.getAccessibleText();
            if (accessibleText != null && (rectangle = accessibleText.getCharacterBounds(n)) != null) {
                Rectangle rectangle2;
                String string = accessibleText.getAtIndex(1, n);
                if (string != null && string.equals("\n")) {
                    rectangle.width = 0;
                }
                if ((rectangle2 = this.getAccessibleBoundsOnScreenFromContext(accessibleContext)) != null) {
                    rectangle.translate(rectangle2.x, rectangle2.y);
                    return rectangle;
                }
            }
        } else {
            this.debugString("getAccessibleTextRectAtIndexFromContext; ac = null");
        }
        return null;
    }

    public int getAccessibleXcoordTextRectAtIndexFromContext(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            Rectangle rectangle = this.getAccessibleTextRectAtIndexFromContext(accessibleContext, n);
            if (rectangle != null) {
                return rectangle.x;
            }
        } else {
            this.debugString("getAccessibleXcoordTextRectAtIndexFromContext; ac = null");
        }
        return -1;
    }

    public int getAccessibleYcoordTextRectAtIndexFromContext(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            Rectangle rectangle = this.getAccessibleTextRectAtIndexFromContext(accessibleContext, n);
            if (rectangle != null) {
                return rectangle.y;
            }
        } else {
            this.debugString("getAccessibleYcoordTextRectAtIndexFromContext; ac = null");
        }
        return -1;
    }

    public int getAccessibleHeightTextRectAtIndexFromContext(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            Rectangle rectangle = this.getAccessibleTextRectAtIndexFromContext(accessibleContext, n);
            if (rectangle != null) {
                return rectangle.height;
            }
        } else {
            this.debugString("getAccessibleHeightTextRectAtIndexFromContext; ac = null");
        }
        return -1;
    }

    public int getAccessibleWidthTextRectAtIndexFromContext(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            Rectangle rectangle = this.getAccessibleTextRectAtIndexFromContext(accessibleContext, n);
            if (rectangle != null) {
                return rectangle.width;
            }
        } else {
            this.debugString("getAccessibleWidthTextRectAtIndexFromContext; ac = null");
        }
        return -1;
    }

    public boolean getBoldFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.isBold(attributeSet);
        }
        this.debugString("getBoldFromAttributeSet; as = null");
        return false;
    }

    public boolean getItalicFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.isItalic(attributeSet);
        }
        this.debugString("getItalicFromAttributeSet; as = null");
        return false;
    }

    public boolean getUnderlineFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.isUnderline(attributeSet);
        }
        this.debugString("getUnderlineFromAttributeSet; as = null");
        return false;
    }

    public boolean getStrikethroughFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.isStrikeThrough(attributeSet);
        }
        this.debugString("getStrikethroughFromAttributeSet; as = null");
        return false;
    }

    public boolean getSuperscriptFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.isSuperscript(attributeSet);
        }
        this.debugString("getSuperscriptFromAttributeSet; as = null");
        return false;
    }

    public boolean getSubscriptFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.isSubscript(attributeSet);
        }
        this.debugString("getSubscriptFromAttributeSet; as = null");
        return false;
    }

    public String getBackgroundColorFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            String string = StyleConstants.getBackground(attributeSet).toString();
            if (string != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getBackgroundColorFromAttributeSet; as = null");
        }
        return null;
    }

    public String getForegroundColorFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            String string = StyleConstants.getForeground(attributeSet).toString();
            if (string != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getForegroundColorFromAttributeSet; as = null");
        }
        return null;
    }

    public String getFontFamilyFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            String string = StyleConstants.getFontFamily(attributeSet).toString();
            if (string != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getFontFamilyFromAttributeSet; as = null");
        }
        return null;
    }

    public int getFontSizeFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.getFontSize(attributeSet);
        }
        this.debugString("getFontSizeFromAttributeSet; as = null");
        return -1;
    }

    public int getAlignmentFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.getAlignment(attributeSet);
        }
        this.debugString("getAlignmentFromAttributeSet; as = null");
        return -1;
    }

    public int getBidiLevelFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.getBidiLevel(attributeSet);
        }
        this.debugString("getBidiLevelFromAttributeSet; as = null");
        return -1;
    }

    public float getFirstLineIndentFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.getFirstLineIndent(attributeSet);
        }
        this.debugString("getFirstLineIndentFromAttributeSet; as = null");
        return -1.0f;
    }

    public float getLeftIndentFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.getLeftIndent(attributeSet);
        }
        this.debugString("getLeftIndentFromAttributeSet; as = null");
        return -1.0f;
    }

    public float getRightIndentFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.getRightIndent(attributeSet);
        }
        this.debugString("getRightIndentFromAttributeSet; as = null");
        return -1.0f;
    }

    public float getLineSpacingFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.getLineSpacing(attributeSet);
        }
        this.debugString("getLineSpacingFromAttributeSet; as = null");
        return -1.0f;
    }

    public float getSpaceAboveFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.getSpaceAbove(attributeSet);
        }
        this.debugString("getSpaceAboveFromAttributeSet; as = null");
        return -1.0f;
    }

    public float getSpaceBelowFromAttributeSet(AttributeSet attributeSet) {
        if (attributeSet != null) {
            return StyleConstants.getSpaceBelow(attributeSet);
        }
        this.debugString("getSpaceBelowFromAttributeSet; as = null");
        return -1.0f;
    }

    private String expandStyleConstants(AttributeSet attributeSet) {
        Color color;
        Object object;
        String string = new String("");
        string = string + "BidiLevel = " + StyleConstants.getBidiLevel(attributeSet);
        Component component = StyleConstants.getComponent(attributeSet);
        if (component != null) {
            string = component instanceof Accessible ? ((object = ((Accessible)((Object)component)).getAccessibleContext()) != null ? string + "; Accessible Component = " + ((AccessibleContext)object).getAccessibleName() : string + "; Innaccessible Component = " + component) : string + "; Innaccessible Component = " + component;
        }
        if ((object = StyleConstants.getIcon(attributeSet)) != null) {
            string = object instanceof ImageIcon ? string + "; ImageIcon = " + ((ImageIcon)object).getDescription() : string + "; Icon = " + object;
        }
        string = string + "; FontFamily = " + StyleConstants.getFontFamily(attributeSet);
        string = string + "; FontSize = " + StyleConstants.getFontSize(attributeSet);
        if (StyleConstants.isBold(attributeSet)) {
            string = string + "; bold";
        }
        if (StyleConstants.isItalic(attributeSet)) {
            string = string + "; italic";
        }
        if (StyleConstants.isUnderline(attributeSet)) {
            string = string + "; underline";
        }
        if (StyleConstants.isStrikeThrough(attributeSet)) {
            string = string + "; strikethrough";
        }
        if (StyleConstants.isSuperscript(attributeSet)) {
            string = string + "; superscript";
        }
        if (StyleConstants.isSubscript(attributeSet)) {
            string = string + "; subscript";
        }
        if ((color = StyleConstants.getForeground(attributeSet)) != null) {
            string = string + "; Foreground = " + color;
        }
        if ((color = StyleConstants.getBackground(attributeSet)) != null) {
            string = string + "; Background = " + color;
        }
        string = string + "; FirstLineIndent = " + StyleConstants.getFirstLineIndent(attributeSet);
        string = string + "; RightIndent = " + StyleConstants.getRightIndent(attributeSet);
        string = string + "; LeftIndent = " + StyleConstants.getLeftIndent(attributeSet);
        string = string + "; LineSpacing = " + StyleConstants.getLineSpacing(attributeSet);
        string = string + "; SpaceAbove = " + StyleConstants.getSpaceAbove(attributeSet);
        string = string + "; SpaceBelow = " + StyleConstants.getSpaceBelow(attributeSet);
        string = string + "; Alignment = " + StyleConstants.getAlignment(attributeSet);
        TabSet tabSet = StyleConstants.getTabSet(attributeSet);
        if (tabSet != null) {
            string = string + "; TabSet = " + tabSet;
        }
        return string;
    }

    String getCurrentAccessibleValueFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            String string;
            Number number;
            AccessibleValue accessibleValue = accessibleContext.getAccessibleValue();
            if (accessibleValue != null && (number = accessibleValue.getCurrentAccessibleValue()) != null && (string = number.toString()) != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getCurrentAccessibleValueFromContext; ac = null");
        }
        return null;
    }

    String getMaximumAccessibleValueFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            String string;
            Number number;
            AccessibleValue accessibleValue = accessibleContext.getAccessibleValue();
            if (accessibleValue != null && (number = accessibleValue.getMaximumAccessibleValue()) != null && (string = number.toString()) != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getMaximumAccessibleValueFromContext; ac = null");
        }
        return null;
    }

    String getMinimumAccessibleValueFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            String string;
            Number number;
            AccessibleValue accessibleValue = accessibleContext.getAccessibleValue();
            if (accessibleValue != null && (number = accessibleValue.getMinimumAccessibleValue()) != null && (string = number.toString()) != null) {
                this.references.increment(string);
                return string;
            }
        } else {
            this.debugString("getMinimumAccessibleValueFromContext; ac = null");
        }
        return null;
    }

    void addAccessibleSelectionFromContext(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            AccessibleSelection accessibleSelection = accessibleContext.getAccessibleSelection();
            if (accessibleSelection != null) {
                accessibleSelection.addAccessibleSelection(n);
            }
        } else {
            this.debugString("addAccessibleSelectionFromContext; ac = null");
        }
    }

    void clearAccessibleSelectionFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            AccessibleSelection accessibleSelection = accessibleContext.getAccessibleSelection();
            if (accessibleSelection != null) {
                accessibleSelection.clearAccessibleSelection();
            }
        } else {
            this.debugString("clearAccessibleSelectionFromContext; ac = null");
        }
    }

    AccessibleContext getAccessibleSelectionFromContext(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            Accessible accessible;
            AccessibleSelection accessibleSelection = accessibleContext.getAccessibleSelection();
            if (accessibleSelection != null && (accessible = accessibleSelection.getAccessibleSelection(n)) != null) {
                return accessible.getAccessibleContext();
            }
        } else {
            this.debugString("getAccessibleSelectionFromContext; ac = null");
        }
        return null;
    }

    int getAccessibleSelectionCountFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            AccessibleSelection accessibleSelection = accessibleContext.getAccessibleSelection();
            if (accessibleSelection != null) {
                return accessibleSelection.getAccessibleSelectionCount();
            }
        } else {
            this.debugString("getAccessibleSelectionFromContext; ac = null");
        }
        return -1;
    }

    boolean isAccessibleChildSelectedFromContext(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            AccessibleSelection accessibleSelection = accessibleContext.getAccessibleSelection();
            if (accessibleSelection != null) {
                return accessibleSelection.isAccessibleChildSelected(n);
            }
        } else {
            this.debugString("isAccessibleChildSelectedFromContext; ac = null");
        }
        return false;
    }

    void removeAccessibleSelectionFromContext(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            AccessibleSelection accessibleSelection = accessibleContext.getAccessibleSelection();
            if (accessibleSelection != null) {
                accessibleSelection.removeAccessibleSelection(n);
            }
        } else {
            this.debugString("removeAccessibleSelectionFromContext; ac = null");
        }
    }

    void selectAllAccessibleSelectionFromContext(AccessibleContext accessibleContext) {
        if (accessibleContext != null) {
            AccessibleSelection accessibleSelection = accessibleContext.getAccessibleSelection();
            if (accessibleSelection != null) {
                accessibleSelection.selectAllAccessibleSelection();
            }
        } else {
            this.debugString("selectAllAccessibleSelectionFromContext; ac = null");
        }
    }

    public AccessibleTable getAccessibleTableFromContext(AccessibleContext accessibleContext) {
        AccessibleTable accessibleTable;
        String string = this.getJavaVersionProperty();
        if (string != null && string.compareTo("1.3") >= 0 && accessibleContext != null && (accessibleTable = accessibleContext.getAccessibleTable()) != null) {
            this.hashtab.put(accessibleTable, accessibleContext);
            return accessibleTable;
        }
        return null;
    }

    public AccessibleContext getContextFromAccessibleTable(AccessibleTable accessibleTable) {
        Object v = this.hashtab.get(accessibleTable);
        if (v instanceof AccessibleContext) {
            return (AccessibleContext)v;
        }
        return null;
    }

    public int getAccessibleTableRowCount(AccessibleContext accessibleContext) {
        AccessibleTable accessibleTable;
        this.debugString("##### getAccessibleTableRowCount");
        if (accessibleContext != null && (accessibleTable = accessibleContext.getAccessibleTable()) != null) {
            int n = accessibleTable.getAccessibleRowCount();
            this.debugString("   ##### getAccessibleTableRowCount=" + n);
            return n;
        }
        this.debugString("   ##### getAccessibleTableRowCount FAILED");
        return -1;
    }

    public int getAccessibleTableColumnCount(AccessibleContext accessibleContext) {
        AccessibleTable accessibleTable;
        this.debugString("##### getAccessibleTableColumnCount");
        if (accessibleContext != null && (accessibleTable = accessibleContext.getAccessibleTable()) != null) {
            int n = accessibleTable.getAccessibleColumnCount();
            this.debugString("   ##### getAccessibleTableColumnCount=" + n);
            return n;
        }
        this.debugString(" ##### getAccessibleTableColumnCount FAILED");
        return -1;
    }

    public AccessibleContext getAccessibleTableCellAccessibleContext(AccessibleTable accessibleTable, int n, int n2) {
        this.debugString("getAccessibleTableCellAccessibleContext: at = " + accessibleTable.getClass());
        if (accessibleTable == null) {
            return null;
        }
        if (!(accessibleTable instanceof AccessibleContext)) {
            Accessible accessible = accessibleTable.getAccessibleAt(n, n2);
            if (accessible != null) {
                return accessible.getAccessibleContext();
            }
        } else {
            AccessibleContext accessibleContext = (AccessibleContext)((Object)accessibleTable);
            Accessible accessible = accessibleContext.getAccessibleParent();
            if (accessible instanceof Accessible) {
                int n3 = accessibleContext.getAccessibleIndexInParent();
                Accessible accessible2 = accessible.getAccessibleContext().getAccessibleChild(n3);
                if (accessible2 instanceof JTable) {
                    Serializable serializable;
                    JTable jTable = (JTable)accessible2;
                    TableCellRenderer tableCellRenderer = jTable.getCellRenderer(n, n2);
                    if (tableCellRenderer == null) {
                        serializable = jTable.getColumnClass(n2);
                        tableCellRenderer = jTable.getDefaultRenderer((Class<?>)serializable);
                    }
                    if ((serializable = tableCellRenderer.getTableCellRendererComponent(jTable, jTable.getValueAt(n, n2), false, false, n, n2)) instanceof Accessible) {
                        this.debugString("getAccessibleTableCellAccessibleContext returning = " + serializable.getClass());
                        return ((Accessible)((Object)serializable)).getAccessibleContext();
                    }
                }
            }
        }
        return null;
    }

    public int getAccessibleTableCellIndex(AccessibleTable accessibleTable, int n, int n2) {
        this.debugString("##### getAccessibleTableCellIndex: at=" + accessibleTable);
        if (accessibleTable != null) {
            int n3 = n * accessibleTable.getAccessibleColumnCount() + n2;
            this.debugString("   ##### getAccessibleTableCellIndex=" + n3);
            return n3;
        }
        this.debugString(" ##### getAccessibleTableCellIndex FAILED");
        return -1;
    }

    public int getAccessibleTableCellRowExtent(AccessibleTable accessibleTable, int n, int n2) {
        this.debugString("##### getAccessibleTableCellRowExtent");
        if (accessibleTable != null) {
            int n3 = accessibleTable.getAccessibleRowExtentAt(n, n2);
            this.debugString("   ##### getAccessibleTableCellRowExtent=" + n3);
            return n3;
        }
        this.debugString(" ##### getAccessibleTableCellRowExtent FAILED");
        return -1;
    }

    public int getAccessibleTableCellColumnExtent(AccessibleTable accessibleTable, int n, int n2) {
        this.debugString("##### getAccessibleTableCellColumnExtent");
        if (accessibleTable != null) {
            int n3 = accessibleTable.getAccessibleColumnExtentAt(n, n2);
            this.debugString("   ##### getAccessibleTableCellColumnExtent=" + n3);
            return n3;
        }
        this.debugString(" ##### getAccessibleTableCellColumnExtent FAILED");
        return -1;
    }

    public boolean isAccessibleTableCellSelected(AccessibleTable accessibleTable, int n, int n2) {
        boolean bl = false;
        this.debugString("##### isAccessibleTableCellSelected: [" + n + "][" + n2 + "]");
        if (accessibleTable != null) {
            AccessibleContext accessibleContext;
            AccessibleStateSet accessibleStateSet;
            Accessible accessible = accessibleTable.getAccessibleAt(n, n2);
            if (accessible != null && (accessibleStateSet = (accessibleContext = accessible.getAccessibleContext()).getAccessibleStateSet()) != null) {
                bl = accessibleStateSet.contains(AccessibleState.SELECTED);
            }
            this.debugString(" ##### isAccessibleTableCellSelected=" + bl);
            return bl;
        }
        this.debugString(" ##### isAccessibleTableCellSelected FAILED");
        return false;
    }

    public AccessibleTable getAccessibleTableRowHeader(AccessibleContext accessibleContext) {
        AccessibleTable accessibleTable;
        this.debugString(" #####  getAccessibleTableRowHeader called");
        if (accessibleContext != null && (accessibleTable = accessibleContext.getAccessibleTable()) != null) {
            return accessibleTable.getAccessibleRowHeader();
        }
        this.debugString(" ##### getAccessibleTableRowHeader FAILED");
        return null;
    }

    public AccessibleTable getAccessibleTableColumnHeader(AccessibleContext accessibleContext) {
        this.debugString("##### getAccessibleTableColumnHeader");
        if (accessibleContext != null) {
            AccessibleTable accessibleTable;
            Accessible accessible = accessibleContext.getAccessibleParent();
            this.debugString("  parent = " + accessible.getClass());
            if (accessible instanceof Accessible) {
                JTable jTable;
                int n = accessibleContext.getAccessibleIndexInParent();
                this.debugString("  indexInParent = " + n);
                Accessible accessible2 = accessible.getAccessibleContext().getAccessibleChild(n);
                if (accessible2 instanceof JTable && (jTable = (JTable)accessible2).getTableHeader() == null) {
                    return null;
                }
            }
            if ((accessibleTable = accessibleContext.getAccessibleTable()) != null) {
                return accessibleTable.getAccessibleColumnHeader();
            }
        }
        this.debugString(" ##### getAccessibleTableColumnHeader FAILED");
        return null;
    }

    public int getAccessibleTableRowHeaderRowCount(AccessibleContext accessibleContext) {
        AccessibleTable accessibleTable;
        this.debugString(" #####  getAccessibleTableRowHeaderRowCount called");
        if (accessibleContext != null && (accessibleTable = this.getAccessibleTableRowHeader(accessibleContext)) != null) {
            return accessibleTable.getAccessibleRowCount();
        }
        this.debugString(" ##### getAccessibleTableRowHeaderRowCount FAILED");
        return -1;
    }

    public int getAccessibleTableRowHeaderColumnCount(AccessibleContext accessibleContext) {
        AccessibleTable accessibleTable;
        this.debugString(" #####  getAccessibleTableRowHeaderColumnCount called");
        if (accessibleContext != null && (accessibleTable = this.getAccessibleTableRowHeader(accessibleContext)) != null) {
            return accessibleTable.getAccessibleColumnCount();
        }
        this.debugString(" ##### getAccessibleTableRowHeaderColumnCount FAILED");
        return -1;
    }

    public int getAccessibleTableColumnHeaderRowCount(AccessibleContext accessibleContext) {
        AccessibleTable accessibleTable;
        this.debugString("##### getAccessibleTableColumnHeaderRowCount");
        if (accessibleContext != null && (accessibleTable = this.getAccessibleTableColumnHeader(accessibleContext)) != null) {
            return accessibleTable.getAccessibleRowCount();
        }
        this.debugString(" ##### getAccessibleTableColumnHeaderRowCount FAILED");
        return -1;
    }

    public int getAccessibleTableColumnHeaderColumnCount(AccessibleContext accessibleContext) {
        AccessibleTable accessibleTable;
        this.debugString("#####  getAccessibleTableColumnHeaderColumnCount");
        if (accessibleContext != null && (accessibleTable = this.getAccessibleTableColumnHeader(accessibleContext)) != null) {
            return accessibleTable.getAccessibleColumnCount();
        }
        this.debugString(" ##### getAccessibleTableColumnHeaderColumnCount FAILED");
        return -1;
    }

    public AccessibleContext getAccessibleTableRowDescription(AccessibleTable accessibleTable, int n) {
        Accessible accessible;
        if (accessibleTable != null && (accessible = accessibleTable.getAccessibleRowDescription(n)) != null) {
            return accessible.getAccessibleContext();
        }
        return null;
    }

    public AccessibleContext getAccessibleTableColumnDescription(AccessibleTable accessibleTable, int n) {
        Accessible accessible;
        if (accessibleTable != null && (accessible = accessibleTable.getAccessibleColumnDescription(n)) != null) {
            return accessible.getAccessibleContext();
        }
        return null;
    }

    public int getAccessibleTableRowSelectionCount(AccessibleTable accessibleTable) {
        if (accessibleTable != null) {
            int[] nArray = accessibleTable.getSelectedAccessibleRows();
            return nArray.length;
        }
        return -1;
    }

    public int getAccessibleTableRowSelections(AccessibleTable accessibleTable, int n) {
        int[] nArray;
        if (accessibleTable != null && (nArray = accessibleTable.getSelectedAccessibleRows()).length > n) {
            return nArray[n];
        }
        return -1;
    }

    public boolean isAccessibleTableRowSelected(AccessibleTable accessibleTable, int n) {
        if (accessibleTable != null) {
            return accessibleTable.isAccessibleRowSelected(n);
        }
        return false;
    }

    public boolean isAccessibleTableColumnSelected(AccessibleTable accessibleTable, int n) {
        if (accessibleTable != null) {
            return accessibleTable.isAccessibleColumnSelected(n);
        }
        return false;
    }

    public int getAccessibleTableColumnSelectionCount(AccessibleTable accessibleTable) {
        if (accessibleTable != null) {
            int[] nArray = accessibleTable.getSelectedAccessibleColumns();
            return nArray.length;
        }
        return -1;
    }

    public int getAccessibleTableColumnSelections(AccessibleTable accessibleTable, int n) {
        int[] nArray;
        if (accessibleTable != null && (nArray = accessibleTable.getSelectedAccessibleColumns()).length > n) {
            return nArray[n];
        }
        return -1;
    }

    public int getAccessibleTableRow(AccessibleTable accessibleTable, int n) {
        if (!this.runningOnJDK1_4) {
            return n / accessibleTable.getAccessibleColumnCount();
        }
        if (accessibleTable instanceof AccessibleExtendedTable) {
            return n / accessibleTable.getAccessibleColumnCount();
        }
        return n / accessibleTable.getAccessibleColumnCount();
    }

    public int getAccessibleTableColumn(AccessibleTable accessibleTable, int n) {
        if (!this.runningOnJDK1_4) {
            return n % accessibleTable.getAccessibleColumnCount();
        }
        if (accessibleTable instanceof AccessibleExtendedTable) {
            return n % accessibleTable.getAccessibleColumnCount();
        }
        return n % accessibleTable.getAccessibleColumnCount();
    }

    public int getAccessibleTableIndex(AccessibleTable accessibleTable, int n, int n2) {
        if (!this.runningOnJDK1_4) {
            return n * accessibleTable.getAccessibleColumnCount() + n2;
        }
        if (accessibleTable instanceof AccessibleExtendedTable) {
            return n * accessibleTable.getAccessibleColumnCount() + n2;
        }
        return n * accessibleTable.getAccessibleColumnCount() + n2;
    }

    public int getAccessibleRelationCount(AccessibleContext accessibleContext) {
        String string = this.getJavaVersionProperty();
        if (string != null && string.compareTo("1.3") >= 0 && accessibleContext != null) {
            AccessibleRelationSet accessibleRelationSet = accessibleContext.getAccessibleRelationSet();
            return accessibleRelationSet.size();
        }
        return 0;
    }

    public String getAccessibleRelationKey(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            AccessibleRelationSet accessibleRelationSet = accessibleContext.getAccessibleRelationSet();
            AccessibleRelation[] accessibleRelationArray = accessibleRelationSet.toArray();
            if (n >= 0 && n < accessibleRelationArray.length) {
                return accessibleRelationArray[n].getKey();
            }
        }
        return null;
    }

    public int getAccessibleRelationTargetCount(AccessibleContext accessibleContext, int n) {
        if (accessibleContext != null) {
            AccessibleRelationSet accessibleRelationSet = accessibleContext.getAccessibleRelationSet();
            AccessibleRelation[] accessibleRelationArray = accessibleRelationSet.toArray();
            if (n >= 0 && n < accessibleRelationArray.length) {
                Object[] objectArray = accessibleRelationArray[n].getTarget();
                return objectArray.length;
            }
        }
        return -1;
    }

    public AccessibleContext getAccessibleRelationTarget(AccessibleContext accessibleContext, int n, int n2) {
        this.debugString("***** getAccessibleRelationTarget");
        if (accessibleContext != null) {
            Object[] objectArray;
            AccessibleRelationSet accessibleRelationSet = accessibleContext.getAccessibleRelationSet();
            AccessibleRelation[] accessibleRelationArray = accessibleRelationSet.toArray();
            if (n >= 0 && n < accessibleRelationArray.length && n2 >= 0 & n2 < (objectArray = accessibleRelationArray[n].getTarget()).length) {
                Object object = objectArray[n2];
                this.debugString("***** target=" + object.getClass());
                if (object instanceof Accessible) {
                    return ((Accessible)object).getAccessibleContext();
                }
            }
        }
        return null;
    }

    AccessibleHypertext getAccessibleHypertext(AccessibleContext accessibleContext) {
        this.debugString("getAccessibleHyperlink");
        if (accessibleContext == null) {
            return null;
        }
        AccessibleText accessibleText = accessibleContext.getAccessibleText();
        if (!(accessibleText instanceof AccessibleHypertext)) {
            return null;
        }
        return (AccessibleHypertext)accessibleText;
    }

    int getAccessibleHyperlinkCount(AccessibleContext accessibleContext) {
        this.debugString("getAccessibleHyperlinkCount");
        if (accessibleContext == null) {
            return 0;
        }
        AccessibleHypertext accessibleHypertext = this.getAccessibleHypertext(accessibleContext);
        if (accessibleHypertext == null) {
            return 0;
        }
        return accessibleHypertext.getLinkCount();
    }

    AccessibleHyperlink getAccessibleHyperlink(AccessibleHypertext accessibleHypertext, int n) {
        this.debugString("getAccessibleHyperlink");
        if (accessibleHypertext == null) {
            return null;
        }
        if (n < 0 || n >= accessibleHypertext.getLinkCount()) {
            return null;
        }
        AccessibleHyperlink accessibleHyperlink = accessibleHypertext.getLink(n);
        if (accessibleHyperlink == null || !accessibleHyperlink.isValid()) {
            return null;
        }
        return accessibleHyperlink;
    }

    String getAccessibleHyperlinkText(AccessibleHyperlink accessibleHyperlink) {
        this.debugString("getAccessibleHyperlinkText");
        if (accessibleHyperlink == null) {
            return null;
        }
        String string = accessibleHyperlink.getAccessibleActionDescription(0);
        if (string != null) {
            this.debugString(" description = " + string);
            return string.toString();
        }
        return null;
    }

    String getAccessibleHyperlinkURL(AccessibleHyperlink accessibleHyperlink) {
        this.debugString("getAccessibleHyperlinkURL");
        if (accessibleHyperlink == null) {
            return null;
        }
        Object object = accessibleHyperlink.getAccessibleActionObject(0);
        if (object != null) {
            this.debugString("   URL = " + object);
            return object.toString();
        }
        return null;
    }

    int getAccessibleHyperlinkStartIndex(AccessibleHyperlink accessibleHyperlink) {
        this.debugString("getAccessibleHyperlinkStartIndex");
        if (accessibleHyperlink == null) {
            return -1;
        }
        return accessibleHyperlink.getStartIndex();
    }

    int getAccessibleHyperlinkEndIndex(AccessibleHyperlink accessibleHyperlink) {
        this.debugString("getAccessibleHyperlinkEndIndex");
        if (accessibleHyperlink == null) {
            return -1;
        }
        return accessibleHyperlink.getEndIndex();
    }

    int getAccessibleHypertextLinkIndex(AccessibleHypertext accessibleHypertext, int n) {
        this.debugString("getAccessibleHypertextLinkIndex: charIndex = " + n);
        if (accessibleHypertext == null) {
            return -1;
        }
        int n2 = accessibleHypertext.getLinkIndex(n);
        this.debugString("getAccessibleHypertextLinkIndex returning " + n2);
        return n2;
    }

    boolean activateAccessibleHyperlink(AccessibleContext accessibleContext, AccessibleHyperlink accessibleHyperlink) {
        this.debugString("activateAccessibleHyperlink: link = " + accessibleHyperlink.getClass());
        if (accessibleHyperlink == null) {
            return false;
        }
        boolean bl = accessibleHyperlink.doAccessibleAction(0);
        this.debugString("activateAccessibleHyperlink: returning = " + bl);
        return bl;
    }

    private KeyStroke getMnemonic(AccessibleContext accessibleContext) {
        Object object;
        AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
        if (!(accessibleComponent instanceof AccessibleExtendedComponent)) {
            return null;
        }
        AccessibleExtendedComponent accessibleExtendedComponent = (AccessibleExtendedComponent)accessibleComponent;
        AccessibleKeyBinding accessibleKeyBinding = accessibleExtendedComponent.getAccessibleKeyBinding();
        if (accessibleKeyBinding != null && (object = accessibleKeyBinding.getAccessibleKeyBinding(0)) instanceof KeyStroke) {
            return (KeyStroke)object;
        }
        return null;
    }

    private KeyStroke getAccelerator(AccessibleContext accessibleContext) {
        Accessible accessible = accessibleContext.getAccessibleParent();
        if (accessible instanceof Accessible) {
            int n = accessibleContext.getAccessibleIndexInParent();
            Accessible accessible2 = accessible.getAccessibleContext().getAccessibleChild(n);
            if (accessible2 instanceof JMenuItem) {
                JMenuItem jMenuItem = (JMenuItem)accessible2;
                KeyStroke keyStroke = jMenuItem.getAccelerator();
                this.debugString("getAccelerator = " + keyStroke);
                return keyStroke;
            }
        }
        return null;
    }

    private char getKeyChar(KeyStroke keyStroke) {
        CharSequence charSequence;
        String string = KeyEvent.getKeyText(keyStroke.getKeyCode());
        this.debugString("   key text = " + string);
        if (!(string == null && string.length() <= 0 || (charSequence = string.subSequence(0, 1)) == null && charSequence.length() <= 0)) {
            return charSequence.charAt(0);
        }
        return '\u0000';
    }

    private int getModifiers(KeyStroke keyStroke) {
        int n = 0;
        String string = KeyEvent.getKeyModifiersText(keyStroke.getModifiers());
        if (string.indexOf("Meta") >= 0) {
            n |= 4;
        }
        if (string.indexOf("Ctrl") >= 0) {
            n |= 2;
        }
        if (string.indexOf("Alt") >= 0) {
            n |= 8;
        }
        if (string.indexOf("Shift") >= 0) {
            n |= 1;
        }
        this.debugString("getModifiers: text = " + string + "; modifiers = " + n);
        return n;
    }

    int getAccessibleKeyBindingsCount(AccessibleContext accessibleContext) {
        this.debugString("getAccessibleKeyBindingsCount");
        if (accessibleContext == null || !this.runningOnJDK1_4) {
            return 0;
        }
        int n = 0;
        if (this.getMnemonic(accessibleContext) != null) {
            ++n;
        }
        if (this.getAccelerator(accessibleContext) != null) {
            ++n;
        }
        return n;
    }

    char getAccessibleKeyBindingChar(AccessibleContext accessibleContext, int n) {
        KeyStroke keyStroke;
        this.debugString("getAccessibleKeyBindingChar: index = " + n);
        if (accessibleContext == null || !this.runningOnJDK1_4) {
            return '\u0000';
        }
        if (n == 0) {
            KeyStroke keyStroke2 = this.getMnemonic(accessibleContext);
            if (keyStroke2 != null) {
                return this.getKeyChar(keyStroke2);
            }
        } else if (n == 1 && (keyStroke = this.getAccelerator(accessibleContext)) != null) {
            return this.getKeyChar(keyStroke);
        }
        return '\u0000';
    }

    int getAccessibleKeyBindingModifiers(AccessibleContext accessibleContext, int n) {
        KeyStroke keyStroke;
        this.debugString("getAccessibleKeyBindingModifiers: index = " + n);
        if (accessibleContext == null || !this.runningOnJDK1_4) {
            return 0;
        }
        if (n == 0) {
            KeyStroke keyStroke2 = this.getMnemonic(accessibleContext);
            if (keyStroke2 != null) {
                return this.getModifiers(keyStroke2);
            }
        } else if (n == 1 && (keyStroke = this.getAccelerator(accessibleContext)) != null) {
            return this.getModifiers(keyStroke);
        }
        return 0;
    }

    int getAccessibleIconsCount(AccessibleContext accessibleContext) {
        this.debugString("getAccessibleIconsCount");
        if (accessibleContext == null) {
            return 0;
        }
        AccessibleIcon[] accessibleIconArray = accessibleContext.getAccessibleIcon();
        if (accessibleIconArray == null) {
            return 0;
        }
        this.debugString("   #icons = " + accessibleIconArray.length);
        return accessibleIconArray.length;
    }

    String getAccessibleIconDescription(AccessibleContext accessibleContext, int n) {
        this.debugString("getAccessibleIconDescription: index = " + n);
        if (accessibleContext == null) {
            return null;
        }
        AccessibleIcon[] accessibleIconArray = accessibleContext.getAccessibleIcon();
        if (accessibleIconArray == null || n < 0 || n >= accessibleIconArray.length) {
            return null;
        }
        this.debugString("   icon description    = " + accessibleIconArray[n].getAccessibleIconDescription());
        return accessibleIconArray[n].getAccessibleIconDescription();
    }

    int getAccessibleIconHeight(AccessibleContext accessibleContext, int n) {
        this.debugString("getAccessibleIconHeight: index = " + n);
        if (accessibleContext == null) {
            return 0;
        }
        AccessibleIcon[] accessibleIconArray = accessibleContext.getAccessibleIcon();
        if (accessibleIconArray == null || n < 0 || n >= accessibleIconArray.length) {
            return 0;
        }
        this.debugString("   icon height    = " + accessibleIconArray[n].getAccessibleIconHeight());
        return accessibleIconArray[n].getAccessibleIconHeight();
    }

    int getAccessibleIconWidth(AccessibleContext accessibleContext, int n) {
        this.debugString("getAccessibleIconWidth: index = " + n);
        if (accessibleContext == null) {
            return 0;
        }
        AccessibleIcon[] accessibleIconArray = accessibleContext.getAccessibleIcon();
        if (accessibleIconArray == null || n < 0 || n >= accessibleIconArray.length) {
            return 0;
        }
        this.debugString("   icon height    = " + accessibleIconArray[n].getAccessibleIconWidth());
        return accessibleIconArray[n].getAccessibleIconWidth();
    }

    int getAccessibleActionsCount(AccessibleContext accessibleContext) {
        this.debugString("getAccessibleActionsCount");
        if (accessibleContext == null) {
            return 0;
        }
        AccessibleAction accessibleAction = accessibleContext.getAccessibleAction();
        if (accessibleAction == null) {
            return 0;
        }
        this.debugString("   #actions = " + accessibleAction.getAccessibleActionCount());
        return accessibleAction.getAccessibleActionCount();
    }

    String getAccessibleActionName(AccessibleContext accessibleContext, int n) {
        this.debugString("getAccessibleActionName: index = " + n);
        if (accessibleContext == null) {
            return null;
        }
        AccessibleAction accessibleAction = accessibleContext.getAccessibleAction();
        if (accessibleAction == null) {
            return null;
        }
        this.debugString("   action name    = " + accessibleAction.getAccessibleActionDescription(n));
        return accessibleAction.getAccessibleActionDescription(n);
    }

    boolean doAccessibleActions(AccessibleContext accessibleContext, String string) {
        int n;
        this.debugString("doAccessibleActions: action name = " + string);
        if (accessibleContext == null || string == null) {
            return false;
        }
        AccessibleAction accessibleAction = accessibleContext.getAccessibleAction();
        if (accessibleAction == null) {
            return false;
        }
        int n2 = -1;
        int n3 = accessibleAction.getAccessibleActionCount();
        for (n = 0; n < n3; n += 1) {
            String string2 = accessibleAction.getAccessibleActionDescription(n);
            if (!string.equals(string2)) continue;
            n2 = n;
            break;
        }
        if (n2 == -1) {
            this.debugString("  no such action: " + string);
            return false;
        }
        this.debugString(" doing action #" + n2 + ": " + string);
        n = accessibleAction.doAccessibleAction(n2) ? 1 : 0;
        this.debugString(" action " + string + ": " + (n != 0));
        return n != 0;
    }

    boolean setTextContents(AccessibleContext accessibleContext, String string) {
        this.debugString("setTextContents: ac = " + accessibleContext + "; text = " + string);
        if (!(accessibleContext instanceof AccessibleEditableText)) {
            this.debugString("   ac not instanceof AccessibleEditableText: " + accessibleContext);
            return false;
        }
        if (string == null) {
            this.debugString("   text is null");
            return false;
        }
        AccessibleStateSet accessibleStateSet = accessibleContext.getAccessibleStateSet();
        if (!accessibleStateSet.contains(AccessibleState.ENABLED)) {
            this.debugString("   text is not editable");
            return false;
        }
        ((AccessibleEditableText)((Object)accessibleContext)).setTextContents(string);
        this.debugString("   setTextContents succeeded");
        return true;
    }

    AccessibleContext getInternalFrame(AccessibleContext accessibleContext) {
        return this.getParentWithRole(accessibleContext, AccessibleRole.INTERNAL_FRAME.toString());
    }

    private AccessibleContext getTopLevelObject(AccessibleContext accessibleContext) {
        this.debugString("getTopLevelObject; ac = " + accessibleContext);
        if (accessibleContext == null) {
            return null;
        }
        if (accessibleContext.getAccessibleRole() == AccessibleRole.DIALOG) {
            return accessibleContext;
        }
        Accessible accessible = accessibleContext.getAccessibleParent();
        if (accessible == null) {
            this.debugString("   getTopLevelObject; returning: " + accessibleContext);
            return accessibleContext;
        }
        Accessible accessible2 = accessible;
        while (accessible2 != null && accessible2.getAccessibleContext() != null) {
            AccessibleContext accessibleContext2 = accessible2.getAccessibleContext();
            if (accessibleContext2.getAccessibleRole() == AccessibleRole.DIALOG) {
                return accessibleContext2;
            }
            this.debugString("   getTopLevelObject; next parent = " + accessible2.getAccessibleContext().getClass());
            accessible = accessible2;
            accessible2 = accessible.getAccessibleContext().getAccessibleParent();
        }
        this.debugString("   getTopLevelObject; returning: " + accessible.getAccessibleContext().getClass());
        return accessible.getAccessibleContext();
    }

    public AccessibleContext getParentWithRole(AccessibleContext accessibleContext, String string) {
        this.debugString("getParentWithRole; ac = " + accessibleContext + "; role = " + string);
        if (accessibleContext == null || string == null) {
            return null;
        }
        AccessibleRole accessibleRole = (AccessibleRole)this.accessibleRoleMap.get(string);
        if (accessibleRole == null) {
            this.debugString("   getParentWithRole; no such role: " + string);
            return accessibleContext;
        }
        Accessible accessible = accessibleContext.getAccessibleParent();
        if (accessible == null && accessibleContext.getAccessibleRole() == accessibleRole) {
            this.debugString("   getParentWithRole; returning ac: " + accessibleContext.getClass());
            return accessibleContext;
        }
        Accessible accessible2 = accessible;
        AccessibleContext accessibleContext2 = null;
        while (accessible2 != null && (accessibleContext2 = accessible2.getAccessibleContext()) != null) {
            this.debugString("   getParentWithRole; next parent = " + accessibleContext2.getClass());
            AccessibleRole accessibleRole2 = accessibleContext2.getAccessibleRole();
            if (accessibleRole2 == accessibleRole) {
                this.debugString("   getParentWithRole; returning tmp_ac: " + accessibleContext2.getClass());
                return accessibleContext2;
            }
            accessible = accessible2;
            accessible2 = accessible.getAccessibleContext().getAccessibleParent();
        }
        this.debugString("   getParentWithRole; parent not found");
        return null;
    }

    AccessibleContext getParentWithRoleElseRoot(AccessibleContext accessibleContext, String string) {
        AccessibleContext accessibleContext2 = this.getParentWithRole(accessibleContext, string);
        if (accessibleContext2 == null) {
            accessibleContext2 = this.getTopLevelObject(accessibleContext);
        }
        return accessibleContext2;
    }

    int getObjectDepth(AccessibleContext accessibleContext) {
        this.debugString("getObjectDepth: ac = " + accessibleContext);
        int n = 0;
        if (accessibleContext == null) {
            return -1;
        }
        Accessible accessible = accessibleContext.getAccessibleParent();
        if (accessible == null) {
            this.debugString("   getObjectDepth: count = " + n);
            return n;
        }
        Accessible accessible2 = accessible;
        while (accessible2 != null && accessible2.getAccessibleContext() != null) {
            this.debugString("   getTopLevelObject; next parent = " + accessible2.getAccessibleContext().getClass());
            accessible = accessible2;
            accessible2 = accessible.getAccessibleContext().getAccessibleParent();
            ++n;
        }
        this.debugString("   getObjectDepth: count = " + n);
        return n;
    }

    AccessibleContext getActiveDescendent(AccessibleContext accessibleContext) {
        AccessibleSelection accessibleSelection;
        Accessible accessible;
        this.debugString("getActiveDescendent: ac = " + accessibleContext);
        if (accessibleContext == null) {
            return null;
        }
        Accessible accessible2 = accessibleContext.getAccessibleParent();
        if (accessible2 instanceof Accessible) {
            int n = accessibleContext.getAccessibleIndexInParent();
            accessible = accessible2.getAccessibleContext().getAccessibleChild(n);
            if (accessible instanceof JTree) {
                JTree jTree = (JTree)accessible;
                return new AccessibleJTreeNode(jTree, jTree.getSelectionPath(), null);
            }
        }
        if ((accessibleSelection = accessibleContext.getAccessibleSelection()) == null) {
            this.debugString("   getActiveDescendent: no selection");
            return null;
        }
        if (accessibleSelection.getAccessibleSelectionCount() != 1) {
            this.debugString("   getActiveDescendent: selection count > 1");
            return null;
        }
        accessible = accessibleSelection.getAccessibleSelection(0);
        if (accessible == null) {
            this.debugString("   getActiveDescendent: selection is null");
            return null;
        }
        this.debugString("   getActiveDescendent: returning: " + accessible.getAccessibleContext());
        return accessible.getAccessibleContext();
    }

    String getJAWSAccessibleName(AccessibleContext accessibleContext) {
        this.debugString("getJAWSAccessibleName");
        if (accessibleContext == null) {
            return null;
        }
        String string = accessibleContext.getAccessibleName();
        this.debugString("    getJAWSAccessibleName: name = " + string);
        return string;
    }

    boolean requestFocus(AccessibleContext accessibleContext) {
        this.debugString("requestFocus");
        if (accessibleContext == null) {
            return false;
        }
        AccessibleComponent accessibleComponent = accessibleContext.getAccessibleComponent();
        if (accessibleComponent == null) {
            return false;
        }
        accessibleComponent.requestFocus();
        boolean bl = accessibleContext.getAccessibleStateSet().contains(AccessibleState.FOCUSED);
        this.debugString("    GGGG requestFocus: result = " + bl);
        return bl;
    }

    boolean selectTextRange(AccessibleContext accessibleContext, int n, int n2) {
        this.debugString("selectTextRange: start = " + n + "; end = " + n2);
        if (accessibleContext == null) {
            return false;
        }
        AccessibleText accessibleText = accessibleContext.getAccessibleText();
        if (!(accessibleText instanceof AccessibleEditableText)) {
            return false;
        }
        ((AccessibleEditableText)accessibleText).selectText(n, n2);
        boolean bl = accessibleText.getSelectionStart() == n && accessibleText.getSelectionEnd() == n2;
        this.debugString("    selectTextRange: result = " + bl);
        return bl;
    }

    boolean setCaretPosition(AccessibleContext accessibleContext, int n) {
        this.debugString("setCaretPosition: position = " + n);
        if (accessibleContext == null) {
            return false;
        }
        AccessibleText accessibleText = accessibleContext.getAccessibleText();
        if (!(accessibleText instanceof AccessibleEditableText)) {
            return false;
        }
        ((AccessibleEditableText)accessibleText).selectText(n, n);
        boolean bl = accessibleText.getCaretPosition() == n;
        this.debugString("    setCaretPosition: result = " + bl);
        return bl;
    }

    int getVisibleChildrenCount(AccessibleContext accessibleContext) {
        this.debugString("getVisibleChildrenCount");
        if (accessibleContext == null) {
            return -1;
        }
        this._visibleChildrenCount = 0;
        this._getVisibleChildrenCount(accessibleContext);
        this.debugString("  _visibleChildrenCount = " + this._visibleChildrenCount);
        return this._visibleChildrenCount;
    }

    private void _getVisibleChildrenCount(AccessibleContext accessibleContext) {
        int n = accessibleContext.getAccessibleChildrenCount();
        for (int i = 0; i < n; ++i) {
            Accessible accessible = accessibleContext.getAccessibleChild(i);
            AccessibleContext accessibleContext2 = accessible.getAccessibleContext();
            if (accessibleContext2 == null || !accessibleContext2.getAccessibleStateSet().contains(AccessibleState.SHOWING)) continue;
            ++this._visibleChildrenCount;
            if (accessibleContext2.getAccessibleChildrenCount() <= 0) continue;
            this._getVisibleChildrenCount(accessibleContext2);
        }
    }

    AccessibleContext getVisibleChild(AccessibleContext accessibleContext, int n) {
        this.debugString("getVisibleChild: index = " + n);
        if (accessibleContext == null) {
            return null;
        }
        this._visibleChild = null;
        this._currentVisibleIndex = 0;
        this._foundVisibleChild = false;
        this._getVisibleChild(accessibleContext, n);
        if (this._visibleChild != null) {
            this.debugString("    getVisibleChild: found child = " + this._visibleChild.getAccessibleName());
        }
        return this._visibleChild;
    }

    private void _getVisibleChild(AccessibleContext accessibleContext, int n) {
        if (this._visibleChild != null) {
            return;
        }
        int n2 = accessibleContext.getAccessibleChildrenCount();
        for (int i = 0; i < n2; ++i) {
            Accessible accessible = accessibleContext.getAccessibleChild(i);
            AccessibleContext accessibleContext2 = accessible.getAccessibleContext();
            if (accessibleContext2 == null || !accessibleContext2.getAccessibleStateSet().contains(AccessibleState.SHOWING)) continue;
            if (!this._foundVisibleChild && this._currentVisibleIndex == n) {
                this._visibleChild = accessibleContext2;
                this._foundVisibleChild = true;
                return;
            }
            ++this._currentVisibleIndex;
            if (accessibleContext2.getAccessibleChildrenCount() <= 0) continue;
            this._getVisibleChild(accessibleContext2, n);
        }
    }

    public native void propertyCaretChange(PropertyChangeEvent var1, AccessibleContext var2, int var3, int var4);

    public native void propertyDescriptionChange(PropertyChangeEvent var1, AccessibleContext var2, String var3, String var4);

    public native void propertyNameChange(PropertyChangeEvent var1, AccessibleContext var2, String var3, String var4);

    public native void propertySelectionChange(PropertyChangeEvent var1, AccessibleContext var2);

    public native void propertyStateChange(PropertyChangeEvent var1, AccessibleContext var2, String var3, String var4);

    public native void propertyTextChange(PropertyChangeEvent var1, AccessibleContext var2);

    public native void propertyValueChange(PropertyChangeEvent var1, AccessibleContext var2, String var3, String var4);

    public native void propertyVisibleDataChange(PropertyChangeEvent var1, AccessibleContext var2);

    public native void propertyChildChange(PropertyChangeEvent var1, AccessibleContext var2, AccessibleContext var3, AccessibleContext var4);

    public native void propertyActiveDescendentChange(PropertyChangeEvent var1, AccessibleContext var2, AccessibleContext var3, AccessibleContext var4);

    public native void javaShutdown();

    public native void focusGained(FocusEvent var1, AccessibleContext var2);

    public native void focusLost(FocusEvent var1, AccessibleContext var2);

    public native void caretUpdate(CaretEvent var1, AccessibleContext var2);

    public native void mouseClicked(MouseEvent var1, AccessibleContext var2);

    public native void mouseEntered(MouseEvent var1, AccessibleContext var2);

    public native void mouseExited(MouseEvent var1, AccessibleContext var2);

    public native void mousePressed(MouseEvent var1, AccessibleContext var2);

    public native void mouseReleased(MouseEvent var1, AccessibleContext var2);

    public native void menuCanceled(MenuEvent var1, AccessibleContext var2);

    public native void menuDeselected(MenuEvent var1, AccessibleContext var2);

    public native void menuSelected(MenuEvent var1, AccessibleContext var2);

    public native void popupMenuCanceled(PopupMenuEvent var1, AccessibleContext var2);

    public native void popupMenuWillBecomeInvisible(PopupMenuEvent var1, AccessibleContext var2);

    public native void popupMenuWillBecomeVisible(PopupMenuEvent var1, AccessibleContext var2);

    public void addJavaEventNotification(long l) {
        this.eventHandler.addJavaEventNotification(l);
    }

    public void removeJavaEventNotification(long l) {
        this.eventHandler.removeJavaEventNotification(l);
    }

    public void addAccessibilityEventNotification(long l) {
        this.eventHandler.addAccessibilityEventNotification(l);
    }

    public void removeAccessibilityEventNotification(long l) {
        this.eventHandler.removeAccessibilityEventNotification(l);
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                System.loadLibrary("JavaAccessBridge-64");
                return null;
            }
        });
        windowHandleToContextMap = new Hashtable();
        contextToWindowHandleMap = new Hashtable();
        nativeWindowHandlers = new Vector();
    }

    protected class AccessibleJTreeNode
    extends AccessibleContext
    implements Accessible,
    AccessibleComponent,
    AccessibleSelection,
    AccessibleAction {
        private JTree tree = null;
        private TreeModel treeModel = null;
        private Object obj = null;
        private TreePath path = null;
        private Accessible accessibleParent = null;
        private int index = 0;
        private boolean isLeaf = false;

        public AccessibleJTreeNode(JTree jTree, TreePath treePath, Accessible accessible) {
            this.tree = jTree;
            this.path = treePath;
            this.accessibleParent = accessible;
            this.treeModel = jTree.getModel();
            if (treePath != null) {
                this.obj = treePath.getLastPathComponent();
                if (this.treeModel != null && this.obj != null) {
                    this.isLeaf = this.treeModel.isLeaf(this.obj);
                }
            }
            AccessBridge.this.debugString("AccessibleJTreeNode: name = " + this.getAccessibleName() + "; TreePath = " + treePath + "; parent = " + accessible);
        }

        private TreePath getChildTreePath(int n) {
            if (n < 0 || n >= this.getAccessibleChildrenCount() || this.path == null) {
                return null;
            }
            Object object = this.treeModel.getChild(this.obj, n);
            Object[] objectArray = this.path.getPath();
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray2[objectArray2.length - 1] = object;
            return new TreePath(objectArray2);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            return this;
        }

        private AccessibleContext getCurrentAccessibleContext() {
            Component component = this.getCurrentComponent();
            if (component instanceof Accessible) {
                return ((Accessible)((Object)component)).getAccessibleContext();
            }
            return null;
        }

        private Component getCurrentComponent() {
            AccessBridge.this.debugString("AccessibleJTreeNode: getCurrentComponent");
            if (this.tree.isVisible(this.path)) {
                TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
                if (treeCellRenderer == null) {
                    AccessBridge.this.debugString("  returning null 1");
                    return null;
                }
                TreeUI treeUI = this.tree.getUI();
                if (treeUI != null) {
                    int n = treeUI.getRowForPath(this.tree, this.path);
                    boolean bl = this.tree.isPathSelected(this.path);
                    boolean bl2 = this.tree.isExpanded(this.path);
                    boolean bl3 = false;
                    Component component = treeCellRenderer.getTreeCellRendererComponent(this.tree, this.obj, bl, bl2, this.isLeaf, n, bl3);
                    AccessBridge.this.debugString("  returning = " + component.getClass());
                    return component;
                }
            }
            AccessBridge.this.debugString("  returning null 2");
            return null;
        }

        @Override
        public String getAccessibleName() {
            AccessBridge.this.debugString("AccessibleJTreeNode: getAccessibleName");
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                String string = accessibleContext.getAccessibleName();
                if (string != null && string != "") {
                    String string2 = accessibleContext.getAccessibleName();
                    AccessBridge.this.debugString("    returning " + string2);
                    return string2;
                }
                return null;
            }
            if (this.accessibleName != null && this.accessibleName != "") {
                return this.accessibleName;
            }
            return null;
        }

        @Override
        public void setAccessibleName(String string) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                accessibleContext.setAccessibleName(string);
            } else {
                super.setAccessibleName(string);
            }
        }

        @Override
        public String getAccessibleDescription() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                return accessibleContext.getAccessibleDescription();
            }
            return super.getAccessibleDescription();
        }

        @Override
        public void setAccessibleDescription(String string) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                accessibleContext.setAccessibleDescription(string);
            } else {
                super.setAccessibleDescription(string);
            }
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                return accessibleContext.getAccessibleRole();
            }
            return AccessibleRole.UNKNOWN;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            int n = this.tree.getUI().getRowForPath(this.tree, this.path);
            int n2 = this.tree.getLeadSelectionRow();
            AccessibleStateSet accessibleStateSet = accessibleContext != null ? accessibleContext.getAccessibleStateSet() : new AccessibleStateSet();
            if (this.isShowing()) {
                accessibleStateSet.add(AccessibleState.SHOWING);
            } else if (accessibleStateSet.contains(AccessibleState.SHOWING)) {
                accessibleStateSet.remove(AccessibleState.SHOWING);
            }
            if (this.isVisible()) {
                accessibleStateSet.add(AccessibleState.VISIBLE);
            } else if (accessibleStateSet.contains(AccessibleState.VISIBLE)) {
                accessibleStateSet.remove(AccessibleState.VISIBLE);
            }
            if (this.tree.isPathSelected(this.path)) {
                accessibleStateSet.add(AccessibleState.SELECTED);
            }
            if (n2 == n) {
                accessibleStateSet.add(AccessibleState.ACTIVE);
            }
            if (!this.isLeaf) {
                accessibleStateSet.add(AccessibleState.EXPANDABLE);
            }
            if (this.tree.isExpanded(this.path)) {
                accessibleStateSet.add(AccessibleState.EXPANDED);
            } else {
                accessibleStateSet.add(AccessibleState.COLLAPSED);
            }
            if (this.tree.isEditable()) {
                accessibleStateSet.add(AccessibleState.EDITABLE);
            }
            return accessibleStateSet;
        }

        @Override
        public Accessible getAccessibleParent() {
            if (this.accessibleParent == null && this.path != null) {
                Object[] objectArray = this.path.getPath();
                if (objectArray.length > 1) {
                    Object object = objectArray[objectArray.length - 2];
                    if (this.treeModel != null) {
                        this.index = this.treeModel.getIndexOfChild(object, this.obj);
                    }
                    Object[] objectArray2 = new Object[objectArray.length - 1];
                    System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length - 1);
                    TreePath treePath = new TreePath(objectArray2);
                    this.accessibleParent = new AccessibleJTreeNode(this.tree, treePath, null);
                    this.setAccessibleParent(this.accessibleParent);
                } else if (this.treeModel != null) {
                    this.accessibleParent = this.tree;
                    this.index = 0;
                    this.setAccessibleParent(this.accessibleParent);
                }
            }
            return this.accessibleParent;
        }

        @Override
        public int getAccessibleIndexInParent() {
            Object[] objectArray;
            if (this.accessibleParent == null) {
                this.getAccessibleParent();
            }
            if (this.path != null && (objectArray = this.path.getPath()).length > 1) {
                Object object = objectArray[objectArray.length - 2];
                if (this.treeModel != null) {
                    this.index = this.treeModel.getIndexOfChild(object, this.obj);
                }
            }
            return this.index;
        }

        @Override
        public int getAccessibleChildrenCount() {
            if (this.obj != null) {
                return this.treeModel.getChildCount(this.obj);
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= this.getAccessibleChildrenCount() || this.path == null) {
                return null;
            }
            Object object = this.treeModel.getChild(this.obj, n);
            Object[] objectArray = this.path.getPath();
            Object[] objectArray2 = new Object[objectArray.length + 1];
            System.arraycopy(objectArray, 0, objectArray2, 0, objectArray.length);
            objectArray2[objectArray2.length - 1] = object;
            TreePath treePath = new TreePath(objectArray2);
            return new AccessibleJTreeNode(this.tree, treePath, this);
        }

        @Override
        public Locale getLocale() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                return accessibleContext.getLocale();
            }
            return this.tree.getLocale();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                accessibleContext.addPropertyChangeListener(propertyChangeListener);
            } else {
                super.addPropertyChangeListener(propertyChangeListener);
            }
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                accessibleContext.removePropertyChangeListener(propertyChangeListener);
            } else {
                super.removePropertyChangeListener(propertyChangeListener);
            }
        }

        @Override
        public AccessibleAction getAccessibleAction() {
            return this;
        }

        @Override
        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && this.isLeaf) {
                return this.getCurrentAccessibleContext().getAccessibleSelection();
            }
            return this;
        }

        @Override
        public AccessibleText getAccessibleText() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                return this.getCurrentAccessibleContext().getAccessibleText();
            }
            return null;
        }

        @Override
        public AccessibleValue getAccessibleValue() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null) {
                return this.getCurrentAccessibleContext().getAccessibleValue();
            }
            return null;
        }

        @Override
        public Color getBackground() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).getBackground();
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.getBackground();
            }
            return null;
        }

        @Override
        public void setBackground(Color color) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setBackground(color);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setBackground(color);
                }
            }
        }

        @Override
        public Color getForeground() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).getForeground();
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.getForeground();
            }
            return null;
        }

        @Override
        public void setForeground(Color color) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setForeground(color);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setForeground(color);
                }
            }
        }

        @Override
        public Cursor getCursor() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).getCursor();
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.getCursor();
            }
            Accessible accessible = this.getAccessibleParent();
            if (accessible instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessible)).getCursor();
            }
            return null;
        }

        @Override
        public void setCursor(Cursor cursor) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setCursor(cursor);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setCursor(cursor);
                }
            }
        }

        @Override
        public Font getFont() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).getFont();
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.getFont();
            }
            return null;
        }

        @Override
        public void setFont(Font font) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setFont(font);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setFont(font);
                }
            }
        }

        @Override
        public FontMetrics getFontMetrics(Font font) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).getFontMetrics(font);
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.getFontMetrics(font);
            }
            return null;
        }

        @Override
        public boolean isEnabled() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).isEnabled();
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.isEnabled();
            }
            return false;
        }

        @Override
        public void setEnabled(boolean bl) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setEnabled(bl);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setEnabled(bl);
                }
            }
        }

        @Override
        public boolean isVisible() {
            Rectangle rectangle = this.tree.getPathBounds(this.path);
            Rectangle rectangle2 = this.tree.getVisibleRect();
            return rectangle != null && rectangle2 != null && rectangle2.intersects(rectangle);
        }

        @Override
        public void setVisible(boolean bl) {
        }

        @Override
        public boolean isShowing() {
            return this.tree.isShowing() && this.isVisible();
        }

        @Override
        public boolean contains(Point point) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                Rectangle rectangle = ((AccessibleComponent)((Object)accessibleContext)).getBounds();
                return rectangle.contains(point);
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                Rectangle rectangle = component.getBounds();
                return rectangle.contains(point);
            }
            return this.getBounds().contains(point);
        }

        @Override
        public Point getLocationOnScreen() {
            if (this.tree != null) {
                Point point = this.tree.getLocationOnScreen();
                Rectangle rectangle = this.tree.getPathBounds(this.path);
                if (point != null && rectangle != null) {
                    Point point2 = new Point(rectangle.x, rectangle.y);
                    point2.translate(point.x, point.y);
                    return point2;
                }
                return null;
            }
            return null;
        }

        protected Point getLocationInJTree() {
            Rectangle rectangle = this.tree.getPathBounds(this.path);
            if (rectangle != null) {
                return rectangle.getLocation();
            }
            return null;
        }

        @Override
        public Point getLocation() {
            Rectangle rectangle = this.getBounds();
            if (rectangle != null) {
                return rectangle.getLocation();
            }
            return null;
        }

        @Override
        public void setLocation(Point point) {
        }

        @Override
        public Rectangle getBounds() {
            Rectangle rectangle = this.tree.getPathBounds(this.path);
            Accessible accessible = this.getAccessibleParent();
            if (accessible instanceof AccessibleJTreeNode) {
                Point point = ((AccessibleJTreeNode)accessible).getLocationInJTree();
                if (point != null && rectangle != null) {
                    rectangle.translate(-point.x, -point.y);
                } else {
                    return null;
                }
            }
            return rectangle;
        }

        @Override
        public void setBounds(Rectangle rectangle) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setBounds(rectangle);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setBounds(rectangle);
                }
            }
        }

        @Override
        public Dimension getSize() {
            return this.getBounds().getSize();
        }

        @Override
        public void setSize(Dimension dimension) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).setSize(dimension);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.setSize(dimension);
                }
            }
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).getAccessibleAt(point);
            }
            return null;
        }

        @Override
        public boolean isFocusTraversable() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                return ((AccessibleComponent)((Object)accessibleContext)).isFocusTraversable();
            }
            Component component = this.getCurrentComponent();
            if (component != null) {
                return component.isFocusable();
            }
            return false;
        }

        @Override
        public void requestFocus() {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).requestFocus();
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.requestFocus();
                }
            }
        }

        @Override
        public void addFocusListener(FocusListener focusListener) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).addFocusListener(focusListener);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.addFocusListener(focusListener);
                }
            }
        }

        @Override
        public void removeFocusListener(FocusListener focusListener) {
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext instanceof AccessibleComponent) {
                ((AccessibleComponent)((Object)accessibleContext)).removeFocusListener(focusListener);
            } else {
                Component component = this.getCurrentComponent();
                if (component != null) {
                    component.removeFocusListener(focusListener);
                }
            }
        }

        @Override
        public int getAccessibleSelectionCount() {
            int n = 0;
            int n2 = this.getAccessibleChildrenCount();
            for (int i = 0; i < n2; ++i) {
                TreePath treePath = this.getChildTreePath(i);
                if (!this.tree.isPathSelected(treePath)) continue;
                ++n;
            }
            return n;
        }

        @Override
        public Accessible getAccessibleSelection(int n) {
            int n2 = this.getAccessibleChildrenCount();
            if (n < 0 || n >= n2) {
                return null;
            }
            int n3 = 0;
            for (int i = 0; i < n2 && n >= n3; ++i) {
                TreePath treePath = this.getChildTreePath(i);
                if (!this.tree.isPathSelected(treePath)) continue;
                if (n3 == n) {
                    return new AccessibleJTreeNode(this.tree, treePath, this);
                }
                ++n3;
            }
            return null;
        }

        @Override
        public boolean isAccessibleChildSelected(int n) {
            int n2 = this.getAccessibleChildrenCount();
            if (n < 0 || n >= n2) {
                return false;
            }
            TreePath treePath = this.getChildTreePath(n);
            return this.tree.isPathSelected(treePath);
        }

        @Override
        public void addAccessibleSelection(int n) {
            TreeModel treeModel = this.tree.getModel();
            if (treeModel != null && n >= 0 && n < this.getAccessibleChildrenCount()) {
                TreePath treePath = this.getChildTreePath(n);
                this.tree.addSelectionPath(treePath);
            }
        }

        @Override
        public void removeAccessibleSelection(int n) {
            TreeModel treeModel = this.tree.getModel();
            if (treeModel != null && n >= 0 && n < this.getAccessibleChildrenCount()) {
                TreePath treePath = this.getChildTreePath(n);
                this.tree.removeSelectionPath(treePath);
            }
        }

        @Override
        public void clearAccessibleSelection() {
            int n = this.getAccessibleChildrenCount();
            for (int i = 0; i < n; ++i) {
                this.removeAccessibleSelection(i);
            }
        }

        @Override
        public void selectAllAccessibleSelection() {
            TreeModel treeModel = this.tree.getModel();
            if (treeModel != null) {
                int n = this.getAccessibleChildrenCount();
                for (int i = 0; i < n; ++i) {
                    TreePath treePath = this.getChildTreePath(i);
                    this.tree.addSelectionPath(treePath);
                }
            }
        }

        @Override
        public int getAccessibleActionCount() {
            AccessibleAction accessibleAction;
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (accessibleContext != null && (accessibleAction = accessibleContext.getAccessibleAction()) != null) {
                return accessibleAction.getAccessibleActionCount() + (this.isLeaf ? 0 : 1);
            }
            return this.isLeaf ? 0 : 1;
        }

        @Override
        public String getAccessibleActionDescription(int n) {
            AccessibleAction accessibleAction;
            if (n < 0 || n >= this.getAccessibleActionCount()) {
                return null;
            }
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (n == 0) {
                return "toggle expand";
            }
            if (accessibleContext != null && (accessibleAction = accessibleContext.getAccessibleAction()) != null) {
                return accessibleAction.getAccessibleActionDescription(n - 1);
            }
            return null;
        }

        @Override
        public boolean doAccessibleAction(int n) {
            AccessibleAction accessibleAction;
            if (n < 0 || n >= this.getAccessibleActionCount()) {
                return false;
            }
            AccessibleContext accessibleContext = this.getCurrentAccessibleContext();
            if (n == 0) {
                if (this.tree.isExpanded(this.path)) {
                    this.tree.collapsePath(this.path);
                } else {
                    this.tree.expandPath(this.path);
                }
                return true;
            }
            if (accessibleContext != null && (accessibleAction = accessibleContext.getAccessibleAction()) != null) {
                return accessibleAction.doAccessibleAction(n - 1);
            }
            return false;
        }
    }

    class EventHandler
    implements PropertyChangeListener,
    FocusListener,
    CaretListener,
    MenuListener,
    PopupMenuListener,
    MouseListener,
    WindowListener,
    ChangeListener {
        AccessBridge accessBridge;
        long javaEventMask = 0L;
        long accessibilityEventMask = 0L;
        AccessibleContext prevAC = null;
        private boolean stateChangeListenerAdded = false;

        public EventHandler(AccessBridge accessBridge2) {
            this.accessBridge = accessBridge2;
        }

        @Override
        public void windowOpened(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object instanceof NativeWindowHandler) {
                AccessBridge.addNativeWindowHandler((NativeWindowHandler)object);
            }
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
        }

        @Override
        public void windowClosed(WindowEvent windowEvent) {
            Object object = windowEvent.getSource();
            if (object instanceof NativeWindowHandler) {
                AccessBridge.removeNativeWindowHandler((NativeWindowHandler)object);
            }
        }

        @Override
        public void windowIconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeiconified(WindowEvent windowEvent) {
        }

        @Override
        public void windowActivated(WindowEvent windowEvent) {
        }

        @Override
        public void windowDeactivated(WindowEvent windowEvent) {
        }

        public void addJavaEventNotification(long l) {
            long l2 = this.javaEventMask | l;
            if ((this.javaEventMask & 6L) == 0L && (l2 & 6L) != 0L) {
                SwingEventMonitor.addFocusListener(this);
            }
            if ((this.javaEventMask & 8L) == 0L && (l2 & 8L) != 0L) {
                SwingEventMonitor.addCaretListener(this);
            }
            if ((this.javaEventMask & 0x1F0L) == 0L && (l2 & 0x1F0L) != 0L) {
                SwingEventMonitor.addMouseListener(this);
            }
            if ((this.javaEventMask & 0xE00L) == 0L && (l2 & 0xE00L) != 0L) {
                SwingEventMonitor.addMenuListener(this);
                SwingEventMonitor.addPopupMenuListener(this);
            }
            if ((this.javaEventMask & 0x7000L) == 0L && (l2 & 0x7000L) != 0L) {
                SwingEventMonitor.addPopupMenuListener(this);
            }
            this.javaEventMask = l2;
        }

        public void removeJavaEventNotification(long l) {
            long l2 = this.javaEventMask & (l ^ 0xFFFFFFFFFFFFFFFFL);
            if ((this.javaEventMask & 6L) != 0L && (l2 & 6L) == 0L) {
                SwingEventMonitor.removeFocusListener(this);
            }
            if ((this.javaEventMask & 8L) != 0L && (l2 & 8L) == 0L) {
                SwingEventMonitor.removeCaretListener(this);
            }
            if ((this.javaEventMask & 0x1F0L) == 0L && (l2 & 0x1F0L) != 0L) {
                SwingEventMonitor.removeMouseListener(this);
            }
            if ((this.javaEventMask & 0xE00L) == 0L && (l2 & 0xE00L) != 0L) {
                SwingEventMonitor.removeMenuListener(this);
            }
            if ((this.javaEventMask & 0x7000L) == 0L && (l2 & 0x7000L) != 0L) {
                SwingEventMonitor.removePopupMenuListener(this);
            }
            this.javaEventMask = l2;
        }

        public void addAccessibilityEventNotification(long l) {
            long l2 = this.accessibilityEventMask | l;
            if ((this.accessibilityEventMask & 0x3FFL) == 0L && (l2 & 0x3FFL) != 0L) {
                AccessibilityEventMonitor.addPropertyChangeListener(this);
            }
            this.accessibilityEventMask = l2;
        }

        public void removeAccessibilityEventNotification(long l) {
            long l2 = this.accessibilityEventMask & (l ^ 0xFFFFFFFFFFFFFFFFL);
            if ((this.accessibilityEventMask & 0x3FFL) != 0L && (l2 & 0x3FFL) == 0L) {
                AccessibilityEventMonitor.removePropertyChangeListener(this);
            }
            this.accessibilityEventMask = l2;
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.accessBridge.debugString("propertyChange(" + propertyChangeEvent.toString() + ") called");
            if ((this.accessibilityEventMask & 0x3FFL) != 0L) {
                Object object;
                AccessibleContext accessibleContext;
                Object object2 = propertyChangeEvent.getSource();
                if (object2 instanceof AccessibleContext) {
                    accessibleContext = (AccessibleContext)object2;
                } else {
                    object = Translator.getAccessible(propertyChangeEvent.getSource());
                    accessibleContext = object.getAccessibleContext();
                }
                if (accessibleContext != null) {
                    object = propertyChangeEvent.getPropertyName();
                    if (((String)object).compareTo("AccessibleCaret") == 0) {
                        int n = 0;
                        int n2 = 0;
                        if (propertyChangeEvent.getOldValue() instanceof Integer) {
                            n = (Integer)propertyChangeEvent.getOldValue();
                        }
                        if (propertyChangeEvent.getNewValue() instanceof Integer) {
                            n2 = (Integer)propertyChangeEvent.getNewValue();
                        }
                        this.accessBridge.debugString(" - about to call propertyCaretChange()");
                        this.accessBridge.propertyCaretChange(propertyChangeEvent, accessibleContext, n, n2);
                    } else if (((String)object).compareTo("AccessibleDescription") == 0) {
                        String string = null;
                        String string2 = null;
                        if (propertyChangeEvent.getOldValue() != null) {
                            string = propertyChangeEvent.getOldValue().toString();
                        }
                        if (propertyChangeEvent.getNewValue() != null) {
                            string2 = propertyChangeEvent.getNewValue().toString();
                        }
                        this.accessBridge.debugString(" - about to call propertyDescriptionChange()");
                        this.accessBridge.propertyDescriptionChange(propertyChangeEvent, accessibleContext, string, string2);
                    } else if (((String)object).compareTo("AccessibleName") == 0) {
                        String string = null;
                        String string3 = null;
                        if (propertyChangeEvent.getOldValue() != null) {
                            string = propertyChangeEvent.getOldValue().toString();
                        }
                        if (propertyChangeEvent.getNewValue() != null) {
                            string3 = propertyChangeEvent.getNewValue().toString();
                        }
                        this.accessBridge.debugString(" - about to call propertyNameChange()");
                        this.accessBridge.propertyNameChange(propertyChangeEvent, accessibleContext, string, string3);
                    } else if (((String)object).compareTo("AccessibleSelection") == 0) {
                        this.accessBridge.debugString(" - about to call propertySelectionChange()");
                        this.accessBridge.propertySelectionChange(propertyChangeEvent, accessibleContext);
                    } else if (((String)object).compareTo("AccessibleState") == 0) {
                        AccessibleState accessibleState;
                        String string = null;
                        String string4 = null;
                        if (propertyChangeEvent.getOldValue() != null) {
                            accessibleState = (AccessibleState)propertyChangeEvent.getOldValue();
                            string = accessibleState.toDisplayString(Locale.US);
                        }
                        if (propertyChangeEvent.getNewValue() != null) {
                            accessibleState = (AccessibleState)propertyChangeEvent.getNewValue();
                            string4 = accessibleState.toDisplayString(Locale.US);
                        }
                        this.accessBridge.debugString(" - about to call propertyStateChange()");
                        this.accessBridge.propertyStateChange(propertyChangeEvent, accessibleContext, string, string4);
                    } else if (((String)object).compareTo("AccessibleText") == 0) {
                        this.accessBridge.debugString(" - about to call propertyTextChange()");
                        this.accessBridge.propertyTextChange(propertyChangeEvent, accessibleContext);
                    } else if (((String)object).compareTo("AccessibleValue") == 0) {
                        String string = null;
                        String string5 = null;
                        if (propertyChangeEvent.getOldValue() != null) {
                            string = propertyChangeEvent.getOldValue().toString();
                        }
                        if (propertyChangeEvent.getNewValue() != null) {
                            string5 = propertyChangeEvent.getNewValue().toString();
                        }
                        this.accessBridge.debugString(" - about to call propertyDescriptionChange()");
                        this.accessBridge.propertyValueChange(propertyChangeEvent, accessibleContext, string, string5);
                    } else if (((String)object).compareTo("AccessibleVisibleData") == 0) {
                        this.accessBridge.propertyVisibleDataChange(propertyChangeEvent, accessibleContext);
                    } else if (((String)object).compareTo("AccessibleChild") == 0) {
                        AccessibleContext accessibleContext2 = null;
                        AccessibleContext accessibleContext3 = null;
                        if (propertyChangeEvent.getOldValue() instanceof AccessibleContext) {
                            accessibleContext2 = (AccessibleContext)propertyChangeEvent.getOldValue();
                        }
                        if (propertyChangeEvent.getNewValue() instanceof AccessibleContext) {
                            accessibleContext3 = (AccessibleContext)propertyChangeEvent.getNewValue();
                        }
                        this.accessBridge.debugString(" - about to call propertyChildChange()");
                        this.accessBridge.propertyChildChange(propertyChangeEvent, accessibleContext, accessibleContext2, accessibleContext3);
                    } else if (((String)object).compareTo("AccessibleActiveDescendant") == 0) {
                        this.handleActiveDescendentEvent(propertyChangeEvent, accessibleContext);
                    }
                }
            }
        }

        private void handleActiveDescendentEvent(PropertyChangeEvent propertyChangeEvent, AccessibleContext accessibleContext) {
            Accessible accessible;
            Accessible accessible2;
            AccessibleContext accessibleContext2 = null;
            AccessibleContext accessibleContext3 = null;
            if (propertyChangeEvent.getOldValue() instanceof Accessible) {
                accessibleContext2 = ((Accessible)propertyChangeEvent.getOldValue()).getAccessibleContext();
            } else if (propertyChangeEvent.getOldValue() instanceof Component && (accessible2 = Translator.getAccessible((Component)propertyChangeEvent.getOldValue())) != null) {
                accessibleContext2 = accessible2.getAccessibleContext();
            }
            if (accessibleContext2 != null && (accessible = accessibleContext2.getAccessibleParent()) instanceof JTree) {
                accessibleContext2 = this.prevAC;
            }
            if (propertyChangeEvent.getNewValue() instanceof Accessible) {
                accessibleContext3 = ((Accessible)propertyChangeEvent.getNewValue()).getAccessibleContext();
            } else if (propertyChangeEvent.getNewValue() instanceof Component && (accessible2 = Translator.getAccessible((Component)propertyChangeEvent.getNewValue())) != null) {
                accessibleContext3 = accessible2.getAccessibleContext();
            }
            if (accessibleContext3 != null && (accessible = accessibleContext3.getAccessibleParent()) instanceof JTree) {
                JTree jTree = (JTree)accessible;
                accessibleContext3 = new AccessibleJTreeNode(jTree, jTree.getSelectionPath(), null);
            }
            this.prevAC = accessibleContext3;
            this.accessBridge.debugString("  - about to call propertyActiveDescendentChange()");
            this.accessBridge.propertyActiveDescendentChange(propertyChangeEvent, accessibleContext, accessibleContext2, accessibleContext3);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Accessible accessible;
            if (AccessBridge.this.runningOnJDK1_4) {
                this.processFocusGained();
            } else if ((this.javaEventMask & 2L) != 0L && (accessible = Translator.getAccessible(focusEvent.getSource())) != null) {
                this.accessBridge.focusGained(focusEvent, accessible.getAccessibleContext());
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.processFocusGained();
        }

        private void processFocusGained() {
            Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            if (component == null) {
                return;
            }
            if (component instanceof JRootPane) {
                MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
                if (menuElementArray.length > 1) {
                    Component component2 = menuElementArray[menuElementArray.length - 2].getComponent();
                    Component component3 = menuElementArray[menuElementArray.length - 1].getComponent();
                    if (component3 instanceof JPopupMenu) {
                        FocusEvent focusEvent = new FocusEvent(component2, 1004);
                        this.accessBridge.focusGained(focusEvent, ((Accessible)((Object)component2)).getAccessibleContext());
                    } else if (component2 instanceof JPopupMenu) {
                        FocusEvent focusEvent = new FocusEvent(component3, 1004);
                        this.accessBridge.focusGained(focusEvent, ((Accessible)((Object)component3)).getAccessibleContext());
                    }
                }
            } else if (component instanceof Accessible) {
                FocusEvent focusEvent = new FocusEvent(component, 1004);
                this.accessBridge.focusGained(focusEvent, ((Accessible)((Object)component)).getAccessibleContext());
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            Accessible accessible;
            if ((this.javaEventMask & 4L) != 0L && (accessible = Translator.getAccessible(focusEvent.getSource())) != null) {
                this.accessBridge.focusLost(focusEvent, accessible.getAccessibleContext());
            }
        }

        @Override
        public void caretUpdate(CaretEvent caretEvent) {
            Accessible accessible;
            if ((this.javaEventMask & 8L) != 0L && (accessible = Translator.getAccessible(caretEvent.getSource())) != null) {
                this.accessBridge.caretUpdate(caretEvent, accessible.getAccessibleContext());
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            Accessible accessible;
            if ((this.javaEventMask & 0x10L) != 0L && (accessible = Translator.getAccessible(mouseEvent.getSource())) != null) {
                this.accessBridge.mouseClicked(mouseEvent, accessible.getAccessibleContext());
            }
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            Accessible accessible;
            if ((this.javaEventMask & 0x20L) != 0L && (accessible = Translator.getAccessible(mouseEvent.getSource())) != null) {
                this.accessBridge.mouseEntered(mouseEvent, accessible.getAccessibleContext());
            }
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            Accessible accessible;
            if ((this.javaEventMask & 0x40L) != 0L && (accessible = Translator.getAccessible(mouseEvent.getSource())) != null) {
                this.accessBridge.mouseExited(mouseEvent, accessible.getAccessibleContext());
            }
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Accessible accessible;
            if ((this.javaEventMask & 0x80L) != 0L && (accessible = Translator.getAccessible(mouseEvent.getSource())) != null) {
                this.accessBridge.mousePressed(mouseEvent, accessible.getAccessibleContext());
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            Accessible accessible;
            if ((this.javaEventMask & 0x100L) != 0L && (accessible = Translator.getAccessible(mouseEvent.getSource())) != null) {
                this.accessBridge.mouseReleased(mouseEvent, accessible.getAccessibleContext());
            }
        }

        @Override
        public void menuCanceled(MenuEvent menuEvent) {
            Accessible accessible;
            if ((this.javaEventMask & 0x200L) != 0L && (accessible = Translator.getAccessible(menuEvent.getSource())) != null) {
                this.accessBridge.menuCanceled(menuEvent, accessible.getAccessibleContext());
            }
        }

        @Override
        public void menuDeselected(MenuEvent menuEvent) {
            Accessible accessible;
            if ((this.javaEventMask & 0x400L) != 0L && (accessible = Translator.getAccessible(menuEvent.getSource())) != null) {
                this.accessBridge.menuDeselected(menuEvent, accessible.getAccessibleContext());
            }
        }

        @Override
        public void menuSelected(MenuEvent menuEvent) {
            Accessible accessible;
            if ((this.javaEventMask & 0x800L) != 0L && (accessible = Translator.getAccessible(menuEvent.getSource())) != null) {
                this.accessBridge.menuSelected(menuEvent, accessible.getAccessibleContext());
            }
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            Accessible accessible;
            if ((this.javaEventMask & 0x1000L) != 0L && (accessible = Translator.getAccessible(popupMenuEvent.getSource())) != null) {
                this.accessBridge.popupMenuCanceled(popupMenuEvent, accessible.getAccessibleContext());
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
            Accessible accessible;
            if ((this.javaEventMask & 0x2000L) != 0L && (accessible = Translator.getAccessible(popupMenuEvent.getSource())) != null) {
                this.accessBridge.popupMenuWillBecomeInvisible(popupMenuEvent, accessible.getAccessibleContext());
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            Accessible accessible;
            if ((this.javaEventMask & 0x4000L) != 0L && (accessible = Translator.getAccessible(popupMenuEvent.getSource())) != null) {
                this.accessBridge.popupMenuWillBecomeVisible(popupMenuEvent, accessible.getAccessibleContext());
            }
        }
    }

    protected class ObjectReferences {
        private Hashtable refs = new Hashtable(4);

        private String dump() {
            return this.refs.toString();
        }

        public void increment(Object object) {
            if (this.refs.containsKey(object)) {
                ++((Reference)this.refs.get((Object)object)).value;
            } else {
                this.refs.put(object, new Reference(1));
            }
        }

        public void decrement(Object object) {
            Reference reference = (Reference)this.refs.get(object);
            if (reference != null) {
                --reference.value;
                if (reference.value == 0) {
                    this.refs.remove(object);
                } else if (reference.value < 0) {
                    AccessBridge.this.debugString("ERROR: decrementing reference count below 0");
                }
            } else {
                AccessBridge.this.debugString("ERROR: object to decrement not in ObjectReferences table");
            }
        }

        protected class Reference {
            public int value;

            public Reference(int n) {
                this.value = n;
            }

            public String toString() {
                return "refCount: " + this.value;
            }
        }
    }

    protected class DefaultNativeWindowHandler
    implements NativeWindowHandler {
        protected DefaultNativeWindowHandler() {
        }

        @Override
        public Accessible getAccessibleFromNativeWindowHandle(int n) {
            Component component = this.getComponentFromNativeWindowHandle(n);
            if (component instanceof Accessible) {
                AccessBridge.this.saveContextToWindowHandleMapping(((Accessible)((Object)component)).getAccessibleContext(), n);
                return (Accessible)((Object)component);
            }
            return null;
        }

        protected Component getComponentFromNativeWindowHandle(int n) {
            if (AccessBridge.this.useJAWT_DLL) {
                AccessBridge.this.debugString("*** calling jawtGetComponentFromNativeWindowHandle");
                return AccessBridge.this.jawtGetComponentFromNativeWindowHandle(n);
            }
            AccessBridge.this.debugString("*** calling javaGetComponentFromNativeWindowHandle");
            Object[] objectArray = new Object[1];
            if (AccessBridge.this.javaGetComponentFromNativeWindowHandleMethod != null) {
                try {
                    objectArray[0] = new Integer(n);
                    Object object = AccessBridge.this.javaGetComponentFromNativeWindowHandleMethod.invoke((Object)AccessBridge.this.toolkit, objectArray);
                    if (object instanceof Accessible) {
                        AccessBridge.this.saveContextToWindowHandleMapping(((Accessible)object).getAccessibleContext(), n);
                    }
                    return (Component)object;
                }
                catch (InvocationTargetException invocationTargetException) {
                    AccessBridge.this.debugString("Exception: " + invocationTargetException.toString());
                }
                catch (IllegalAccessException illegalAccessException) {
                    AccessBridge.this.debugString("Exception: " + illegalAccessException.toString());
                }
            }
            return null;
        }
    }

    public static interface NativeWindowHandler {
        public Accessible getAccessibleFromNativeWindowHandle(int var1);
    }

    private class shutdownHook
    implements Runnable {
        private shutdownHook() {
        }

        @Override
        public void run() {
            AccessBridge.this.debugString("***** shutdownHook: shutting down...");
            AccessBridge.this.javaShutdown();
        }
    }
}

