/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.libreoffice.editor;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.api.model.uml.infrastructure.INote;
import com.modeliosoft.modelio.api.model.uml.statik.IArtifact;
import com.modeliosoft.modelio.core.app.StandardImageService;
import com.modeliosoft.modelio.core.model.change.IModelChangeListener;
import com.modeliosoft.modelio.core.model.change.IStatusChangeListener;
import com.modeliosoft.modelio.edition.extern.helper.ExternDocFileUtil;
import com.modeliosoft.modelio.edition.extern.helper.ExternDocLabelProvider;
import com.modeliosoft.modelio.edition.libreoffice.editor.IEditedDocumentViewer;
import com.modeliosoft.modelio.edition.libreoffice.editor.LibreOfficeEditor;
import com.modeliosoft.modelio.edition.libreoffice.editor.LibreOfficeEditorInput;
import com.modeliosoft.modelio.edition.libreoffice.plugin.LibreOfficeEditors;
import com.modeliosoft.modelio.edition.libreoffice.plugin.LibreOfficeLoader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.EditorPart;

public class LibreOfficeEditor
extends EditorPart {
    private IEditedDocumentViewer viewer;
    public static final String EDITOR_ID = "com.modeliosoft.modelio.edition.libreoffice.editor";
    private static final String CONTEXT_ID = "edition.extern.libreoffice.context";
    private ModelListener modelListener = null;

    private IElement getEditedElement() {
        LibreOfficeEditorInput input = this.getEditorInput();
        if (input == null) {
            return null;
        }
        return input.getEditedElement();
    }

    protected void setInput(IEditorInput input) {
        LibreOfficeEditorInput oldInput = this.getEditorInput();
        if (oldInput != null && oldInput.equals(input)) {
            return;
        }
        if (oldInput != null) {
            this.unregisterListener();
            this.viewer.close();
        }
        super.setInput(input);
        if (input == null) {
            this.viewer.close();
        } else {
            if (this.viewer != null) {
                try {
                    this.loadElement(this.getEditedElement());
                }
                catch (IOException e) {
                    LibreOfficeEditors.LOG.error((Throwable)e);
                    MessageDialog.openError(null, (String)("Cannot load " + this.getEditedElement()), (String)e.getLocalizedMessage());
                }
            }
            this.registerlistener((LibreOfficeEditorInput)input);
        }
        this.firePropertyChange(1);
    }

    void loadElement(IElement element) throws IOException {
        if (element instanceof IArtifact) {
            IArtifact art = (IArtifact)element;
            this.loadArtifact(art);
        } else if (element instanceof INote) {
            INote n = (INote)element;
            this.viewer.openDocument((InputStream)new ByteArrayInputStream(n.getContent().getBytes("UTF-8")), element.getElementStatus().isModifiable());
        } else if (element instanceof IExternDocument) {
            IExternDocument doc = (IExternDocument)element;
            this.loadExternDocument(doc);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        IElement element = this.getEditedElement();
        try {
            if (element instanceof IArtifact) {
                IArtifact art = (IArtifact)element;
                String fileName = art.getFileName();
                File f = new File(fileName);
                if (f.isFile()) {
                    FileOutputStream fs = new FileOutputStream(f);
                    this.viewer.saveDocument((OutputStream)new BufferedOutputStream(fs));
                    fs.close();
                }
            } else if (element instanceof INote) {
                INote n = (INote)element;
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                this.viewer.saveDocument((OutputStream)stream);
                n.setContent(stream.toString("UTF-8"));
                stream.close();
            } else if (element instanceof IExternDocument) {
                this.viewer.saveDocument();
            }
        }
        catch (IOException e) {
            LibreOfficeEditors.LOG.error((Throwable)e);
            MessageDialog.openError(null, (String)("Cannot save " + element), (String)e.getLocalizedMessage());
        }
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        IContextService service = (IContextService)site.getService(IContextService.class);
        service.activateContext(CONTEXT_ID);
        if (!(input instanceof LibreOfficeEditorInput)) {
            throw new PartInitException(input + " is not a LibreOfficeEditorInput.");
        }
        this.setInput(input);
    }

    public boolean isDirty() {
        return this.viewer != null && this.viewer.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        try {
            parent.setLayout((Layout)new FillLayout());
            this.viewer = (IEditedDocumentViewer)LibreOfficeLoader.getDocumentViewerClass().newInstance();
            this.viewer.createPartControl(parent);
            1 runnable = new /* Unavailable Anonymous Inner Class!! */;
            parent.getDisplay().asyncExec((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
        catch (IllegalAccessException e) {
            this.createErrorPartControl(parent, (Throwable)e);
        }
        catch (IOException e) {
            this.createErrorPartControl(parent, (Throwable)e);
        }
        catch (InstantiationException e) {
            this.createErrorPartControl(parent, (Throwable)e);
        }
    }

    public void setFocus() {
        this.viewer.setFocus();
    }

    void createErrorPartControl(Composite parent, Throwable e) {
        LibreOfficeEditors.LOG.error(e);
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
        Text t = new Text(parent, 770);
        StringWriter s = new StringWriter();
        s.append(e.getLocalizedMessage());
        s.append("\n\nDetail:\n-------\n");
        e.printStackTrace(new PrintWriter(s));
        t.setText(s.toString());
        parent.layout();
    }

    public void dispose() {
        this.unregisterListener();
        if (this.viewer != null) {
            this.viewer.close();
            this.viewer = null;
        }
        super.dispose();
    }

    public LibreOfficeEditorInput getEditorInput() {
        return (LibreOfficeEditorInput)super.getEditorInput();
    }

    private void loadExternDocument(IExternDocument doc) throws IOException {
        File f = ExternDocFileUtil.getFile((IExternDocument)doc);
        if (!f.isFile()) {
            this.viewer.createDocument(doc);
        }
        this.viewer.openDocument(f, doc.getElementStatus().isModifiable());
    }

    private File getAbsoluteFile(String fileName) {
        String f = fileName.replaceAll("\\{\\$project}", "");
        return new File(this.getEditorInput().getModelingSession().getProjectSpacePath(), f);
    }

    private void loadArtifact(IArtifact art) throws IOException, FileNotFoundException {
        String fileName = art.getFileName();
        File f = new File(fileName);
        if (!f.isFile()) {
            f = this.getAbsoluteFile(fileName);
        }
        if (!f.isFile()) {
            throw new FileNotFoundException("'" + fileName + "' not found.");
        }
        FileInputStream fs = new FileInputStream(f);
        this.viewer.openDocument((InputStream)new BufferedInputStream(fs), art.getElementStatus().isModifiable());
        fs.close();
    }

    public Image getTitleImage() {
        IElement el = this.getEditedElement();
        if (el == null) {
            return super.getTitleImage();
        }
        if (el instanceof IExternDocument) {
            return ExternDocLabelProvider.getIcon((IExternDocument)((IExternDocument)el));
        }
        return StandardImageService.getStereotypedImage((IElement)el, null);
    }

    public String getTitle() {
        IElement el = this.getEditedElement();
        if (el == null) {
            return super.getTitle();
        }
        if (el instanceof IExternDocument) {
            return ExternDocLabelProvider.getLabel((IExternDocument)((IExternDocument)el));
        }
        return el.getName();
    }

    private void unregisterListener() {
        if (this.modelListener != null) {
            this.modelListener.dispose();
            this.modelListener = null;
        }
    }

    private void registerlistener(LibreOfficeEditorInput input) {
        this.modelListener = new ModelListener(this, input);
        input.session.getModel().addModelListener((IModelChangeListener)this.modelListener);
        input.session.getModel().addStatusListener((IStatusChangeListener)this.modelListener);
    }

    static void displayErrordialog(String title, String message, boolean modal) {
        3 runnable = new /* Unavailable Anonymous Inner Class!! */;
        if (modal) {
            Display.getDefault().syncExec((Runnable)runnable);
        } else {
            Display.getDefault().asyncExec((Runnable)runnable);
        }
    }

    public boolean isSaveOnCloseNeeded() {
        return true;
    }

    static /* synthetic */ IEditedDocumentViewer access$1(LibreOfficeEditor libreOfficeEditor) {
        return libreOfficeEditor.viewer;
    }

    static /* synthetic */ void access$2(LibreOfficeEditor libreOfficeEditor, int n) {
        libreOfficeEditor.firePropertyChange(n);
    }

    static /* synthetic */ IElement access$3(LibreOfficeEditor libreOfficeEditor) {
        return libreOfficeEditor.getEditedElement();
    }
}

