/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.libreoffice.editor;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.core.app.O;
import com.modeliosoft.modelio.core.documents.DocumentFormat;
import com.modeliosoft.modelio.edition.extern.helper.ExternDocFileUtil;
import com.modeliosoft.modelio.edition.libreoffice.editor.IEditedDocumentViewer;
import com.modeliosoft.modelio.edition.libreoffice.plugin.LibreOfficeEditors;
import com.sun.star.beans.PropertyState;
import com.sun.star.beans.PropertyValue;
import com.sun.star.comp.beans.CallWatchThread;
import com.sun.star.comp.beans.ErrorTranslator;
import com.sun.star.comp.beans.NoConnectionException;
import com.sun.star.comp.beans.NoDocumentException;
import com.sun.star.comp.beans.OfficeDocument;
import com.sun.star.comp.beans.SwtLinuxOOoBean;
import com.sun.star.comp.beans.SystemWindowException;
import com.sun.star.frame.XDesktop;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.task.ErrorCodeIOException;
import com.sun.star.text.XText;
import com.sun.star.text.XTextDocument;
import com.sun.star.uno.RuntimeException;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import com.sun.star.uri.ExternalUriReferenceTranslator;
import com.sun.star.util.CloseVetoException;
import com.sun.star.util.XModifyListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.swt.widgets.Composite;

public class LibreOfficeSwtLinuxDocumentViewer
implements IEditedDocumentViewer {
    private SwtLinuxOOoBean aBean;

    public LibreOfficeSwtLinuxDocumentViewer() {
        try {
            System.setProperty("sun.awt.noerasebackground", "true");
            System.setProperty("sun.awt.xembedserver", "true");
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
    }

    public void close() {
        this.aBean.stopOOoConnection();
    }

    public void closeDocument() throws IOException {
        this.aBean.closeDocument();
    }

    public void createDocument(IExternDocument doc) throws IOException {
        this.aBean.setVisible(true);
        DocumentFormat format = O.getDefault().getDocumentFormatsRegistry().getFormat(doc);
        if (format.getData() == null || format.getData().isEmpty()) {
            throw new IOException("'" + format.getLabel() + "' rich notes cannot be created with OpenOffice.");
        }
        try {
            this.aBean.getOOoConnection();
            this.aBean.loadFromURL(format.getData(), null);
            this.aBean.storeAsURL(this.createUNOFileURL(ExternDocFileUtil.getFile((IExternDocument)doc)), null);
        }
        catch (NoDocumentException e) {
            throw new IOException(e);
        }
        catch (CloseVetoException e) {
            throw new IOException(e);
        }
        catch (NoConnectionException e) {
            throw new IOException(e);
        }
    }

    public void createPartControl(Composite parent) {
        this.aBean = new SwtLinuxOOoBean(parent, 0);
    }

    public String getAsHtml() throws IOException {
        try {
            String conversionFilter = this.getHtmlExportFilterName();
            if (conversionFilter == null) {
                throw new IOException("This document does not support HTML export.");
            }
            PropertyValue[] conversionProperties = new PropertyValue[3];
            conversionProperties[0] = new PropertyValue();
            conversionProperties[0].Name = "Overwrite";
            conversionProperties[0].Value = new Boolean(true);
            conversionProperties[1] = new PropertyValue();
            conversionProperties[1].Name = "FilterName";
            conversionProperties[1].Value = conversionFilter;
            conversionProperties[2] = new PropertyValue();
            conversionProperties[2].Name = "CharacterSet";
            conversionProperties[2].Value = "UTF-8";
            ByteArrayOutputStream stream = new ByteArrayOutputStream(20000);
            this.aBean.storeToStream((OutputStream)stream, conversionProperties);
            return stream.toString("UTF-8");
        }
        catch (NoConnectionException e) {
            throw new IOException(e);
        }
        catch (NoDocumentException e) {
            throw new IOException(e);
        }
    }

    public String getAsText() throws IOException {
        try {
            OfficeDocument model = this.aBean.getDocument();
            XTextDocument myDoc = (XTextDocument)UnoRuntime.queryInterface(XTextDocument.class, (Object)model);
            XText xText = myDoc.getText();
            return xText.getString();
        }
        catch (NoConnectionException e) {
            throw new IOException(e);
        }
    }

    public Composite getControl() {
        return this.aBean;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isDirty() {
        if (this.aBean.isDisposed()) {
            LibreOfficeEditors.LOG.warning(new IllegalStateException(this.aBean + " disposed, let's say it is not modified.").fillInStackTrace());
            return false;
        }
        SwtLinuxOOoBean bean = this.aBean;
        CallWatchThread watchDog = new CallWatchThread(1000L, "LibreOfficeSwtDocumentViewer.isModified()");
        try {
            boolean ret;
            OfficeDocument doc = bean.getDocument();
            boolean bl = ret = doc != null && doc.isModified();
            return bl;
        }
        catch (RuntimeException e) {
            if (e.getMessage().contains("java.lang.InterruptedException")) {
                return false;
            }
            LibreOfficeEditors.LOG.warning((Throwable)e);
            return false;
        }
        catch (NoConnectionException e) {
            LibreOfficeEditors.LOG.warning((Throwable)e);
            return false;
        }
        finally {
            try {
                watchDog.cancel();
            }
            catch (InterruptedException e) {
                LibreOfficeEditors.LOG.warning((Throwable)e);
            }
        }
    }

    public void openDocument(InputStream stream, boolean modifiable) throws IOException {
        try {
            PropertyValue[] args = new PropertyValue[]{new PropertyValue("ReadOnly", -1, (Object)new Boolean(!modifiable), PropertyState.DIRECT_VALUE)};
            this.aBean.loadFromStream(stream, args);
            this.aBean.aquireSystemWindow();
        }
        catch (CloseVetoException e) {
            throw new IOException(e);
        }
        catch (NoConnectionException e) {
            throw new IOException(e);
        }
        catch (SystemWindowException e) {
            throw new IOException(e);
        }
    }

    public void openDocument(File file, boolean modifiable) throws IOException {
        try {
            String aURL = this.createUNOFileURL(file);
            PropertyValue[] args = new PropertyValue[]{new PropertyValue("ReadOnly", -1, (Object)new Boolean(!modifiable), PropertyState.DIRECT_VALUE), new PropertyValue("Preview", -1, (Object)new Boolean(!modifiable), PropertyState.DIRECT_VALUE)};
            this.aBean.loadFromURL(aURL, args);
            this.aBean.aquireSystemWindow();
        }
        catch (CloseVetoException e) {
            throw new IOException(e);
        }
        catch (NoConnectionException e) {
            throw new IOException(e);
        }
        catch (SystemWindowException e) {
            throw new IOException(e);
        }
        catch (UnsatisfiedLinkError e) {
            throw new IOException(e);
        }
    }

    public void saveDocument(OutputStream stream) throws IOException {
        try {
            this.aBean.storeToStream(stream, null);
        }
        catch (NoConnectionException e) {
            throw new IOException(e);
        }
        catch (NoDocumentException e) {
            throw new IOException(e);
        }
    }

    public void saveDocument() throws IOException {
        try {
            OfficeDocument aDocument = this.aBean.getDocument();
            if (aDocument == null) {
                throw new NoDocumentException();
            }
            CallWatchThread aCallWatchThread = new CallWatchThread(10000L, "storeToURL");
            try {
                aDocument.store();
            }
            catch (ErrorCodeIOException e) {
                throw new IOException(ErrorTranslator.getErrorMessage((ErrorCodeIOException)e), e);
            }
            catch (com.sun.star.io.IOException aExc) {
                throw new IOException(aExc);
            }
            aCallWatchThread.cancel();
        }
        catch (InterruptedException aExc) {
            throw new IOException(aExc);
        }
        catch (NoConnectionException e) {
            throw new IOException(e);
        }
        catch (NoDocumentException e) {
            throw new IOException(e);
        }
    }

    public void setFocus() {
        if (this.aBean != null && !this.aBean.isDisposed()) {
            this.aBean.setFocus();
        }
    }

    public void terminate() throws NoConnectionException {
        XDesktop xDesktop = null;
        xDesktop = this.aBean.getOOoDesktop();
        this.aBean.setVisible(false);
        this.aBean.stopOOoConnection();
        if (xDesktop != null) {
            xDesktop.terminate();
        }
    }

    private String createUNOFileURL(File newfile) throws NoConnectionException {
        XComponentContext xRemoteContext;
        URL before = null;
        try {
            before = newfile.toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        try {
            xRemoteContext = this.aBean.getOOoConnection().getComponentContext();
        }
        catch (NoConnectionException e) {
            throw e;
        }
        catch (Exception aExc) {
            throw new NoConnectionException((Throwable)aExc);
        }
        if (xRemoteContext == null) {
            throw new NoConnectionException();
        }
        String myUNOFileURL = ExternalUriReferenceTranslator.create((XComponentContext)xRemoteContext).translateToInternal(before.toExternalForm());
        if (myUNOFileURL.isEmpty() && !newfile.getPath().isEmpty()) {
            throw new IllegalArgumentException("'" + before.toString() + "' URL conversion failed. Filelocation " + "contains illegal characters: " + newfile.getPath());
        }
        return myUNOFileURL;
    }

    private String getHtmlExportFilterName() throws NoConnectionException {
        XServiceInfo xInfo = (XServiceInfo)UnoRuntime.queryInterface(XServiceInfo.class, (Object)this.aBean.getDocument());
        if (xInfo != null) {
            if (xInfo.supportsService("com.sun.star.text.TextDocument")) {
                return "HTML (StarWriter)";
            }
            if (xInfo.supportsService("com.sun.star.text.WebDocument")) {
                return "HTML";
            }
            if (xInfo.supportsService("com.sun.star.sheet.SpreadsheetDocument")) {
                return "HTML (StarCalc)";
            }
        }
        return null;
    }

    private void addModifylistener(OfficeDocument officeDocument) {
        officeDocument.addModifyListener((XModifyListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    public boolean isDisposed() throws IllegalStateException {
        if (this.aBean == null) {
            throw new IllegalStateException("Viewer is not yet initialized.");
        }
        return this.aBean.isDisposed();
    }
}

