/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.libreoffice.plugin;

import com.modeliosoft.modelio.api.model.uml.infrastructure.IElement;
import com.modeliosoft.modelio.api.model.uml.infrastructure.IExternDocument;
import com.modeliosoft.modelio.core.IModelingSession;
import com.modeliosoft.modelio.core.documents.IDocumentDiffMerger;
import com.modeliosoft.modelio.edition.extern.plugin.AbstractDocumentEditor;
import com.modeliosoft.modelio.edition.libreoffice.editor.IEditedDocumentViewer;
import com.modeliosoft.modelio.edition.libreoffice.editor.LibreOfficeEditorInput;
import com.modeliosoft.modelio.edition.libreoffice.plugin.LibreOfficeEditors;
import com.modeliosoft.modelio.edition.libreoffice.plugin.LibreOfficeLoader;
import java.io.IOException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;

public class LibreOfficeEditorProvider
extends AbstractDocumentEditor {
    private Boolean usable = null;

    protected IEditorInput createEditorInput(IModelingSession session, IElement target) {
        return new LibreOfficeEditorInput(session, target);
    }

    protected String getEditorId(IElement target) {
        return "com.modeliosoft.modelio.edition.libreoffice.editor";
    }

    public boolean isUsable() {
        if (this.usable == null) {
            this.usable = this.computeUsable();
        }
        return this.usable;
    }

    private boolean computeUsable() {
        ClassLoader classLoader;
        block6: {
            classLoader = LibreOfficeLoader.getClassLoader();
            if (classLoader != null) break block6;
            return false;
        }
        try {
            Class<?> cl = classLoader.loadClass("com.sun.star.lib.connections.pipe.PipeConnection");
            if (LibreOfficeLoader.isWindows() && System.getProperty("os.arch", "").contains("64")) {
                LibreOfficeEditors.LOG.warning("LibreOffice is currently not supported on Windows 64 bits platforms.");
                return false;
            }
            return true;
        }
        catch (IOException e) {
            LibreOfficeEditors.LOG.error("Failed loading LibreOffice/OpenOffice classes:");
            LibreOfficeEditors.LOG.error((Throwable)e);
            MessageDialog.openError((Shell)PlatformUI.getWorkbench().getModalDialogShellProvider().getShell(), (String)"Failed loading LibreOffice/OpenOffice", (String)e.getLocalizedMessage());
            return false;
        }
        catch (ClassNotFoundException e) {
            LibreOfficeEditors.LOG.warning("Failed finding LibreOffice/OpenOffice classes:");
            LibreOfficeEditors.LOG.warning((Throwable)e);
            return false;
        }
        catch (UnsatisfiedLinkError e) {
            LibreOfficeEditors.LOG.warning("Failed loading LibreOffice/OpenOffice classes:");
            LibreOfficeEditors.LOG.warning((Throwable)e);
            return false;
        }
    }

    public IDocumentDiffMerger getDiffMerge() {
        return null;
    }

    public boolean createEmptyFile(IElement target) {
        if (!(target instanceof IExternDocument)) {
            return false;
        }
        try {
            Class cl = LibreOfficeLoader.getDocumentViewerClass();
            IEditedDocumentViewer viewer = (IEditedDocumentViewer)cl.newInstance();
            Shell sh = new Shell(Display.getCurrent());
            viewer.createPartControl((Composite)sh);
            while (Display.getCurrent().readAndDispatch()) {
            }
            viewer.createDocument((IExternDocument)target);
            viewer.close();
            sh.dispose();
            return true;
        }
        catch (IOException e) {
            LibreOfficeEditors.LOG.error((Throwable)e);
            return false;
        }
        catch (InstantiationException e) {
            LibreOfficeEditors.LOG.error((Throwable)e);
            return false;
        }
        catch (IllegalAccessException e) {
            LibreOfficeEditors.LOG.error((Throwable)e);
            return false;
        }
    }
}

