/*
 * Decompiled with CFR 0.152.
 */
package com.modeliosoft.modelio.edition.libreoffice.plugin;

import com.modeliosoft.modelio.edition.libreoffice.Activator;
import com.modeliosoft.modelio.edition.libreoffice.editor.IEditedDocumentViewer;
import com.modeliosoft.modelio.edition.libreoffice.plugin.LibreOfficeEditors;
import com.sun.star.lib.loader.InstallationFinder;
import com.sun.star.lib.loader.Loader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

/*
 * Exception performing whole class analysis ignored.
 */
public class LibreOfficeLoader {
    private static ClassLoader oooClassLoader = null;

    public static ClassLoader getClassLoader() throws IOException {
        if (oooClassLoader == null) {
            LibreOfficeLoader.createClassLoader();
        }
        return oooClassLoader;
    }

    private static void createClassLoader() throws IOException {
        LibreOfficeLoader.findInstallPathFromPreferences();
        List ooClassPath = Loader.getUnoClassPath();
        if (ooClassPath != null) {
            URL programUrl = null;
            for (URL url : ooClassPath) {
                if (!url.getProtocol().equals("file")) continue;
                try {
                    File dir = new File(new URI(url.toString())).getParentFile();
                    if (!InstallationFinder.isOooPathValid((File)dir)) continue;
                    File programDir = new File(dir, "program");
                    System.setProperty("UNO_PATH", programDir.getAbsolutePath());
                    programUrl = programDir.toURI().toURL();
                }
                catch (URISyntaxException e) {
                    LibreOfficeEditors.LOG.warning((Throwable)e);
                }
                catch (MalformedURLException e) {
                    LibreOfficeEditors.LOG.warning((Throwable)e);
                }
            }
            if (programUrl == null) {
                throw LibreOfficeLoader.getFileNotFoundIn((String)"OpenOffice installation directory not found in:\n", (List)ooClassPath);
            }
            Bundle bundle = FrameworkUtil.getBundle(LibreOfficeLoader.class);
            URL secondBinUrl = FileLocator.find((Bundle)bundle, (IPath)new Path("runtime/bin"), null);
            if (secondBinUrl == null) {
                throw new UnsatisfiedLinkError("Cannot find runtime/bin directory in '" + bundle.getSymbolicName() + "' bundle.");
            }
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(secondBinUrl);
            urls.add(programUrl);
            if (LibreOfficeLoader.needOfficeBeanLib()) {
                URL officeBeanLibUrl = LibreOfficeLoader.lookForOfficeBeanLib((List)ooClassPath);
                urls.add(officeBeanLibUrl);
            }
            if (LibreOfficeLoader.needOfficeBeanJar()) {
                URL officebeanJarUrl = LibreOfficeLoader.lookForOfficeBeanJar((List)ooClassPath);
                if (officebeanJarUrl == null) {
                    throw LibreOfficeLoader.getFileNotFoundIn((String)"officebean.jar not found in class path:\n", (List)ooClassPath);
                }
                urls.add(officebeanJarUrl);
            }
            urls.addAll(ooClassPath);
            oooClassLoader = new URLClassLoader(urls.toArray(new URL[urls.size()]), LibreOfficeLoader.class.getClassLoader());
            LibreOfficeLoader.installPreferenceListener();
        }
    }

    private static boolean needOfficeBeanJar() {
        return false;
    }

    private static boolean needOfficeBeanLib() {
        return false;
    }

    public static boolean isWindows() {
        return System.getProperty("os.name").toLowerCase().startsWith("win");
    }

    private static URL lookForOfficeBeanLib(List<URL> urls) throws FileNotFoundException {
        URL ret = LibreOfficeLoader.tryLookForLibFile((String)"officebean", urls);
        if (ret == null) {
            ret = LibreOfficeLoader.tryLookForLibFile((String)"officebeanlo", urls);
        }
        if (ret != null) {
            return ret;
        }
        throw LibreOfficeLoader.getFileNotFoundIn((String)"officebean native library not found in the class path:\n", urls);
    }

    private static URL lookForOfficeBeanJar(List<URL> ooClassPath) {
        String libFileName = "officebean.jar";
        for (URL url : ooClassPath) {
            if (!url.getProtocol().equals("file")) continue;
            try {
                File dir = new File(new URI(url.toString()));
                if (!dir.isDirectory()) {
                    dir = dir.getParentFile();
                }
                while (dir != null && dir.isDirectory()) {
                    File f = new File(dir, "officebean.jar");
                    if (f.isFile()) {
                        return f.toURI().toURL();
                    }
                    dir = dir.getParentFile();
                }
            }
            catch (URISyntaxException e) {
                LibreOfficeEditors.LOG.warning((Throwable)e);
            }
            catch (MalformedURLException e) {
                LibreOfficeEditors.LOG.warning((Throwable)e);
            }
        }
        return null;
    }

    private static void installPreferenceListener() {
        Activator.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private static void findInstallPathFromPreferences() {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        String installPath = store.getString("oooInstallPath");
        if (installPath != null && InstallationFinder.isProgramPathValid((File)new File(installPath))) {
            System.setProperty("com.sun.star.lib.loader.unopath", installPath);
        }
    }

    private static FileNotFoundException getFileNotFoundIn(String msg, List<URL> ooClassPath) {
        StringBuilder s = new StringBuilder();
        s.append(msg);
        for (URL url : ooClassPath) {
            s.append(" - ");
            s.append(url.toString());
            s.append("\n");
        }
        return new FileNotFoundException(s.toString());
    }

    private static URL tryLookForLibFile(String libName, List<URL> urls) {
        String libFileName = System.mapLibraryName(libName);
        for (URL url : urls) {
            if (!url.getProtocol().equals("file")) continue;
            try {
                File dir = new File(new URI(url.toString()));
                if (!dir.isDirectory()) {
                    dir = dir.getParentFile();
                }
                while (dir != null && dir.isDirectory()) {
                    File f = new File(dir, libFileName);
                    if (f.isFile()) {
                        return dir.toURI().toURL();
                    }
                    dir = dir.getParentFile();
                }
            }
            catch (URISyntaxException e) {
                LibreOfficeEditors.LOG.warning((Throwable)e);
            }
            catch (MalformedURLException e) {
                LibreOfficeEditors.LOG.warning((Throwable)e);
            }
        }
        return null;
    }

    public static Class<? extends IEditedDocumentViewer> getDocumentViewerClass() throws IOException {
        Class<?> cl;
        ClassLoader officeClassLoader = LibreOfficeLoader.getClassLoader();
        String className = LibreOfficeLoader.isWindows() ? "com.modeliosoft.modelio.edition.libreoffice.editor.LibreOfficeSwtWinDocumentViewer" : "com.modeliosoft.modelio.edition.libreoffice.editor.LibreOfficeSwtLinuxDocumentViewer";
        try {
            cl = officeClassLoader.loadClass(className);
        }
        catch (ClassNotFoundException e) {
            throw new IOException("'" + className + "' not found.", e);
        }
        if (!IEditedDocumentViewer.class.isAssignableFrom(cl)) {
            throw new IOException("'" + className + "' class does not implement IEditedDocumentViewer.");
        }
        return cl;
    }

    static /* synthetic */ void access$0(ClassLoader classLoader) {
        oooClassLoader = classLoader;
    }
}

