/*
 * Decompiled with CFR 0.152.
 */
package com.sun.star.comp.beans;

import com.sun.star.awt.Rectangle;
import com.sun.star.awt.WindowClass;
import com.sun.star.awt.WindowDescriptor;
import com.sun.star.awt.XToolkit;
import com.sun.star.awt.XVclWindowPeer;
import com.sun.star.awt.XWindow;
import com.sun.star.awt.XWindowPeer;
import com.sun.star.beans.NamedValue;
import com.sun.star.comp.beans.JavaWindowPeerFake;
import com.sun.star.comp.beans.OfficeConnection;
import com.sun.star.comp.beans.OfficeWindow;
import com.sun.star.lang.EventObject;
import com.sun.star.lang.XEventListener;
import com.sun.star.lang.XMultiComponentFactory;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.uno.Any;
import com.sun.star.uno.Type;
import com.sun.star.uno.UnoRuntime;
import com.sun.star.uno.XComponentContext;
import java.awt.Canvas;
import java.awt.Component;

public class LocalOfficeWindow
extends Canvas
implements OfficeWindow,
XEventListener {
    private transient OfficeConnection mConnection;
    private boolean bPeer = false;
    private transient XWindowPeer mParentProxy;
    private transient XWindowPeer mWindow;
    private static final long serialVersionUID = 1L;

    protected LocalOfficeWindow(OfficeConnection connection) {
        this.mConnection = connection;
        this.mConnection.addEventListener((XEventListener)this);
    }

    @Deprecated
    public Component getAWTComponent() {
        return this;
    }

    @Deprecated
    public XWindowPeer getUNOWindowPeer() {
        if (this.mWindow == null) {
            this.createUNOWindowPeer();
        }
        return this.mWindow;
    }

    public void disposing(EventObject source) {
        this.mWindow = null;
        this.mConnection = null;
    }

    private XToolkit queryAWTToolkit() throws com.sun.star.uno.Exception {
        XComponentContext xContext = this.mConnection.getComponentContext();
        if (xContext != null) {
            XMultiComponentFactory compfactory = xContext.getServiceManager();
            XMultiServiceFactory factory = (XMultiServiceFactory)UnoRuntime.queryInterface(XMultiServiceFactory.class, (Object)compfactory);
            Object object = factory.createInstance("com.sun.star.awt.Toolkit");
            return (XToolkit)UnoRuntime.queryInterface(XToolkit.class, (Object)object);
        }
        return null;
    }

    private synchronized void aquireSystemWindow() {
        if (!this.bPeer) {
            XVclWindowPeer xVclWindowPeer = (XVclWindowPeer)UnoRuntime.queryInterface(XVclWindowPeer.class, (Object)this.mWindow);
            xVclWindowPeer.setProperty("PluginParent", (Object)this.getWrappedWindowHandle());
            this.bPeer = true;
            XWindow aWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.mWindow);
            aWindow.setVisible(true);
        }
    }

    private synchronized void releaseSystemWindow() {
        if (this.bPeer) {
            XVclWindowPeer xVclWindowPeer;
            XWindow aWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.mWindow);
            if (aWindow != null) {
                aWindow.setVisible(false);
            }
            if ((xVclWindowPeer = (XVclWindowPeer)UnoRuntime.queryInterface(XVclWindowPeer.class, (Object)this.mWindow)) != null) {
                xVclWindowPeer.setProperty("PluginParent", (Object)new Long(0L));
            }
            this.bPeer = false;
        }
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.aquireSystemWindow();
        } else {
            this.releaseSystemWindow();
        }
    }

    private synchronized XWindowPeer createUNOWindowPeer() {
        try {
            JavaWindowPeerFake parentPeer;
            int type = this.getNativeWindowSystemType();
            if (this.isShowing()) {
                parentPeer = new JavaWindowPeerFake(this.getWrappedWindowHandle(), type);
                this.bPeer = true;
            } else {
                parentPeer = null;
                this.bPeer = false;
            }
            Rectangle aRect = new Rectangle(0, 0, 20, 20);
            WindowDescriptor desc = new WindowDescriptor();
            desc.Type = WindowClass.TOP;
            desc.Parent = parentPeer;
            desc.Bounds = aRect;
            desc.WindowServiceName = "workwindow";
            desc.WindowAttributes = type == 1 ? 1 : 0;
            this.mWindow = this.queryAWTToolkit().createWindow(desc);
            XWindow aWindow = (XWindow)UnoRuntime.queryInterface(XWindow.class, (Object)this.mWindow);
            aWindow.setVisible(this.bPeer);
        }
        catch (com.sun.star.uno.Exception exception) {
            // empty catch block
        }
        return this.mWindow;
    }

    @Override
    public void removeNotify() {
        try {
            this.releaseSystemWindow();
        }
        catch (Exception e) {
            System.err.println("LocaleOfficeWindow.removeNotify: Exception in releaseSystemWindow.");
            System.err.println(e.getMessage());
            e.printStackTrace(System.err);
        }
        super.removeNotify();
    }

    private native long getNativeWindow();

    private native int getNativeWindowSystemType();

    protected Any getWrappedWindowHandle() {
        String vendor;
        NamedValue window = new NamedValue("WINDOW", (Object)new Any(new Type(Long.class), (Object)new Long(this.getNativeWindow())));
        NamedValue xembed = new NamedValue("XEMBED", (Object)new Any(new Type(Boolean.class), (Object)new Boolean(false)));
        if (this.getNativeWindowSystemType() == 6 && (vendor = System.getProperty("java.vendor")).equals("Sun Microsystems Inc.") && Boolean.valueOf(System.getProperty("sun.awt.xembedserver")).booleanValue()) {
            xembed = new NamedValue("XEMBED", (Object)new Any(new Type(Boolean.class), (Object)new Boolean(true)));
        }
        return new Any(new Type("[]com.sun.star.beans.NamedValue"), (Object)new NamedValue[]{window, xembed});
    }
}

